/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.component.Wizard;
import com.sun.webui.jsf.component.WizardBranch;
import com.sun.webui.jsf.component.WizardBranchSteps;
import com.sun.webui.jsf.component.WizardStep;
import com.sun.webui.jsf.component.WizardSubstepBranch;
import com.sun.webui.jsf.event.WizardEvent;
import com.sun.webui.jsf.model.WizardModel;
import com.sun.webui.jsf.model.WizardStepList;
import com.sun.webui.jsf.model.WizardStepListBase;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class WizardModelBase
implements WizardModel {
    private ArrayList<WizardStep> wizardSteps;
    private final WizardState wizardState = new WizardState();
    private WizardStepList wizardStepList;

    @Override
    public void initialize(Wizard wizard) {
        this.wizardSteps = new ArrayList();
        List steps = (List)wizard.getSteps();
        if (steps == null) {
            steps = wizard.getChildren();
        }
        ListIterator childIterator = steps.listIterator();
        this.buildStepList(childIterator, this.wizardSteps);
        this.wizardStepList = new WizardStepListBase(this);
    }

    protected void buildStepList(ListIterator childIterator, ArrayList<WizardStep> steps) {
        while (childIterator.hasNext()) {
            Object step = childIterator.next();
            if (step instanceof WizardBranch) {
                WizardBranch branch = (WizardBranch)((Object)step);
                if (branch.isTaken()) {
                    this.buildStepList(branch.getChildren().listIterator(), steps);
                    continue;
                }
                steps.add((WizardStep)((Object)step));
                break;
            }
            if (step instanceof WizardBranchSteps) {
                WizardBranchSteps branchSteps = (WizardBranchSteps)((Object)step);
                if (!branchSteps.isTaken()) continue;
                this.buildStepList(branchSteps.getChildren().listIterator(), steps);
                continue;
            }
            if (step instanceof WizardSubstepBranch) {
                WizardSubstepBranch substep = (WizardSubstepBranch)((Object)step);
                if (!substep.isTaken()) continue;
                this.buildStepList(substep.getChildren().listIterator(), steps);
                continue;
            }
            if (!(step instanceof WizardStep)) continue;
            if (this.wizardState.getHasStepHelp() == null && ((WizardStep)((Object)step)).getHelp() != null) {
                this.wizardState.setHasStepHelp(Boolean.TRUE);
            }
            steps.add((WizardStep)((Object)step));
        }
    }

    @Override
    public Iterator getWizardStepIterator() {
        return this.wizardSteps.iterator();
    }

    @Override
    public WizardStepList getWizardStepList() {
        return this.wizardStepList;
    }

    @Override
    public WizardStep getFirstStep() {
        return this.wizardSteps.get(0);
    }

    public WizardStep getLastStep() {
        return this.wizardSteps.get(this.wizardSteps.size() - 1);
    }

    protected int getStepIndex(String id) {
        for (int i = 0; i < this.wizardSteps.size(); ++i) {
            WizardStep step = this.wizardSteps.get(i);
            if (!id.equals(step.getId())) continue;
            return i;
        }
        return this.wizardState.getCurrentStep();
    }

    @Override
    public WizardStep getNextStep(WizardStep step) {
        WizardStep next = null;
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            if (i != -1) {
                next = this.wizardSteps.get(++i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return next;
    }

    @Override
    public WizardStep getPreviousStep(WizardStep step) {
        WizardStep previous = null;
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            if (i != -1) {
                previous = this.wizardSteps.get(--i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return previous;
    }

    @Override
    public WizardStep getCurrentStep() {
        WizardStep step = null;
        try {
            step = this.wizardSteps.get(this.wizardState.getCurrentStep());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return step;
    }

    @Override
    public boolean isCurrentStep(WizardStep step) {
        boolean result = false;
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            result = this.wizardState.getCurrentStep() == i;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public boolean isFinishStep(WizardStep step) {
        if (step == null) {
            return false;
        }
        return step.isFinish();
    }

    @Override
    public boolean isResultsStep(WizardStep step) {
        if (step == null) {
            return false;
        }
        return step.isResults();
    }

    @Override
    public boolean isBranch(WizardStep step) {
        return step instanceof WizardBranch;
    }

    @Override
    public String getPlaceholderText(WizardStep step) {
        if (step == null) {
            return null;
        }
        return ((WizardBranch)step).getPlaceholderText();
    }

    @Override
    public boolean isSubstep(WizardStep step) {
        if (step == null) {
            return false;
        }
        return step.getParent() instanceof WizardSubstepBranch;
    }

    @Override
    public boolean canGotoStep(WizardStep step) {
        try {
            int i = this.wizardSteps.indexOf((Object)step);
            return this.wizardState.getCurrentStep() > i;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isPreviousDisabled(WizardStep step) {
        WizardStep first = this.getFirstStep();
        if (first == null) {
            return false;
        }
        return first.getId().equals(step.getId());
    }

    @Override
    public boolean isNextDisabled(WizardStep step) {
        return false;
    }

    @Override
    public boolean isFinishDisabled(WizardStep step) {
        return false;
    }

    @Override
    public boolean isCancelDisabled(WizardStep step) {
        return false;
    }

    @Override
    public boolean isCloseDisabled(WizardStep step) {
        return false;
    }

    @Override
    public boolean hasPrevious(WizardStep step) {
        if (step == null) {
            return false;
        }
        return !this.isResultsStep(step);
    }

    @Override
    public boolean hasNext(WizardStep step) {
        if (step == null) {
            return false;
        }
        return !this.isFinishStep(step) && !this.isResultsStep(step);
    }

    @Override
    public boolean hasCancel(WizardStep step) {
        if (step == null) {
            return false;
        }
        return !this.isResultsStep(step);
    }

    @Override
    public boolean hasClose(WizardStep step) {
        if (step == null) {
            return false;
        }
        return this.isResultsStep(step);
    }

    @Override
    public boolean hasFinish(WizardStep step) {
        if (step == null) {
            return false;
        }
        return this.isFinishStep(step);
    }

    @Override
    public boolean hasStepHelp() {
        if (this.wizardState.getHasStepHelp() == null) {
            return false;
        }
        return this.wizardState.getHasStepHelp();
    }

    @Override
    public boolean isComplete() {
        return this.wizardState.isComplete();
    }

    @Override
    public void complete() {
        this.wizardSteps = null;
        this.wizardState.reset();
    }

    @Override
    public boolean decode(int event, boolean prematureRender) {
        if (prematureRender) {
            return false;
        }
        return this.wizardState.decode(event);
    }

    @Override
    public boolean validate(int event, boolean prematureRender) {
        if (prematureRender) {
            return false;
        }
        return this.wizardState.validate(event);
    }

    @Override
    public boolean update(int event, boolean prematureRender) {
        if (prematureRender) {
            return false;
        }
        return this.wizardState.update(event);
    }

    @Override
    public boolean handleEvent(WizardEvent event) {
        boolean returnValue = true;
        switch (event.getNavigationEvent()) {
            case 6: {
                this.wizardState.nextStep();
                break;
            }
            case 7: {
                this.wizardState.previousStep();
                break;
            }
            case 2: {
                int i = this.wizardState.getCurrentStep() + 1;
                if (i == this.wizardSteps.size()) {
                    this.wizardState.close();
                    break;
                }
                this.wizardState.finishStep();
                break;
            }
            case 3: {
                String gotoStepId = event.getGotoStepId();
                if (gotoStepId == null) break;
                int index = this.getStepIndex(gotoStepId);
                this.wizardState.gotoStep(index);
                break;
            }
            case 0: {
                this.wizardState.cancel();
                break;
            }
            case 1: {
                this.wizardState.close();
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 12: {
                break;
            }
        }
        return returnValue;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[3];
        int i = 0;
        state[i++] = this.wizardState.getState();
        state[i++] = this.wizardState.getCurrentStep();
        state[i++] = this.wizardState.getHasStepHelp();
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] stateArray = (Object[])state;
        int i = 0;
        this.wizardState.setState((Integer)stateArray[i++]);
        this.wizardState.setCurrentStep((Integer)stateArray[i++]);
        this.wizardState.setHasStepHelp((Boolean)stateArray[i++]);
    }

    public void setTransient(boolean transientFlag) {
    }

    public boolean isTransient() {
        return false;
    }

    private static final class WizardState {
        static final int START = -1;
        static final int NEXT = 0;
        static final int PREVIOUS = 1;
        static final int CANCEL = 2;
        static final int FINISH = 3;
        static final int CLOSE = 4;
        static final int GOTOSTEP = 7;
        private int state = -1;
        private int currentStep = 0;
        private Boolean hasStepHelp;

        WizardState() {
        }

        int getState() {
            return this.state;
        }

        void setState(int newState) {
            this.state = newState;
        }

        Boolean getHasStepHelp() {
            return this.hasStepHelp;
        }

        void setHasStepHelp(Boolean newHasStepHelp) {
            this.hasStepHelp = newHasStepHelp;
        }

        boolean isComplete() {
            return this.state == 4 || this.state == 2;
        }

        boolean decode(int event) {
            return true;
        }

        boolean validate(int event) {
            return event == 2 || event == 6 || event == 12;
        }

        boolean update(int event) {
            return event == 2 || event == 6 || event == 12;
        }

        void nextStep() {
            this.state = 0;
            ++this.currentStep;
        }

        void finishStep() {
            this.state = 3;
            ++this.currentStep;
        }

        void previousStep() {
            this.state = 1;
            --this.currentStep;
        }

        void gotoStep(int step) {
            this.state = 7;
            this.currentStep = step;
        }

        int getCurrentStep() {
            return this.currentStep;
        }

        void setCurrentStep(int newCurrentStep) {
            this.currentStep = newCurrentStep;
        }

        void reset() {
            this.state = -1;
            this.currentStep = 0;
        }

        void cancel() {
            this.state = 2;
        }

        void close() {
            this.state = 4;
        }
    }
}

