/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.renderkit.html.RbCbRendererBase;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;

public final class CheckboxRenderer
extends RbCbRendererBase {
    private static final String MSG_COMPONENT_NOT_CHECKBOX = "CheckboxRenderer only renders Checkbox components.";
    private static final String[] STYLES = new String[]{"CHECKBOX", "CHECKBOX_DISABLED", "CHECKBOX_LABEL", "CHECKBOX_LABEL_DISABLED", "CHECKBOX_IMAGE", "CHECKBOX_IMAGE_DISABLED", "CHECKBOX_SPAN", "CHECKBOX_SPAN_DISABLED"};

    @Override
    public void decode(FacesContext context, UIComponent component) {
        String[] newValues;
        Map requestParameterValuesMap;
        boolean inGroup;
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        Checkbox checkbox = (Checkbox)component;
        String name = checkbox.getName();
        boolean bl = inGroup = name != null;
        if (name == null) {
            name = component.getClientId(context);
        }
        if ((requestParameterValuesMap = context.getExternalContext().getRequestParameterValuesMap()).containsKey(name) && ((newValues = (String[])requestParameterValuesMap.get(name)) != null || newValues.length != 0)) {
            Object selectedValue = checkbox.getSelectedValue();
            if (inGroup && selectedValue instanceof Boolean) {
                String selectedValueAsString = component.getClientId(context);
                for (int i = 0; i < newValues.length; ++i) {
                    if (!selectedValueAsString.equals(newValues[i])) continue;
                    ((UIInput)component).setSubmittedValue((Object)new String[]{selectedValue.toString()});
                    return;
                }
            } else {
                String selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
                for (int i = 0; i < newValues.length; ++i) {
                    if (!selectedValueAsString.equals(newValues[i])) continue;
                    ((UIInput)component).setSubmittedValue((Object)new String[]{newValues[i]});
                    return;
                }
            }
            ((UIInput)component).setSubmittedValue((Object)new String[0]);
            return;
        }
        ((UIInput)component).setSubmittedValue((Object)new String[0]);
    }

    @Override
    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof Checkbox)) {
            throw new IllegalArgumentException(MessageUtil.getMessage(context, "com.sun.webui.jsf.renderkit.html.Bundle", MSG_COMPONENT_NOT_CHECKBOX));
        }
    }

    @Override
    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderSelection(context, component, theme, writer, "checkbox");
    }

    @Override
    protected boolean isSelected(FacesContext context, UIComponent component) {
        return ((Checkbox)component).isChecked();
    }

    @Override
    protected String getStyle(Theme theme, int styleCode) {
        String style = null;
        try {
            style = theme.getStyleClass(STYLES[styleCode]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return style;
    }
}

