/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class OpenIdState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String state;

    public OpenIdState() {
        this.state = UUID.randomUUID().toString();
    }

    public OpenIdState(String state) {
        this.state = state;
    }

    public static Optional<OpenIdState> from(String state) {
        if (state == null || "".equals(state.trim())) {
            return Optional.empty();
        }
        return Optional.of(new OpenIdState(state.trim()));
    }

    public String getValue() {
        return this.state;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OpenIdState) {
            return Objects.equals(this.state, ((OpenIdState)obj).state);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    public String toString() {
        return this.state;
    }
}

