/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.descriptor;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferencerImpl;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.ActivationConfigDescriptor;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public final class EjbMessageBeanDescriptor
extends EjbDescriptor
implements MessageDestinationReferencer,
com.sun.enterprise.deployment.EjbMessageBeanDescriptor {
    private static final long serialVersionUID = 1L;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbMessageBeanDescriptor.class);
    private static final String DURABLE_SUBSCRIPTION_PROPERTY = "subscriptionDurability";
    private static final String DURABLE = "Durable";
    private static final String NON_DURABLE = "NonDurable";
    private static final String ACK_MODE_PROPERTY = "acknowledgeMode";
    private static final String AUTO_ACK = "Auto-acknowledge";
    private static final String DUPS_OK_ACK = "Dups-ok-acknowledge";
    private static final String MESSAGE_SELECTOR_PROPERTY = "messageSelector";
    private static final int AUTO_ACKNOWLEDGE = 1;
    private static final int DUPS_OK_ACKNOWLEDGE = 3;
    private String messageListenerType = "jakarta.jms.MessageListener";
    private transient Collection<MethodDescriptor> beanClassTxMethods;
    private String destinationType;
    private String durableSubscriptionName;
    private String connectionFactoryName;
    private String resourceAdapterMid;
    private final MessageDestinationReferencerImpl msgDestReferencer = new MessageDestinationReferencerImpl((Descriptor)this);
    private ActivationConfigDescriptor activationConfig = new ActivationConfigDescriptor();
    private ActivationConfigDescriptor runtimeActivationConfig = new ActivationConfigDescriptor();

    public String getEjbTypeForDisplay() {
        return "MessageDrivenBean";
    }

    public String getType() {
        return "Message-driven";
    }

    @Override
    public void setContainerTransactionFor(MethodDescriptor methodDescriptor, ContainerTransaction containerTransaction) {
        String txType = containerTransaction.getTransactionAttribute();
        if ("Required".equals(txType) || "NotSupported".equals(txType)) {
            super.setContainerTransactionFor(methodDescriptor, containerTransaction);
            return;
        }
        if (this.isTimedObject() && "RequiresNew".equals(txType)) {
            super.setContainerTransactionFor(methodDescriptor, containerTransaction);
            return;
        }
        throw new IllegalArgumentException("Invalid transaction attribute for message-driven bean: " + txType);
    }

    public void setMessageListenerType(String messagingType) {
        this.messageListenerType = messagingType;
        this.beanClassTxMethods = null;
    }

    public String getMessageListenerType() {
        return this.messageListenerType;
    }

    public Set<MethodDescriptor> getTxBusinessMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        try {
            HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
            this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.messageListenerType), "Bean");
            this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getEjbClassName()), "Bean");
            if (this.isTimedObject()) {
                if (this.getEjbTimeoutMethod() != null) {
                    methods.add(this.getEjbTimeoutMethod());
                }
                for (ScheduledTimerDescriptor schd : this.getScheduledTimerDescriptors()) {
                    methods.add(schd.getTimeoutMethod());
                }
            }
            return methods;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("getTxBusinessMethodDescriptors failed", e);
        }
    }

    public Set<MethodDescriptor> getSecurityBusinessMethodDescriptors() {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotgetsecbusmethodsinmsgbean", "Cannot get business method for security for message-driven bean."));
    }

    public Method[] getMessageListenerInterfaceMethods(ClassLoader classLoader) throws NoSuchMethodException {
        ArrayList<Method> methods = new ArrayList<Method>();
        try {
            Class<?> messageListenerClass = classLoader.loadClass(this.messageListenerType);
            for (Method method : messageListenerClass.getDeclaredMethods()) {
                methods.add(method);
            }
            Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
            for (Method method : ejbClass.getMethods()) {
                methods.add(method);
            }
        }
        catch (Exception e) {
            NoSuchMethodException nsme = new NoSuchMethodException();
            nsme.initCause(e);
            throw nsme;
        }
        return (Method[])methods.toArray(Method[]::new);
    }

    public boolean hasMessageDestinationLinkName() {
        return this.msgDestReferencer.getMessageDestinationLinkName() != null;
    }

    public boolean isLinkedToMessageDestination() {
        return this.msgDestReferencer.isLinkedToMessageDestination();
    }

    public String getMessageDestinationLinkName() {
        return this.msgDestReferencer.getMessageDestinationLinkName();
    }

    public void setMessageDestinationLinkName(String linkName) {
        this.msgDestReferencer.setMessageDestinationLinkName(linkName);
    }

    public MessageDestinationDescriptor setMessageDestinationLinkName(String linkName, boolean resolveLink) {
        return this.msgDestReferencer.setMessageDestinationLinkName(linkName, resolveLink);
    }

    public MessageDestinationDescriptor resolveLinkName() {
        return this.msgDestReferencer.resolveLinkName();
    }

    public boolean ownedByMessageDestinationRef() {
        return false;
    }

    public MessageDestinationReferenceDescriptor getMessageDestinationRefOwner() {
        return null;
    }

    public boolean ownedByMessageBean() {
        return true;
    }

    public EjbMessageBeanDescriptor getMessageBeanOwner() {
        return this;
    }

    public MessageDestinationDescriptor getMessageDestination() {
        return this.msgDestReferencer.getMessageDestination();
    }

    public void setMessageDestination(MessageDestinationDescriptor newMsgDest) {
        this.msgDestReferencer.setMessageDestination(newMsgDest);
    }

    public Set<EnvironmentProperty> getActivationConfigProperties() {
        return this.activationConfig.getActivationConfig();
    }

    public String getActivationConfigValue(String name) {
        for (EnvironmentProperty next : this.activationConfig.getActivationConfig()) {
            if (!next.getName().equals(name)) continue;
            return next.getValue();
        }
        return null;
    }

    public void putActivationConfigProperty(EnvironmentProperty prop) {
        this.removeActivationConfigPropertyByName(prop.getName());
        this.activationConfig.getActivationConfig().add(prop);
    }

    public void removeActivationConfigProperty(EnvironmentProperty prop) {
        Iterator<EnvironmentProperty> iter = this.activationConfig.getActivationConfig().iterator();
        while (iter.hasNext()) {
            EnvironmentProperty next = iter.next();
            if (!next.getName().equals(prop.getName()) || !next.getValue().equals(prop.getValue())) continue;
            iter.remove();
            break;
        }
    }

    public void removeActivationConfigPropertyByName(String name) {
        Iterator<EnvironmentProperty> iter = this.activationConfig.getActivationConfig().iterator();
        while (iter.hasNext()) {
            EnvironmentProperty next = iter.next();
            if (!next.getName().equals(name)) continue;
            iter.remove();
            break;
        }
    }

    public Set<EnvironmentProperty> getRuntimeActivationConfigProperties() {
        return this.runtimeActivationConfig.getActivationConfig();
    }

    public String getRuntimeActivationConfigValue(String name) {
        for (EnvironmentProperty next : this.runtimeActivationConfig.getActivationConfig()) {
            if (!next.getName().equals(name)) continue;
            return next.getValue();
        }
        return null;
    }

    public void putRuntimeActivationConfigProperty(EnvironmentProperty prop) {
        this.runtimeActivationConfig.getActivationConfig().add(prop);
    }

    public void removeRuntimeActivationConfigProperty(EnvironmentProperty prop) {
        Iterator<EnvironmentProperty> iter = this.runtimeActivationConfig.getActivationConfig().iterator();
        while (iter.hasNext()) {
            EnvironmentProperty next = iter.next();
            if (!next.getName().equals(prop.getName()) || !next.getValue().equals(prop.getValue())) continue;
            iter.remove();
            break;
        }
    }

    public void removeRuntimeActivationConfigPropertyByName(String name) {
        Iterator<EnvironmentProperty> iter = this.runtimeActivationConfig.getActivationConfig().iterator();
        while (iter.hasNext()) {
            EnvironmentProperty next = iter.next();
            if (!next.getName().equals(name)) continue;
            iter.remove();
            break;
        }
    }

    public boolean hasQueueDest() {
        return "jakarta.jms.Queue".equals(this.destinationType);
    }

    public boolean hasTopicDest() {
        return "jakarta.jms.Topic".equals(this.destinationType);
    }

    public boolean hasDestinationType() {
        return this.destinationType != null;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destType) {
        this.destinationType = destType;
    }

    public boolean hasDurableSubscription() {
        String value = this.getActivationConfigValue(DURABLE_SUBSCRIPTION_PROPERTY);
        return DURABLE.equals(value);
    }

    public void setHasDurableSubscription(boolean durable) {
        if (durable) {
            EnvironmentProperty durableProp = new EnvironmentProperty(DURABLE_SUBSCRIPTION_PROPERTY, DURABLE, "");
            this.putActivationConfigProperty(durableProp);
        } else {
            this.removeActivationConfigPropertyByName(DURABLE_SUBSCRIPTION_PROPERTY);
        }
    }

    public void setHasQueueDest() {
        this.destinationType = "jakarta.jms.Queue";
        this.setHasDurableSubscription(false);
    }

    public void setHasTopicDest() {
        this.destinationType = "jakarta.jms.Topic";
    }

    public void setSubscriptionDurability(String subscription) {
        if (DURABLE.equals(subscription)) {
            this.setHasDurableSubscription(true);
        } else if (NON_DURABLE.equals(subscription)) {
            this.setHasDurableSubscription(false);
        } else {
            throw new IllegalArgumentException("Invalid subscription durability string : " + subscription);
        }
    }

    public boolean hasJmsMessageSelector() {
        return this.getActivationConfigValue(MESSAGE_SELECTOR_PROPERTY) != null;
    }

    public void setJmsMessageSelector(String selector) {
        if (selector == null || selector.isBlank()) {
            this.removeActivationConfigPropertyByName(MESSAGE_SELECTOR_PROPERTY);
        } else {
            EnvironmentProperty msgSelectorProp = new EnvironmentProperty(MESSAGE_SELECTOR_PROPERTY, selector, "");
            this.putActivationConfigProperty(msgSelectorProp);
        }
    }

    public String getJmsMessageSelector() {
        return this.getActivationConfigValue(MESSAGE_SELECTOR_PROPERTY);
    }

    public int getJmsAcknowledgeMode() {
        String ackModeStr = this.getActivationConfigValue(ACK_MODE_PROPERTY);
        return ackModeStr != null && ackModeStr.equals(DUPS_OK_ACK) ? 3 : 1;
    }

    public String getJmsAcknowledgeModeAsString() {
        return this.getActivationConfigValue(ACK_MODE_PROPERTY);
    }

    public void setJmsAcknowledgeMode(int acknowledgeMode) {
        String ackModeValue = acknowledgeMode == 1 ? AUTO_ACK : DUPS_OK_ACK;
        EnvironmentProperty ackModeProp = new EnvironmentProperty(ACK_MODE_PROPERTY, ackModeValue, "");
        this.putActivationConfigProperty(ackModeProp);
    }

    public void setJmsAcknowledgeMode(String acknowledgeMode) {
        if (AUTO_ACK.equals(acknowledgeMode)) {
            this.setJmsAcknowledgeMode(1);
        } else if (DUPS_OK_ACK.equals(acknowledgeMode)) {
            this.setJmsAcknowledgeMode(3);
        } else {
            throw new IllegalArgumentException("Invalid jms acknowledge mode : " + acknowledgeMode);
        }
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactory) {
        this.connectionFactoryName = connectionFactory;
    }

    public boolean hasConnectionFactory() {
        return this.connectionFactoryName != null;
    }

    public String getResourceAdapterMid() {
        return this.resourceAdapterMid;
    }

    public String getMdbConnectionFactoryJndiName() {
        return this.getIASEjbExtraDescriptors().getMdbConnectionFactory().getJndiName();
    }

    public void setResourceAdapterMid(String resourceAdapterMid) {
        this.resourceAdapterMid = resourceAdapterMid;
    }

    public boolean hasResourceAdapterMid() {
        return this.resourceAdapterMid != null;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.emptyList();
    }

    @Override
    protected Collection<MethodDescriptor> getTransactionMethods(ClassLoader classLoader) {
        Vector<MethodDescriptor> txMethods = new Vector<MethodDescriptor>();
        if (this.beanClassTxMethods == null) {
            try {
                Method[] interfaceMessageListenerMethods;
                this.beanClassTxMethods = new HashSet<MethodDescriptor>();
                Class<?> ejbClass = classLoader.loadClass(this.getEjbClassName());
                for (Method next : interfaceMessageListenerMethods = this.getMessageListenerInterfaceMethods(classLoader)) {
                    Method nextBeanMethod = ejbClass.getMethod(next.getName(), next.getParameterTypes());
                    this.beanClassTxMethods.add(new MethodDescriptor(nextBeanMethod, "Bean"));
                }
                if (this.isTimedObject()) {
                    this.beanClassTxMethods.add(this.getEjbTimeoutMethod());
                }
            }
            catch (Exception e) {
                NoSuchMethodError nsme = new NoSuchMethodError(localStrings.getLocalString("enterprise.deployment.noonmessagemethod", "", new Object[]{this.getEjbClassName(), this.getMessageListenerType()}));
                nsme.initCause(e);
                throw nsme;
            }
        }
        txMethods.addAll(this.beanClassTxMethods);
        return txMethods;
    }

    @Override
    public String getContainerFactoryQualifier() {
        return "MessageBeanContainerFactory";
    }

    public void setTransactionType(String transactionType) {
        boolean isValidType;
        boolean bl = isValidType = "Bean".equals(transactionType) || "Container".equals(transactionType);
        if (!isValidType && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionmsgbeantxtypenotlegaltype", "{0} is not a legal transaction type for a message-driven bean", new Object[]{transactionType}));
        }
        super.setTransactionType(transactionType);
        super.setMethodContainerTransactions(new Hashtable<MethodDescriptor, ContainerTransaction>());
    }

    public void setActivationConfigDescriptor(ActivationConfigDescriptor desc) {
        this.activationConfig = desc;
    }

    public ActivationConfigDescriptor getActivationConfigDescriptor() {
        return this.activationConfig;
    }

    public void setRuntimeActivationConfigDescriptor(ActivationConfigDescriptor desc) {
        this.runtimeActivationConfig = desc;
    }

    public ActivationConfigDescriptor getRuntimeActivationConfigDescriptor() {
        return this.runtimeActivationConfig;
    }

    @Override
    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("Message-driven descriptor : ").append(this.activationConfig.getActivationConfig()).append(this.runtimeActivationConfig.getActivationConfig());
    }
}

