/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class RepositoryManager
implements Closeable {
    private static final System.Logger LOG = System.getLogger(RepositoryManager.class.getName());
    private final List<Repository> repositories = new ArrayList<Repository>();

    RepositoryManager() {
    }

    synchronized void addRepository(String repository, File directory) {
        LOG.log(System.Logger.Level.DEBUG, "addRepository(repository={0}, file={1})", repository, directory);
        Objects.requireNonNull(repository);
        Objects.requireNonNull(directory);
        if (!repository.endsWith("/")) {
            throw new IllegalArgumentException("The repository must end with the '/' character!");
        }
        this.repositories.add(new Repository(repository, directory));
    }

    synchronized List<RepositoryResource> getResources(String name) {
        return this.repositories.stream().map(r -> new RepositoryResource(r.name + name, new File(r.directory, name))).collect(Collectors.toList());
    }

    synchronized List<File> getDirectories() {
        return this.repositories.stream().map(r -> r.directory).distinct().collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.getClass().getSimpleName());
        sb.append('[');
        sb.append(this.repositories.stream().map(r -> r.toString()).collect(Collectors.joining("\n")));
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
        this.repositories.clear();
    }

    private static class Repository {
        public final String name;
        public final File directory;

        Repository(String name, File directory) {
            this.name = name;
            this.directory = directory;
        }

        public String toString() {
            return this.name;
        }
    }

    static class RepositoryResource {
        public final String name;
        public final File file;

        RepositoryResource(String name, File file) {
            this.name = name;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }
}

