/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.unmarshaller_1;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.UnmarshallerHandler;
import jakarta.xml.bind.UnmarshalException;
import java.io.File;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class SetGetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        SetGetCTTests test = new SetGetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status SetGet005( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             if (um.getEventHandler() == null){
                 return Status.failed("getEventHandler() returns null instead of default event handler");
             }
         } catch (JAXBException je){
             return Status.failed("getEventHandler() unexpectedly throws JAXBException");
         }
         return Status.passed("OKAY");
    }

    public Status SetGet006( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         MyValidationEventHandler veh = new MyValidationEventHandler();
         try {
             um.setEventHandler(veh);
             if (um.getEventHandler() != veh){
                 return Status.failed("getEventHandler() returns not registered event handler");
             }
         } catch (JAXBException je){
             return Status.failed("getEventHandler() or setEventHandler() unexpectedly throws JAXBException");
         }
         return Status.passed("OKAY");
    }

    public Status SetGet007( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         if (um.getUnmarshallerHandler() == null){
             return Status.failed("getUnmarshallerHandler() returns null");
         }
         return Status.passed("OKAY");
    }

    public Status SetGet008( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um1 = null, um2 = null;
         UnmarshallerHandler umh1 = null, umh2 = null;
         
         try {
             jc = getJAXBContext();
             um1 = jc.createUnmarshaller();
             um2 = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         if ((umh1 = um1.getUnmarshallerHandler()) == null){
             return Status.failed("getUnmarshallerHandler() returns null");
         }
         if ((umh2 = um2.getUnmarshallerHandler()) == null){
             return Status.failed("getUnmarshallerHandler() returns null");
         }
         if (umh1 == umh2){
             return Status.failed("two different unmarshallers: getUnmarshallerHandler() returns the same object");
         }
         return Status.passed("OKAY");
    }

    public Status SetGet009( ) {
        JAXBContext jc = null;
       Unmarshaller um = null;
       try {
           jc = getJAXBContext();
           um = jc.createUnmarshaller();
       } catch (JAXBException je){
           return Status.failed("Unable to create valid context or unmarshaller");
       }
       
       class ListenerStub extends Unmarshaller.Listener{
           private String _refName;
           public ListenerStub(String refName){
               _refName = refName;
           }
           
           public String toString(){
               return super.toString()+" ref: "+_refName;
           }
       }
       
       ListenerStub ls1 = new ListenerStub("ls1");
       ListenerStub ls2 = new ListenerStub("ls2");
       
       um.setListener(ls1);
       if(ls1 != um.getListener()){
           return Status.failed("Cannot set listener: getListener() returned: "+um.getListener());
       }
       um.setListener(ls2);
       if(ls2 != um.getListener()){
           return Status.failed("Cannot reset listener: getListener() returned: "+um.getListener());
       }
       um.setListener(null);
       if(um.getListener() != null){
           return Status.failed("Cannot reset listener to null: getListener() returned: "+um.getListener());
       }
       return Status.passed("OKAY");
    }


}

