/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import java.io.File;
import java.util.ResourceBundle;
import javax.swing.filechooser.FileFilter;

class FileType
extends FileFilter {
    private String desc;
    private String[] extns;
    private static ResourceBundle i18n = ResourceBundle.getBundle("com.sun.javatest.exec.i18n");
    public static FileType allFiles = new FileType();
    public static FileType jteFiles = new FileType("jte");
    public static FileType jtpFiles = new FileType("jtp");
    public static FileType jtxFiles = new FileType("jtx");

    public FileType() {
    }

    public FileType(String extn) {
        this(new String[]{extn});
    }

    public FileType(String[] extns) {
        this.extns = extns;
    }

    @Override
    public String getDescription() {
        if (this.desc == null) {
            StringBuffer sb = new StringBuffer("filetype");
            if (this.extns == null) {
                sb.append(".allFiles");
            } else {
                for (int i = 0; i < this.extns.length; ++i) {
                    sb.append("." + this.extns[i]);
                }
            }
            this.desc = i18n.getString(sb.toString());
        }
        return this.desc;
    }

    public String[] getExtensions() {
        return this.extns;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory() || this.extns == null || this.extns.length == 0) {
            return true;
        }
        String fName = f.getName();
        for (int i = 0; i < this.extns.length; ++i) {
            if (!fName.endsWith(this.extns[i])) continue;
            return true;
        }
        return false;
    }
}

