/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.internal.HelpData;
import org.eclipse.help.internal.util.SequenceResolver;
import org.osgi.framework.Bundle;

public class ProductPreferences {
    private static Properties[] productPreferences;
    private static SequenceResolver<String> orderResolver;
    private static Map<Properties, String> preferencesToPluginIdMap;
    private static Map<Properties, String> preferencesToProductIdMap;
    private static List<String> primaryTocOrdering;
    private static List<String>[] secondaryTocOrderings;
    private static final String PLUGINS_ROOT_SLASH = "PLUGINS_ROOT/";
    private static boolean rtl;
    private static boolean directionInitialized;

    static {
        directionInitialized = false;
    }

    public static List<String> getTocOrder(List<String> itemsToOrder, Map<String, String> nameIdMap) {
        List<String> primaryOrdering = ProductPreferences.getPrimaryTocOrdering();
        List[] secondaryOrdering = new List[]{};
        if (primaryOrdering == null || primaryOrdering.isEmpty()) {
            secondaryOrdering = ProductPreferences.getSecondaryTocOrderings();
        }
        return ProductPreferences.getOrderedList(itemsToOrder, primaryOrdering, secondaryOrdering, nameIdMap);
    }

    public static List<String> getPrimaryTocOrdering() {
        if (primaryTocOrdering == null) {
            String baseTOCS;
            String helpDataFile;
            IProduct product = Platform.getProduct();
            String pluginId = null;
            if (product != null) {
                pluginId = product.getDefiningBundle().getSymbolicName();
            }
            if ((primaryTocOrdering = ProductPreferences.getTocOrdering(pluginId, helpDataFile = Platform.getPreferencesService().getString("org.eclipse.help", "HELP_DATA", "", null), baseTOCS = Platform.getPreferencesService().getString("org.eclipse.help", "baseTOCS", "", null))) == null) {
                primaryTocOrdering = new ArrayList<String>();
            }
        }
        return primaryTocOrdering;
    }

    public static List<String>[] getSecondaryTocOrderings() {
        if (secondaryTocOrderings == null) {
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            Properties[] productPreferences = ProductPreferences.getProductPreferences(false);
            int i = 0;
            while (i < productPreferences.length) {
                String baseTOCS;
                String helpDataFile;
                String pluginId = preferencesToPluginIdMap.get(productPreferences[i]);
                List<String> ordering = ProductPreferences.getTocOrdering(pluginId, helpDataFile = (String)productPreferences[i].get("org.eclipse.help/HELP_DATA"), baseTOCS = (String)productPreferences[i].get("org.eclipse.help/baseTOCS"));
                if (ordering != null) {
                    list.add(ordering);
                }
                ++i;
            }
            secondaryTocOrderings = list.toArray(new List[list.size()]);
        }
        return secondaryTocOrderings;
    }

    public static List<String> getTocOrdering(String pluginId, String helpDataFile, String baseTOCS) {
        if (helpDataFile != null && helpDataFile.length() > 0) {
            int nextSlash;
            String helpDataPluginId = pluginId;
            String helpDataPath = helpDataFile;
            if (helpDataFile.startsWith(PLUGINS_ROOT_SLASH) && (nextSlash = helpDataFile.indexOf(47, PLUGINS_ROOT_SLASH.length())) > 0) {
                helpDataPluginId = helpDataFile.substring(PLUGINS_ROOT_SLASH.length(), nextSlash);
                helpDataPath = helpDataFile.substring(nextSlash + 1);
            }
            Bundle bundle = null;
            if (helpDataPluginId != null) {
                bundle = Platform.getBundle((String)helpDataPluginId);
            }
            if (bundle != null) {
                URL helpDataUrl = bundle.getEntry(helpDataPath);
                HelpData helpData = new HelpData(helpDataUrl);
                return helpData.getTocOrder();
            }
        } else if (baseTOCS != null) {
            return ProductPreferences.tokenize(baseTOCS);
        }
        return null;
    }

    public static boolean getBoolean(Plugin plugin, String key) {
        return Platform.getPreferencesService().getBoolean(plugin.getBundle().getSymbolicName(), key, false, null);
    }

    public static List<String> getOrderedList(List<String> items, List<String> order) {
        return ProductPreferences.getOrderedList(items, order, null, null);
    }

    public static List<String> getOrderedList(List<String> items, List<String> primary, List<String>[] secondary, Map<String, String> nameIdMap) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> set = new ArrayList<String>(items);
        if (orderResolver == null) {
            orderResolver = new SequenceResolver();
        }
        List<String> order = orderResolver.getSequence(primary, secondary);
        for (String obj : order) {
            if (!set.contains(obj)) continue;
            result.add(obj);
            set.remove(obj);
        }
        if (HelpData.getProductHelpData().isSortOthers() && nameIdMap != null) {
            ArrayList<String> remaining = new ArrayList<String>();
            remaining.addAll(set);
            ProductPreferences.sortByName(remaining, nameIdMap);
            result.addAll(remaining);
        } else {
            result.addAll(set);
        }
        return result;
    }

    private static void sortByName(List<String> remaining, Map<String, String> categorized) {
        remaining.sort(new NameComparator(categorized));
    }

    public static synchronized String getPluginId(Properties prefs) {
        return preferencesToPluginIdMap.get(prefs);
    }

    public static synchronized String getProductId(Properties prefs) {
        return preferencesToProductIdMap.get(prefs);
    }

    public static synchronized Properties[] getProductPreferences(boolean includeActiveProduct) {
        if (productPreferences == null) {
            String activeProductId = null;
            IProduct activeProduct = Platform.getProduct();
            if (activeProduct != null) {
                activeProductId = activeProduct.getId();
            }
            ArrayList<Properties> collection = new ArrayList<Properties>();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.runtime.products");
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("product")) {
                    String productId = elements[i].getDeclaringExtension().getUniqueIdentifier();
                    if (includeActiveProduct || activeProductId == null || !activeProductId.equals(productId)) {
                        String contributor = elements[i].getContributor().getName();
                        IConfigurationElement[] propertyElements = elements[i].getChildren("property");
                        int j = 0;
                        while (j < propertyElements.length) {
                            String value;
                            String name = propertyElements[j].getAttribute("name");
                            if (name != null && name.equals("preferenceCustomization") && (value = propertyElements[j].getAttribute("value")) != null) {
                                Properties properties = ProductPreferences.loadPropertiesFile(contributor, value);
                                if (properties != null) {
                                    collection.add(properties);
                                }
                                if (preferencesToPluginIdMap == null) {
                                    preferencesToPluginIdMap = new HashMap<Properties, String>();
                                }
                                preferencesToPluginIdMap.put(properties, contributor);
                                if (preferencesToProductIdMap == null) {
                                    preferencesToProductIdMap = new HashMap<Properties, String>();
                                }
                                preferencesToProductIdMap.put(properties, productId);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            productPreferences = collection.toArray(new Properties[collection.size()]);
        }
        return productPreferences;
    }

    public static String getValue(String key, Properties primary, Properties[] secondary) {
        String value = null;
        if (primary != null) {
            value = primary.getProperty(key);
        }
        if (value == null) {
            int i = 0;
            while (i < secondary.length) {
                if (secondary[i] != primary && (value = secondary[i].getProperty(key)) != null) break;
                ++i;
            }
        }
        return value;
    }

    public static Properties loadPropertiesFile(String bundleId, String path) {
        URL url;
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null && (url = bundle.getEntry(path)) != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream in = url.openStream();){
                    Properties properties = new Properties();
                    properties.load(in);
                    return properties;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Platform.getLog(ProductPreferences.class).error("Error opening product's plugin customization file: " + bundleId + "/" + path, (Throwable)e);
            }
        }
        return null;
    }

    public static List<String> tokenize(String str) {
        if (str != null) {
            StringTokenizer tok = new StringTokenizer(str, " \n\r\t;,");
            ArrayList<String> list = new ArrayList<String>();
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public int compare(Object o1, Object o2) {
        return 0;
    }

    public static void resetPrimaryTocOrdering() {
        primaryTocOrdering = null;
    }

    public static boolean isRTL() {
        if (!directionInitialized) {
            directionInitialized = true;
            rtl = ProductPreferences.initializeRTL();
        }
        return rtl;
    }

    private static boolean initializeRTL() {
        String orientation = System.getProperty("eclipse.orientation");
        if ("rtl".equals(orientation)) {
            return true;
        }
        if ("ltr".equals(orientation)) {
            return false;
        }
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dir".equalsIgnoreCase(args[i])) {
                return i + 1 < args.length && "rtl".equalsIgnoreCase(args[i + 1]);
            }
            ++i;
        }
        if (System.getProperty("osgi.nl.user") == null) {
            return false;
        }
        String locale = Platform.getNL();
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        return locale.startsWith("ar") || locale.startsWith("fa") || locale.startsWith("he") || locale.startsWith("iw") || locale.startsWith("ur");
    }

    public static String resolveSpecialIdentifiers(String path) {
        Bundle productBundle;
        IProduct product;
        String bundleName;
        if (path == null) {
            return null;
        }
        int index = path.indexOf("PLUGINS_ROOT");
        if (index != -1) {
            path = path.substring(index + "PLUGINS_ROOT".length());
        }
        if ((index = path.indexOf(47, 1)) != -1 && ("PRODUCT_PLUGIN".equals(bundleName = path.substring(0, index)) || "/PRODUCT_PLUGIN".equals(bundleName)) && (product = Platform.getProduct()) != null && (productBundle = product.getDefiningBundle()) != null) {
            bundleName = productBundle.getSymbolicName();
            return String.valueOf('/') + bundleName + path.substring(index);
        }
        return path;
    }

    public static boolean useEnablementFilters() {
        if (!HelpSystem.isShared()) {
            return true;
        }
        return Platform.getPreferencesService().getBoolean("org.eclipse.help", "filterInfocenter", false, null);
    }

    private static class NameComparator
    implements Comparator<String> {
        private Map<String, String> tocNames;

        public NameComparator(Map<String, String> tocNames) {
            this.tocNames = tocNames;
        }

        @Override
        public int compare(String o1, String o2) {
            String name1 = this.tocNames.get(o1);
            String name2 = this.tocNames.get(o2);
            if (name1 == null) {
                return name2 != null ? -1 : 0;
            }
            if (name2 == null) {
                return 1;
            }
            return Collator.getInstance().compare(name1, name2);
        }
    }
}

