/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.iproduct.IConfigurationProperty;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaRootElement;

public class PDESchemaHelper {
    public static final String ALL_OS = "";
    public static final String ALL_ARCH = "";

    /*
     * WARNING - void declaration
     */
    public static Map<String, IConfigurationElement> getValidAttributes(ISchemaAttribute attribute) {
        ISchemaRestriction restriction;
        int n;
        HashMap<String, IConfigurationElement> attributeMap = new HashMap<String, IConfigurationElement>();
        String basedOnValue = attribute.getBasedOn();
        if (basedOnValue != null) {
            String[] basedOnList;
            String[] stringArray = basedOnList = basedOnValue.split(",");
            n = basedOnList.length;
            int n2 = 0;
            while (n2 < n) {
                String basedOn = stringArray[n2];
                PDESchemaHelper.gatherAttributes(attributeMap, basedOn);
                ++n2;
            }
        }
        if ((restriction = attribute.getType().getRestriction()) != null) {
            Object[] children;
            Object[] objectArray = children = restriction.getChildren();
            int n3 = children.length;
            n = 0;
            while (n < n3) {
                Object child = objectArray[n];
                Object object = child;
                if (object instanceof ISchemaEnumeration) {
                    void enumeration;
                    ISchemaEnumeration cfr_ignored_0 = (ISchemaEnumeration)object;
                    ISchemaEnumeration cfr_ignored_1 = (ISchemaEnumeration)object;
                    String value = enumeration.getName();
                    if (value != null && value.length() > 0) {
                        attributeMap.put(value, null);
                    }
                }
                ++n;
            }
        }
        return attributeMap;
    }

    public static String getReferenceIdentifier(ISchemaAttribute attribute) {
        String rootId = attribute.getSchema().getSchemaDescriptor().getPointId();
        String refId = PDESchemaHelper.buildBasedOnValue(attribute.getParent()) + "/@" + attribute.getName();
        return rootId + refId;
    }

    private static void gatherAttributes(Map<String, IConfigurationElement> attributesInfo, String basedOn) {
        if (basedOn == null) {
            return;
        }
        String[] path = basedOn.split("/");
        if (path.length < 2) {
            return;
        }
        IExtension[] extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions(path[0], true);
        ArrayList<IConfigurationElement> members = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (path.length == 2) {
                attributesInfo.put(extension.getUniqueIdentifier(), null);
            } else {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals(path[1])) {
                        members.add(element);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        ArrayList<IConfigurationElement> parents = members;
        int i = 2;
        while (i < path.length) {
            if (path[i].startsWith("@")) {
                String attName = path[i].substring(1);
                for (IConfigurationElement element : parents) {
                    String value = element.getAttribute(attName);
                    if (value == null) continue;
                    String extpt = element.getDeclaringExtension().getExtensionPointUniqueIdentifier();
                    if (value.indexOf(46) == -1 && extpt.equalsIgnoreCase("org.eclipse.core.contenttype.contentTypes")) {
                        attributesInfo.put(element.getNamespaceIdentifier() + "." + value, element);
                    }
                    attributesInfo.put(value, element);
                }
                return;
            }
            members = new ArrayList();
            for (IConfigurationElement element : parents) {
                members.addAll(PDESchemaHelper.keepGoing(element, path[i]));
            }
            parents = members;
            ++i;
        }
    }

    private static List<IConfigurationElement> keepGoing(IConfigurationElement element, String tag) {
        return Arrays.asList(element.getChildren(tag));
    }

    /*
     * WARNING - void declaration
     */
    private static String buildBasedOnValue(ISchemaObject object) {
        ISchemaObject iSchemaObject = object;
        if (iSchemaObject instanceof ISchemaElement) {
            ISchemaElement iSchemaElement = (ISchemaElement)iSchemaObject;
            ISchemaElement cfr_ignored_0 = (ISchemaElement)iSchemaObject;
            if (!(object instanceof ISchemaRootElement)) {
                ISchemaElement[] elements;
                void schemaElement;
                ISchema schema = schemaElement.getSchema();
                ISchemaElement[] iSchemaElementArray = elements = schema.getElements();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchemaElement[] children;
                    ISchemaElement element = iSchemaElementArray[n2];
                    ISchemaElement[] iSchemaElementArray2 = children = schema.getCandidateChildren(element);
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISchemaElement childElement = iSchemaElementArray2[n4];
                        if (object.getName().equals(childElement.getName())) {
                            return PDESchemaHelper.buildBasedOnValue(element) + "/" + object.getName();
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return "";
    }

    public static boolean containsMatchingProperty(Set<IConfigurationProperty> existingProperties, String name, String os, String arch) {
        for (IConfigurationProperty property : existingProperties) {
            String propArch;
            String propOs;
            if (!name.equals(property.getName().trim())) continue;
            String string = propOs = property.getOs() != null ? property.getOs().trim() : "";
            if (!"".equals(propOs) && !"".equals(os) && !propOs.equals(os)) continue;
            String string2 = propArch = property.getArch() != null ? property.getArch().trim() : "";
            if (!propArch.equals(arch) && !"".equals(arch) && !"".equals(propArch)) continue;
            return true;
        }
        return false;
    }
}

