/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    private int byteswritten = 0;
    private int datapos = 0;
    private long cursize = 0L;

    public TarOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void close() throws IOException {
        byte[] zeros = new byte[1024];
        this.cursize = 1024L;
        this.write(zeros, 0, 1024);
        if (this.byteswritten % 10240 != 0) {
            int length = 10240 - this.byteswritten % 10240;
            this.cursize = length;
            zeros = new byte[length];
            this.write(zeros, 0, length);
        }
        super.close();
    }

    public void closeEntry() throws IOException {
        byte[] data = new byte[512];
        int len = 512 - this.datapos;
        if (len > 0 && this.datapos > 0) {
            this.cursize = len;
            this.write(data, 0, len);
        }
    }

    private long headerChecksum(byte[] header) {
        long sum = 0L;
        int i = 0;
        while (i < 512) {
            sum += (long)(header[i] & 0xFF);
            ++i;
        }
        return sum;
    }

    public void putNextEntry(TarEntry e) throws IOException {
        byte[] header = new byte[512];
        String filename = e.getName();
        String prefix = null;
        byte[] filenameBytes = filename.getBytes(StandardCharsets.UTF_8);
        if (filenameBytes.length > 99) {
            int seppos = filename.lastIndexOf(47);
            if (seppos == -1) {
                throw new IOException("filename too long");
            }
            prefix = filename.substring(0, seppos);
            filenameBytes = (filename = filename.substring(seppos + 1)).getBytes(StandardCharsets.UTF_8);
            if (filenameBytes.length > 99) {
                throw new IOException("filename too long");
            }
        }
        int pos = 0;
        System.arraycopy(filenameBytes, 0, header, 0, filenameBytes.length);
        pos += 100;
        StringBuffer mode = new StringBuffer(Long.toOctalString(e.getMode()));
        while (mode.length() < 7) {
            mode.insert(0, '0');
        }
        int i = 0;
        while (i < 7) {
            header[pos + i] = (byte)mode.charAt(i);
            ++i;
        }
        header[pos += 8] = 48;
        header[pos += 8] = 48;
        pos += 8;
        String length = Long.toOctalString(e.getSize());
        i = 0;
        while (i < length.length()) {
            header[pos + i] = (byte)length.charAt(i);
            ++i;
        }
        pos += 12;
        String mtime = Long.toOctalString(e.getTime());
        i = 0;
        while (i < mtime.length()) {
            header[pos + i] = (byte)mtime.charAt(i);
            ++i;
        }
        pos += 12;
        i = 0;
        while (i < 8) {
            header[pos + i] = 32;
            ++i;
        }
        header[pos += 8] = (byte)e.getFileType();
        ++pos;
        pos += 100;
        String ustar = "ustar 00";
        i = 0;
        while (i < ustar.length()) {
            header[pos + i] = (byte)ustar.charAt(i);
            ++i;
        }
        header[pos + 5] = 0;
        pos += 8;
        String uname = "nobody";
        i = 0;
        while (i < uname.length()) {
            header[pos + i] = (byte)uname.charAt(i);
            ++i;
        }
        pos += 32;
        String gname = "nobody";
        i = 0;
        while (i < gname.length()) {
            header[pos + i] = (byte)gname.charAt(i);
            ++i;
        }
        pos += 32;
        pos += 8;
        pos += 8;
        if (prefix != null) {
            byte[] prefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
            if (prefixBytes.length > 155) {
                throw new IOException("prefix too large");
            }
            System.arraycopy(prefixBytes, 0, header, pos, prefixBytes.length);
        }
        long sum = this.headerChecksum(header);
        pos = 148;
        String sumval = Long.toOctalString(sum);
        i = 0;
        while (i < sumval.length()) {
            header[pos + i] = (byte)sumval.charAt(i);
            ++i;
        }
        this.cursize = 512L;
        this.write(header, 0, 512);
        this.cursize = e.getSize();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.datapos = (this.datapos + len) % 512;
        this.byteswritten += len;
        this.cursize -= (long)len;
        if (this.cursize < 0L) {
            throw new IOException("too much data written for current file");
        }
    }
}

