/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ProjEclipse;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.projection.BProjectedCoords;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VEclipse<T>
extends VCircle {
    float fraction = 0.5f;
    AffineTransform at;

    public VEclipse(double x, double y, int z, double d, float f, Color c, Color bc, float alpha) {
        super(x, y, z, d, c, bc, alpha);
        this.fraction = f;
    }

    public VEclipse(double x, double y, int z, double d, float f, Color c, Color bc, double or, float alpha) {
        super(x, y, z, d, c, bc, alpha);
        this.fraction = f;
        this.orient = or;
    }

    public void setFraction(float f) {
        this.fraction = f;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public double getFraction() {
        return this.fraction;
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new ProjEclipse[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjEclipse();
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                BProjectedCoords[] ta = this.pc;
                this.pc = new ProjEclipse[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjEclipse();
            } else {
                System.err.println("VEclipse:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjEclipse[1];
            this.pc[0] = new ProjEclipse();
        } else {
            System.err.println("VEclipse:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return ((ProjEclipse)this.pc[camIndex]).eclipsed.contains(jpx, jpy) && ((ProjEclipse)this.pc[camIndex]).shadowSource.contains(jpx, jpy);
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cr = (int)Math.round(this.size * this.coef / 2.0);
        ProjEclipse pe = (ProjEclipse)this.pc[i];
        pe.eclipsed.setFrame(this.pc[i].cx - this.pc[i].cr, this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
        pe.shadowSource.setFrame((float)(this.pc[i].cx - this.pc[i].cr) + (float)(2 * this.pc[i].cr) * this.fraction, this.pc[i].cy - this.pc[i].cr, 2 * this.pc[i].cr, 2 * this.pc[i].cr);
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcr = (int)Math.round(this.size * this.coef / 2.0);
        ProjEclipse pe = (ProjEclipse)this.pc[i];
        pe.leclipsed.setFrame(this.pc[i].lcx - this.pc[i].lcr, this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
        pe.lshadowSource.setFrame((float)(this.pc[i].lcx - this.pc[i].lcr) + (float)(2 * this.pc[i].lcr) * this.fraction, this.pc[i].lcy - this.pc[i].lcr, 2 * this.pc[i].lcr, 2 * this.pc[i].lcr);
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (Math.abs(this.fraction) > 1.0f) {
            return;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        ProjEclipse pe = (ProjEclipse)this.pc[i];
        if (pe.eclipsed.getBounds().width > 2 || pe.eclipsed.getBounds().height > 2) {
            Area eclipsed = new Area(pe.eclipsed);
            if (this.fraction != 0.0f) {
                eclipsed.intersect(new Area(pe.shadowSource));
            }
            if (this.alphaC != null) {
                this.at = AffineTransform.getTranslateInstance(dx, dy);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cx, this.pc[i].cy));
                g.setTransform(this.at);
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fill(eclipsed);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.draw(eclipsed);
                        g.setStroke(stdS);
                    } else {
                        g.draw(eclipsed);
                    }
                }
                g.setComposite(acO);
                g.setTransform(stdT);
            } else {
                this.at = AffineTransform.getTranslateInstance(dx, dy);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cx, this.pc[i].cy));
                g.setTransform(this.at);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fill(eclipsed);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.draw(eclipsed);
                        g.setStroke(stdS);
                    } else {
                        g.draw(eclipsed);
                    }
                }
                g.setTransform(stdT);
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (Math.abs(this.fraction) > 1.0f) {
            return;
        }
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        ProjEclipse pe = (ProjEclipse)this.pc[i];
        if (pe.leclipsed.getBounds().width > 2 || pe.leclipsed.getBounds().height > 2) {
            Area eclipsed = new Area(pe.eclipsed);
            if (this.fraction != 0.0f) {
                eclipsed.intersect(new Area(pe.shadowSource));
            }
            if (this.alphaC != null) {
                this.at = AffineTransform.getTranslateInstance(dx, dy);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cx, this.pc[i].cy));
                g.setTransform(this.at);
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fill(eclipsed);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.draw(eclipsed);
                        g.setStroke(stdS);
                    } else {
                        g.draw(eclipsed);
                    }
                }
                g.setComposite(acO);
                g.setTransform(stdT);
            } else {
                this.at = AffineTransform.getTranslateInstance(dx, dy);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cx, this.pc[i].cy));
                g.setTransform(this.at);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fill(eclipsed);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.draw(eclipsed);
                        g.setStroke(stdS);
                    } else {
                        g.draw(eclipsed);
                    }
                }
                g.setTransform(stdT);
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            }
        }
    }
}

