/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import net.claribole.zgrviewer.ConfigManager;

class ZGRAGlassPane
extends JComponent {
    static final AlphaComposite GLASS_ALPHA = AlphaComposite.getInstance(3, 0.65f);
    static final Color MSG_COLOR = Color.DARK_GRAY;
    String msg = "";
    int msgX = 0;
    int msgY = 0;
    int w;
    int h;

    ZGRAGlassPane(int w, int h) {
        this.w = w;
        this.h = h;
        this.addMouseListener(new MouseAdapter(){});
        this.addMouseMotionListener(new MouseMotionAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
    }

    void setMessage(String m) {
        this.msg = m;
        this.msgX = this.w / 2 - 100;
        this.msgY = this.h / 2;
        this.repaint(this.msgX, this.msgY - 50, 200, 70);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g.getClipBounds();
        g2.setComposite(GLASS_ALPHA);
        g2.setColor(Color.WHITE);
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(AlphaComposite.Src);
        if (this.msg != "") {
            g2.setColor(MSG_COLOR);
            g2.setFont(ConfigManager.defaultFont);
            g2.drawString(this.msg, this.msgX, this.msgY);
        }
    }
}

