/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common;

import java.util.List;
import org.eclipse.efm.execution.core.util.PrettyPrintWriter;
import org.eclipse.efm.execution.core.workflow.common.TraceElement;
import org.eclipse.efm.execution.core.workflow.common.TraceElementCustomImpl;
import org.eclipse.efm.execution.core.workflow.common.TraceElementKind;
import org.eclipse.efm.execution.core.workflow.common.impl.TraceSpecificationImpl;

public class TraceSpecificationCustomImpl
extends TraceSpecificationImpl {
    protected TraceSpecificationCustomImpl(String name) {
        this.setName(name);
    }

    public TraceSpecificationCustomImpl(List<TraceElement> traceElements) {
        this.getElement().addAll(traceElements);
    }

    public static TraceSpecificationCustomImpl create(String name) {
        return new TraceSpecificationCustomImpl(name);
    }

    public static TraceSpecificationCustomImpl create(String name, String specification) {
        TraceSpecificationCustomImpl trace = new TraceSpecificationCustomImpl(name);
        trace.parseAll(specification);
        return trace;
    }

    public static TraceSpecificationCustomImpl create(String name, String specification, TraceElementKind defaultNature) {
        TraceSpecificationCustomImpl trace = new TraceSpecificationCustomImpl(name);
        trace.parseAll(specification, defaultNature);
        return trace;
    }

    public void parseAll(String specification) {
        this.parseAll(specification, TraceElementKind.UNDEFINED);
    }

    public void parseAll(String specification, TraceElementKind defaultNature) {
        if (specification == null) {
            return;
        }
        if ((specification = specification.trim()).isEmpty()) {
            return;
        }
        String[] tabString = specification.split("\\R|;");
        List<TraceElement> elements = this.getElement();
        String[] stringArray = tabString;
        int n = tabString.length;
        int n2 = 0;
        while (n2 < n) {
            TraceElementCustomImpl traceElt;
            String eltString = stringArray[n2];
            if ((eltString = eltString.trim()).length() > 0 && (traceElt = TraceElementCustomImpl.create(eltString, defaultNature)) != null) {
                elements.add(traceElt);
            }
            ++n2;
        }
    }

    @Override
    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        for (TraceElement element : this.getElement()) {
            if (element instanceof TraceElementCustomImpl) {
                strBuffer.append(((TraceElementCustomImpl)element).toString());
                continue;
            }
            strBuffer.append(new TraceElementCustomImpl(element.isSelected(), element.getNature(), element.getValue()).toString());
        }
        return strBuffer.toString();
    }

    public void toWriter(PrettyPrintWriter writer) {
        writer.commentLine(this.getComment());
        writer.appendTab();
        String name = this.getName();
        if (name == null) {
            name = "trace";
        }
        writer.append(name);
        String str = this.getDescription();
        if (str != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" [");
        PrettyPrintWriter writer2 = writer.itab2();
        for (TraceElement element : this.getElement()) {
            if (element instanceof TraceElementCustomImpl) {
                ((TraceElementCustomImpl)element).toWriter(writer2);
                continue;
            }
            TraceElementCustomImpl customElement = new TraceElementCustomImpl(element.isSelected(), element.getNature(), element.getValue());
            customElement.toWriter(writer2);
        }
        writer.appendTab("] // end ").appendEol(name);
    }
}

