/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.SICircle;
import fr.inria.zvtm.glyphs.VPolygon;
import fr.inria.zvtm.glyphs.VPolygonOr;
import fr.inria.zvtm.glyphs.VSegment;
import java.awt.Color;
import java.awt.geom.Point2D;
import net.claribole.zgrviewer.GraphicsManager;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LNode;

public class GeometryEditor {
    public static final String SPLINE_GEOM_EDITOR = "sge";
    GraphicsManager grMngr;
    Point2D.Double[] currentEditPoints;
    SICircle[] currentEditPointGlyphs;
    VSegment[] currentEditSegments;
    DPath currentEditSpline;
    double headTangent;
    double tailTangent = 0.0;
    double headOrient;
    double tailOrient = 0.0;
    Glyph manipulatedNodeGlyph;

    GeometryEditor(GraphicsManager gm) {
        this.grMngr = gm;
    }

    void editEdgeSpline(LEdge e) {
        this.currentEditSpline = e.getSpline();
        this.currentEditPoints = this.currentEditSpline.getAllPointsCoordinates();
        VPolygonOr head = e.getHeadGlyph();
        this.headTangent = Math.atan2(this.currentEditPoints[this.currentEditPoints.length - 1].y - this.currentEditPoints[this.currentEditPoints.length - 2].y, this.currentEditPoints[this.currentEditPoints.length - 1].x - this.currentEditPoints[this.currentEditPoints.length - 2].x);
        if (head != null) {
            if (head instanceof VPolygon && !(head instanceof VPolygonOr)) {
                VPolygon p = head;
                VPolygonOr newHead = new VPolygonOr(p.getAbsoluteVertices(), 0, p.getDefaultColor(), p.getDefaultBorderColor(), 0.0);
                newHead.moveTo(this.currentEditPoints[this.currentEditPoints.length - 1].x, this.currentEditPoints[this.currentEditPoints.length - 1].y);
                e.replaceHead(newHead);
                newHead.setType(head.getType());
                this.grMngr.mSpace.removeGlyph(head, false);
                this.grMngr.mSpace.addGlyph(newHead, false);
                head = newHead;
            }
            this.headOrient = ((Glyph)head).getOrient();
        }
        VPolygonOr tail = e.getTailGlyph();
        this.tailTangent = Math.atan2(this.currentEditPoints[0].y - this.currentEditPoints[1].y, this.currentEditPoints[0].x - this.currentEditPoints[1].x);
        if (tail != null) {
            if (tail instanceof VPolygon && !(tail instanceof VPolygonOr)) {
                VPolygonOr newTail = new VPolygonOr(((VPolygon)tail).getAbsoluteVertices(), 0, tail.getColor(), ((Glyph)tail).getBorderColor(), 0.0);
                newTail.moveTo(this.currentEditPoints[0].x, this.currentEditPoints[0].y);
                e.replaceTail(newTail);
                newTail.setType(tail.getType());
                this.grMngr.mSpace.removeGlyph(tail, false);
                this.grMngr.mSpace.addGlyph(newTail, false);
                tail = newTail;
            }
            this.tailOrient = ((Glyph)tail).getOrient();
        }
        if (tail != null || head != null) {
            for (Glyph g : e.getUnknownGlyphs()) {
                if (!(g instanceof VSegment)) continue;
                this.grMngr.mSpace.removeGlyph(g, false);
            }
        }
        this.currentEditPointGlyphs = new SICircle[this.currentEditPoints.length];
        this.currentEditSegments = new VSegment[this.currentEditPointGlyphs.length - 1];
        this.currentEditPointGlyphs[0] = new SICircle(this.currentEditPoints[0].x, this.currentEditPoints[0].y, 100, 6.0, Color.DARK_GRAY, Color.LIGHT_GRAY, 0.8f);
        this.currentEditPointGlyphs[0].setType(SPLINE_GEOM_EDITOR);
        for (int i = 1; i < this.currentEditPoints.length; ++i) {
            this.currentEditPointGlyphs[i] = new SICircle(this.currentEditPoints[i].x, this.currentEditPoints[i].y, 100, 6.0, Color.DARK_GRAY, Color.LIGHT_GRAY, 0.8f);
            this.currentEditPointGlyphs[i].setType(SPLINE_GEOM_EDITOR);
            this.currentEditSegments[i - 1] = new VSegment(this.currentEditPoints[i - 1].x, this.currentEditPoints[i - 1].y, this.currentEditPoints[i].x, this.currentEditPoints[i].y, 99, Color.RED, 0.6f);
        }
        this.grMngr.mSpace.addGlyphs(this.currentEditSegments, false);
        this.grMngr.mSpace.addGlyphs(this.currentEditPointGlyphs, true);
    }

    void updateEdgeSpline() {
        ClosedShape tail;
        int i;
        for (i = 0; i < this.currentEditSegments.length; ++i) {
            this.currentEditSegments[i].setEndPoints(this.currentEditPointGlyphs[i].vx, this.currentEditPointGlyphs[i].vy, this.currentEditPointGlyphs[i + 1].vx, this.currentEditPointGlyphs[i + 1].vy);
        }
        for (i = 0; i < this.currentEditPointGlyphs.length; ++i) {
            this.currentEditPoints[i].setLocation(this.currentEditPointGlyphs[i].vx, this.currentEditPointGlyphs[i].vy);
        }
        this.currentEditSpline.edit(this.currentEditPoints, true);
        ClosedShape head = ((LEdge)this.currentEditSpline.getOwner()).getHeadGlyph();
        if (head != null) {
            double newHeadTangent = Math.atan2(this.currentEditPoints[this.currentEditPoints.length - 1].y - this.currentEditPoints[this.currentEditPoints.length - 2].y, this.currentEditPoints[this.currentEditPoints.length - 1].x - this.currentEditPoints[this.currentEditPoints.length - 2].x);
            head.orientTo(this.headOrient + (newHeadTangent - this.headTangent));
            head.moveTo(this.currentEditPoints[this.currentEditPoints.length - 1].x, this.currentEditPoints[this.currentEditPoints.length - 1].y);
        }
        if ((tail = ((LEdge)this.currentEditSpline.getOwner()).getTailGlyph()) != null) {
            double newTailTangent = Math.atan2(this.currentEditPoints[0].y - this.currentEditPoints[1].y, this.currentEditPoints[0].x - this.currentEditPoints[1].x);
            tail.orientTo(this.tailOrient + (newTailTangent - this.tailTangent));
            tail.moveTo(this.currentEditPoints[0].x, this.currentEditPoints[0].y);
        }
    }

    void clearSplineEditingGlyphs() {
        if (this.currentEditPoints != null) {
            for (VSegment vSegment : this.currentEditSegments) {
                this.grMngr.mSpace.removeGlyph(vSegment, false);
            }
            for (Glyph glyph : this.currentEditPointGlyphs) {
                this.grMngr.mSpace.removeGlyph(glyph, false);
            }
            VirtualSpaceManager.INSTANCE.repaint();
        }
        this.currentEditSpline = null;
        this.currentEditPointGlyphs = null;
        this.currentEditSegments = null;
        this.currentEditPoints = null;
    }

    void stickNodeComponents(Glyph mg, LNode n) {
        this.manipulatedNodeGlyph = mg;
        for (Glyph g : n.getGlyphs()) {
            if (g == this.manipulatedNodeGlyph) continue;
            this.manipulatedNodeGlyph.stick(g);
        }
    }

    void unstickAll() {
        this.manipulatedNodeGlyph.unstickAllGlyphs();
        this.manipulatedNodeGlyph = null;
    }
}

