/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.util.stdlib;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.internal.xpand2.pr.util.FSIO;

public class IOExtensions {
    private static final Log log = LogFactory.getLog(IOExtensions.class);

    public static final void syserr(Object s) {
        System.err.println(s);
    }

    public static final void syserr(Object s, String prefix) {
        System.err.println("[" + prefix + "] " + s);
    }

    public static final void debug(Object s) {
        log.debug(s);
    }

    public static final void info(Object s) {
        log.info(s);
    }

    public static final void error(Object s) {
        log.error(s);
    }

    public static final void throwError(Object s) {
        throw new IllegalStateException("" + s);
    }

    public static final String includeFile(String filePath, String encoding) {
        File f = new File(filePath);
        if (!f.exists()) {
            log.warn((Object)("Cannot include content from file " + filePath + ". The file does not exist."));
            return "";
        }
        try {
            return FSIO.readSingleFile((File)new File(filePath), (String)encoding);
        }
        catch (IOException e) {
            log.warn((Object)e.getMessage());
            return "";
        }
    }
}

