/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.engine.Utils;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.Translucent;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VEllipse;
import fr.inria.zvtm.glyphs.VImage;
import fr.inria.zvtm.glyphs.VPoint;
import fr.inria.zvtm.glyphs.VPolygon;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VSegment;
import fr.inria.zvtm.glyphs.VShape;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.svg.SVGWriterPostProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGWriter {
    private static String _serifff = "serif";
    private static String _timesff = "times";
    private static String _garamondff = "garamond";
    private static String _minionff = "minion";
    private static String _cyberbitff = "cyberbit";
    private static String _georgiaff = "georgia";
    private static String _sansff = "sans";
    private static String _arialff = "arial";
    private static String _trebuchetff = "trebuchet";
    private static String _verdanaff = "verdana";
    private static String _universff = "univers";
    private static String _helveticaff = "helvetica";
    private static String _tahomaff = "tahoma";
    private static String _lucidaff = "lucida";
    private static String _courierff = "courier";
    private static String _monoff = "mono";
    private static String _cursiveff = "cursive";
    private static String _caflischff = "caflisch";
    private static String _poeticaff = "poetica";
    private static String _sanvitoff = "sanvito";
    private static String _corsivaff = "corsiva";
    private static String _critterff = "critter";
    private static String _fantasyff = "fantasy";
    public static String _strokewidth = "stroke-width";
    public static String _strokelinecap = "stroke-linecap";
    public static String _strokelinejoin = "stroke-linejoin";
    public static String _strokemiterlimit = "stroke-miterlimit";
    public static String _strokedasharray = "stroke-dasharray";
    public static String _strokedashoffset = "stroke-dashoffset";
    public static String _strokecapbutt = "butt";
    public static String _strokecapround = "round";
    public static String _strokecapsquare = "square";
    public static String _strokejoinbevel = "bevel";
    public static String _strokejoinmiter = "miter";
    public static String _strokejoinround = "round";
    public static String _class = "class";
    public static float DEFAULT_MITER_LIMIT = 4.0f;
    public static float DEFAULT_DASH_OFFSET = 0.0f;
    public static final String svgURI = "http://www.w3.org/2000/svg";
    public static final String xlinkURI = "http://www.w3.org/1999/xlink";
    double farWest = 0.0;
    double farNorth = 0.0;
    Document svgDoc;
    File destination;
    File img_subdir;
    Hashtable bitmapImages;

    public Document exportVirtualSpace(VirtualSpace vs, DOMImplementation di, File dest) {
        this.destination = dest;
        this.img_subdir = null;
        this.bitmapImages = new Hashtable();
        if (di != null) {
            this.svgDoc = di.createDocument(svgURI, "svg", null);
            Element root = this.svgDoc.getDocumentElement();
            this.svgDoc.appendChild(this.svgDoc.createComment(" Generated by ZVTM (Zoomable Visual Transformation Machine) v0.9.8 http://zvtm.sourceforge.net"));
            double[] lurd = vs.findFarmostGlyphCoords();
            this.farWest = -lurd[0];
            this.farNorth = lurd[1];
            root.setAttribute("xmlns", svgURI);
            root.setAttribute("xmlns:xlink", xlinkURI);
            root.setAttribute("width", "800");
            root.setAttribute("height", "600");
            root.setAttribute("viewBox", "0 0 " + String.valueOf(lurd[2] - lurd[0]) + " " + String.valueOf(lurd[1] - lurd[3]));
            Element mainGroup = this.svgDoc.createElementNS(svgURI, "g");
            mainGroup.setAttribute("style", this.createFontInformation(VText.getMainFont()));
            root.appendChild(mainGroup);
            Glyph[] visibleGlyphs = vs.getDrawingList();
            for (int i = 0; i < visibleGlyphs.length; ++i) {
                Element el = this.processGlyph(visibleGlyphs[i]);
                if (el == null) continue;
                mainGroup.appendChild(el);
            }
            this.bitmapImages.clear();
            this.bitmapImages = null;
            return this.svgDoc;
        }
        return null;
    }

    public Document exportVirtualSpace(VirtualSpace vs, DOMImplementation di, File dest, SVGWriterPostProcessor epp) {
        this.destination = dest;
        this.img_subdir = null;
        this.bitmapImages = new Hashtable();
        if (di != null) {
            this.svgDoc = di.createDocument(svgURI, "svg", null);
            Element root = this.svgDoc.getDocumentElement();
            this.svgDoc.appendChild(this.svgDoc.createComment(" Generated by ZVTM (Zoomable Visual Transformation Machine) v0.9.1 http://zvtm.sourceforge.net"));
            double[] lurd = vs.findFarmostGlyphCoords();
            this.farWest = -lurd[0];
            this.farNorth = lurd[1];
            root.setAttribute("xmlns", svgURI);
            root.setAttribute("xmlns:xlink", xlinkURI);
            root.setAttribute("width", "800");
            root.setAttribute("height", "600");
            root.setAttribute("viewBox", "0 0 " + String.valueOf(lurd[2] - lurd[0]) + " " + String.valueOf(lurd[1] - lurd[3]));
            Element mainGroup = this.svgDoc.createElementNS(svgURI, "g");
            mainGroup.setAttribute("style", this.createFontInformation(VText.getMainFont()));
            root.appendChild(mainGroup);
            Glyph[] visibleGlyphs = vs.getDrawingList();
            for (int i = 0; i < visibleGlyphs.length; ++i) {
                Element el = this.processGlyph(visibleGlyphs[i]);
                if (el == null) continue;
                mainGroup.appendChild(el);
                epp.newElementCreated(el, visibleGlyphs[i], this.svgDoc);
            }
            this.bitmapImages.clear();
            this.bitmapImages = null;
            return this.svgDoc;
        }
        return null;
    }

    private Element processGlyph(Glyph o) {
        if (o.isVisible()) {
            if (o instanceof VEllipse) {
                return this.createEllipse((VEllipse)o);
            }
            if (o instanceof VRectangle) {
                return this.createRect((VRectangle)o);
            }
            if (o instanceof DPath) {
                return this.createPath((DPath)o);
            }
            if (o instanceof VText) {
                return this.createText((VText)o);
            }
            if (o instanceof VCircle) {
                return this.createCircle((VCircle)o);
            }
            if (o instanceof VPolygon) {
                return this.createPolygon((VPolygon)o);
            }
            if (o instanceof VPoint) {
                return this.createPoint((VPoint)o);
            }
            if (o instanceof VSegment) {
                return this.createLine((VSegment)o);
            }
            if (o instanceof VShape) {
                return this.createPolygon((VShape)o);
            }
            if (o instanceof VImage) {
                return this.createImage((VImage)o);
            }
            System.err.println("There is currently no support for outputing this glyph as SVG: " + o);
            return null;
        }
        return null;
    }

    public static String getGenericFontFamily(Font f) {
        String family = f.getFamily().toLowerCase();
        if (family.indexOf(_timesff) != -1 || family.indexOf(_garamondff) != -1 || family.indexOf(_minionff) != -1 || family.indexOf(_cyberbitff) != -1 || family.indexOf(_georgiaff) != -1 || family.indexOf(_serifff) != -1 && family.indexOf(_sansff) == -1) {
            return "serif";
        }
        if (family.indexOf(_sansff) != -1 || family.indexOf(_arialff) != -1 || family.indexOf(_trebuchetff) != -1 || family.indexOf(_verdanaff) != -1 || family.indexOf(_universff) != -1 || family.indexOf(_helveticaff) != -1 || family.indexOf(_tahomaff) != -1 || family.indexOf(_lucidaff) != -1) {
            return "sans-serif";
        }
        if (family.indexOf(_courierff) != -1 || family.indexOf(_monoff) != -1) {
            return "monospace";
        }
        if (family.indexOf(_cursiveff) != -1 || family.indexOf(_caflischff) != -1 || family.indexOf(_poeticaff) != -1 || family.indexOf(_sanvitoff) != -1 || family.indexOf(_corsivaff) != -1) {
            return "cursive";
        }
        if (family.indexOf(_fantasyff) != -1 || family.indexOf(_critterff) != -1) {
            return "fantasy";
        }
        return "serif";
    }

    private String createFontInformation(Font f) {
        return "font-family:" + f.getFamily() + "," + SVGWriter.getGenericFontFamily(f) + ";font-style:" + (f.getStyle() == 2 || f.getStyle() == 3 ? "italic" : "normal") + ";font-weight:" + (f.getStyle() == 1 || f.getStyle() == 3 ? "bold" : "normal") + ";font-size:" + Integer.toString(f.getSize());
    }

    private void createStrokeInformation(Glyph g, Element e) {
        if (g.getStroke() != null && g.getStroke() instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)g.getStroke();
            e.setAttribute(_strokewidth, Float.toString(bs.getLineWidth()));
            if (bs.getEndCap() != 0) {
                e.setAttribute(_strokelinecap, bs.getEndCap() == 2 ? _strokecapsquare : _strokecapround);
            }
            if (bs.getLineJoin() != 0) {
                e.setAttribute(_strokelinejoin, bs.getLineJoin() == 2 ? _strokejoinbevel : _strokejoinround);
            }
            if (bs.getMiterLimit() != DEFAULT_MITER_LIMIT) {
                e.setAttribute(_strokemiterlimit, Float.toString(bs.getMiterLimit()));
            }
            if (bs.getDashArray() != null) {
                e.setAttribute(_strokedasharray, SVGWriter.arrayOffloatAsCSStrings(bs.getDashArray()));
            }
            if (bs.getDashPhase() != DEFAULT_DASH_OFFSET) {
                e.setAttribute(_strokedashoffset, Float.toString(bs.getDashPhase()));
            }
        }
    }

    private String shapeColors(Glyph g) {
        Color fill = g.getColor();
        Color border = g.getBorderColor();
        String res = g.isFilled() ? "fill:rgb(" + fill.getRed() + "," + fill.getGreen() + "," + fill.getBlue() + ")" : "fill:none";
        res = g.isBorderDrawn() ? res + ";stroke:rgb(" + border.getRed() + "," + border.getGreen() + "," + border.getBlue() + ")" : res + ";stroke:none";
        if (g instanceof Translucent) {
            res = res + ";fill-opacity:" + String.valueOf(g.getTranslucencyValue());
        }
        return res;
    }

    private void createClassInforation(Glyph g, Element e) {
        if (g.getType() != null) {
            e.setAttribute(_class, g.getType());
        }
    }

    private Element createGroup() {
        Element res = this.svgDoc.createElementNS(svgURI, "g");
        return res;
    }

    private Element createEllipse(VEllipse e) {
        Element shape = this.svgDoc.createElementNS(svgURI, "ellipse");
        shape.setAttribute("cx", String.valueOf(e.vx + this.farWest));
        shape.setAttribute("cy", String.valueOf(-e.vy + this.farNorth));
        shape.setAttribute("rx", String.valueOf(e.getWidth() / 2.0));
        shape.setAttribute("ry", String.valueOf(e.getHeight() / 2.0));
        shape.setAttribute("style", this.shapeColors((Glyph)e));
        if (e.getStroke() != null) {
            this.createStrokeInformation((Glyph)e, shape);
        }
        this.createClassInforation((Glyph)e, shape);
        return shape;
    }

    private Element createCircle(VCircle c) {
        Element shape = this.svgDoc.createElementNS(svgURI, "circle");
        shape.setAttribute("cx", String.valueOf(c.vx + this.farWest));
        shape.setAttribute("cy", String.valueOf(-c.vy + this.farNorth));
        shape.setAttribute("r", String.valueOf(Math.round(c.getSize() / 2.0)));
        shape.setAttribute("style", this.shapeColors((Glyph)c));
        if (c.getStroke() != null) {
            this.createStrokeInformation((Glyph)c, shape);
        }
        this.createClassInforation((Glyph)c, shape);
        return shape;
    }

    private Element createRect(VRectangle r) {
        Element shape;
        if (r.getOrient() == 0.0) {
            shape = this.svgDoc.createElementNS(svgURI, "rect");
            shape.setAttribute("x", String.valueOf(r.vx - r.getWidth() / 2.0 + this.farWest));
            shape.setAttribute("y", String.valueOf(-r.vy - r.getHeight() / 2.0 + this.farNorth));
            shape.setAttribute("width", String.valueOf(r.getWidth()));
            shape.setAttribute("height", String.valueOf(r.getHeight()));
            shape.setAttribute("style", this.shapeColors((Glyph)r));
        } else {
            shape = this.svgDoc.createElementNS(svgURI, "polygon");
            double x1 = -r.getWidth() / 2.0;
            double y1 = -r.getHeight() / 2.0;
            double x2 = r.getWidth() / 2.0;
            double y2 = r.getHeight() / 2.0;
            double[] xcoords = new double[4];
            double[] ycoords = new double[4];
            xcoords[0] = x2 * Math.cos(Math.PI - r.getOrient()) + y1 * Math.sin(Math.PI - r.getOrient()) + r.vx + this.farWest;
            xcoords[1] = x1 * Math.cos(Math.PI - r.getOrient()) + y1 * Math.sin(Math.PI - r.getOrient()) + r.vx + this.farWest;
            xcoords[2] = x1 * Math.cos(Math.PI - r.getOrient()) + y2 * Math.sin(Math.PI - r.getOrient()) + r.vx + this.farWest;
            xcoords[3] = x2 * Math.cos(Math.PI - r.getOrient()) + y2 * Math.sin(Math.PI - r.getOrient()) + r.vx + this.farWest;
            ycoords[0] = -(y1 * Math.cos(Math.PI - r.getOrient()) - x2 * Math.sin(Math.PI - r.getOrient())) + r.vy + this.farNorth;
            ycoords[1] = -(y1 * Math.cos(Math.PI - r.getOrient()) - x1 * Math.sin(Math.PI - r.getOrient())) + r.vy + this.farNorth;
            ycoords[2] = -(y2 * Math.cos(Math.PI - r.getOrient()) - x1 * Math.sin(Math.PI - r.getOrient())) + r.vy + this.farNorth;
            ycoords[3] = -(y2 * Math.cos(Math.PI - r.getOrient()) - x2 * Math.sin(Math.PI - r.getOrient())) + r.vy + this.farNorth;
            shape.setAttribute("points", String.valueOf(xcoords[0]) + "," + String.valueOf(ycoords[0]) + " " + String.valueOf(xcoords[1]) + "," + String.valueOf(ycoords[1]) + " " + String.valueOf(xcoords[2]) + "," + String.valueOf(ycoords[2]) + " " + String.valueOf(xcoords[3]) + "," + String.valueOf(ycoords[3]));
            shape.setAttribute("style", this.shapeColors((Glyph)r));
        }
        if (r.getStroke() != null) {
            this.createStrokeInformation((Glyph)r, shape);
        }
        this.createClassInforation((Glyph)r, shape);
        return shape;
    }

    public String getSVGPathCoordinates(DPath p) {
        return this.getSVGPathCoordinates(p.getSVGPathIterator());
    }

    public String getSVGPathCoordinates(PathIterator pi) {
        StringBuffer coords = new StringBuffer();
        float[] seg = new float[6];
        int lastOp = 90;
        while (!pi.isDone()) {
            int type = pi.currentSegment(seg);
            switch (type) {
                case 0: {
                    if (lastOp != 77) {
                        coords.append('M');
                    } else {
                        coords.append(' ');
                    }
                    lastOp = 77;
                    coords.append((double)seg[0] + this.farWest + " " + ((double)seg[1] + this.farNorth));
                    break;
                }
                case 1: {
                    if (lastOp != 76) {
                        coords.append('L');
                    } else {
                        coords.append(' ');
                    }
                    lastOp = 76;
                    coords.append((double)seg[0] + this.farWest + " " + ((double)seg[1] + this.farNorth));
                    break;
                }
                case 2: {
                    if (lastOp != 81) {
                        coords.append('Q');
                    } else {
                        coords.append(' ');
                    }
                    lastOp = 81;
                    coords.append((double)seg[0] + this.farWest + " " + ((double)seg[1] + this.farNorth) + " " + ((double)seg[2] + this.farWest) + " " + ((double)seg[3] + this.farNorth));
                    break;
                }
                case 3: {
                    if (lastOp != 67) {
                        coords.append('C');
                    } else {
                        coords.append(' ');
                    }
                    lastOp = 67;
                    coords.append((double)seg[0] + this.farWest + " " + ((double)seg[1] + this.farNorth) + " " + ((double)seg[2] + this.farWest) + " " + ((double)seg[3] + this.farNorth) + " " + ((double)seg[4] + this.farWest) + " " + ((double)seg[5] + this.farNorth));
                }
            }
            pi.next();
        }
        return coords.toString();
    }

    private Element createPath(DPath p) {
        Element path = this.svgDoc.createElementNS(svgURI, "path");
        path.setAttribute("d", this.getSVGPathCoordinates(p));
        Color c = p.getColor();
        String color = "stroke:rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        path.setAttribute("style", "fill:none;" + color);
        if (p.getStroke() != null) {
            this.createStrokeInformation((Glyph)p, path);
        }
        this.createClassInforation((Glyph)p, path);
        return path;
    }

    private Element createText(VText t) {
        Element text = this.svgDoc.createElementNS(svgURI, "text");
        text.setAttribute("x", String.valueOf(t.vx + this.farWest));
        text.setAttribute("y", String.valueOf(-t.vy + this.farNorth));
        if (t.getTextAnchor() == 0) {
            text.setAttribute("text-anchor", "start");
        } else if (t.getTextAnchor() == 1) {
            text.setAttribute("text-anchor", "middle");
        } else if (t.getTextAnchor() == 2) {
            text.setAttribute("text-anchor", "end");
        }
        text.appendChild(this.svgDoc.createTextNode(t.getText()));
        Color c = t.getColor();
        String style = "fill:rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        if (t.usesSpecificFont()) {
            style = this.createFontInformation(t.getFont()) + ";" + style;
        }
        text.setAttribute("style", style);
        this.createClassInforation((Glyph)t, text);
        return text;
    }

    private Element createPoint(VPoint p) {
        Element shape = this.svgDoc.createElementNS(svgURI, "rect");
        shape.setAttribute("x", String.valueOf(p.vx + this.farWest));
        shape.setAttribute("y", String.valueOf(-p.vy + this.farNorth));
        shape.setAttribute("width", "1");
        shape.setAttribute("height", "1");
        Color c = p.getColor();
        shape.setAttribute("style", "stroke:rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
        this.createClassInforation((Glyph)p, shape);
        return shape;
    }

    private Element createLine(VSegment s) {
        Element shape = this.svgDoc.createElementNS(svgURI, "line");
        Point2D.Double[] endPoints = s.getEndPoints();
        shape.setAttribute("x1", String.valueOf(endPoints[0].x + this.farWest));
        shape.setAttribute("y1", String.valueOf(-endPoints[0].y + this.farNorth));
        shape.setAttribute("x2", String.valueOf(endPoints[1].x + this.farWest));
        shape.setAttribute("y2", String.valueOf(-endPoints[1].y + this.farNorth));
        Color c = s.getColor();
        shape.setAttribute("style", "stroke:rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")");
        if (s.getStroke() != null) {
            this.createStrokeInformation((Glyph)s, shape);
        }
        this.createClassInforation((Glyph)s, shape);
        return shape;
    }

    private Element createPolygon(VShape s) {
        Element shape = this.svgDoc.createElementNS(svgURI, "polygon");
        float[] vertices = s.getVertices();
        double vertexAngle = -s.getOrient();
        double[] xcoords = new double[vertices.length];
        double[] ycoords = new double[vertices.length];
        for (int j = 0; j < vertices.length; ++j) {
            xcoords[j] = s.vx + s.getSize() / 2.0 * Math.cos(vertexAngle) * (double)vertices[j] + this.farWest;
            ycoords[j] = -s.vy - s.getSize() / 2.0 * Math.sin(vertexAngle) * (double)vertices[j] + this.farNorth;
            vertexAngle -= Math.PI * 2 / (double)vertices.length;
        }
        String coords = "";
        for (int j = 0; j < vertices.length - 1; ++j) {
            coords = coords + String.valueOf(xcoords[j]) + "," + String.valueOf(ycoords[j]) + " ";
        }
        coords = coords + String.valueOf(xcoords[vertices.length - 1]) + "," + String.valueOf(ycoords[vertices.length - 1]);
        shape.setAttribute("points", coords);
        shape.setAttribute("style", this.shapeColors((Glyph)s));
        if (s.getStroke() != null) {
            this.createStrokeInformation((Glyph)s, shape);
        }
        this.createClassInforation((Glyph)s, shape);
        return shape;
    }

    private Element createPolygon(VPolygon p) {
        Element polygon = this.svgDoc.createElementNS(svgURI, "polygon");
        Point2D.Double[] vertices = p.getVertices();
        double[] xcoords = new double[vertices.length];
        double[] ycoords = new double[vertices.length];
        for (int j = 0; j < vertices.length; ++j) {
            xcoords[j] = p.vx + vertices[j].x + this.farWest;
            ycoords[j] = -p.vy - vertices[j].y + this.farNorth;
        }
        String coords = "";
        for (int j = 0; j < vertices.length - 1; ++j) {
            coords = coords + String.valueOf(xcoords[j]) + "," + String.valueOf(ycoords[j]) + " ";
        }
        coords = coords + String.valueOf(xcoords[vertices.length - 1]) + "," + String.valueOf(ycoords[vertices.length - 1]);
        polygon.setAttribute("points", coords);
        polygon.setAttribute("style", this.shapeColors((Glyph)p));
        if (p.getStroke() != null) {
            this.createStrokeInformation((Glyph)p, polygon);
        }
        this.createClassInforation((Glyph)p, polygon);
        return polygon;
    }

    private Element createImage(VImage i) {
        Element shape;
        try {
            shape = this.svgDoc.createElementNS(svgURI, "image");
            shape.setAttribute("x", String.valueOf(i.vx - i.getWidth() / 2.0 + this.farWest));
            shape.setAttribute("y", String.valueOf(-i.vy - i.getHeight() / 2.0 + this.farNorth));
            shape.setAttribute("width", String.valueOf(i.getWidth()));
            shape.setAttribute("height", String.valueOf(i.getHeight()));
            Image im = i.getImage();
            ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
            File f = null;
            if (this.img_subdir == null || !this.img_subdir.exists() || !this.img_subdir.isDirectory()) {
                String dirName = this.destination.getName();
                int lio = dirName.lastIndexOf(".");
                if (lio > 0) {
                    dirName = dirName.substring(0, lio);
                }
                dirName = dirName + "_files";
                this.img_subdir = new File(this.destination.getParentFile(), dirName);
                this.img_subdir.mkdirs();
            }
            if (this.bitmapImages.containsKey(im)) {
                f = (File)this.bitmapImages.get(im);
            } else {
                f = File.createTempFile("zvtm", ".png", this.img_subdir);
                writer.setOutput(ImageIO.createImageOutputStream(f));
                BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
                bi.createGraphics().drawImage(im, null, null);
                writer.write(bi);
                this.bitmapImages.put(im, f);
            }
            shape.setAttributeNS(xlinkURI, "xlink:href", this.img_subdir.getName() + "/" + f.getName());
        }
        catch (Exception ex) {
            shape = this.svgDoc.createElementNS(svgURI, "rect");
            shape.setAttribute("x", String.valueOf(i.vx - i.getWidth() / 2.0 + this.farWest));
            shape.setAttribute("y", String.valueOf(-i.vy - i.getHeight() / 2.0 + this.farNorth));
            shape.setAttribute("width", String.valueOf(i.getWidth()));
            shape.setAttribute("height", String.valueOf(i.getHeight()));
            System.err.println("SVGWriter:An error occured while exporting " + i.toString() + " to PNG.\n" + ex);
            if (!Utils.javaVersionIs140OrLater()) {
                System.err.println("ZVTM/SVGWriter:Error: the Java Virtual Machine in use seems to be older than version 1.4.0 ; package javax.imageio is probably missing, which prevents generating bitmap files for representing VImage objects. Install a JVM version 1.4.0 or later if you want to use this functionality.");
            }
            ex.printStackTrace();
        }
        this.createClassInforation((Glyph)i, shape);
        return shape;
    }

    public static String arrayOffloatAsCSStrings(float[] ar) {
        String res = "";
        for (int i = 0; i < ar.length - 1; ++i) {
            res = res + Float.toString(ar[i]) + ",";
        }
        res = res + Float.toString(ar[ar.length - 1]);
        return res;
    }
}

