/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.IMultiElementTreeContentProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetAwareContentProvider
extends PackageExplorerContentProvider
implements IMultiElementTreeContentProvider {
    private WorkingSetModel fWorkingSetModel;
    private IPropertyChangeListener fListener;

    public WorkingSetAwareContentProvider(boolean provideMembers, WorkingSetModel model) {
        super(provideMembers);
        this.fWorkingSetModel = model;
        this.fListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetAwareContentProvider.this.workingSetModelChanged(event);
            }
        };
        this.fWorkingSetModel.addPropertyChangeListener(this.fListener);
    }

    @Override
    public void dispose() {
        this.fWorkingSetModel.removePropertyChangeListener(this.fListener);
        super.dispose();
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof IWorkingSet) {
            return true;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object element) {
        if (element instanceof WorkingSetModel) {
            Assert.isTrue((this.fWorkingSetModel == element ? 1 : 0) != 0);
            return this.fWorkingSetModel.getActiveWorkingSets();
        }
        Object[] children = element instanceof IWorkingSet ? this.getWorkingSetChildren((IWorkingSet)element) : super.getChildren(element);
        return children;
    }

    private Object[] getWorkingSetChildren(IWorkingSet set) {
        IAdaptable[] elements = this.fWorkingSetModel.getChildren(set);
        HashSet<IAdaptable> result = new HashSet<IAdaptable>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IProject project;
            IAdaptable element = elements[i];
            if (element instanceof IProject) {
                this.processResource((IResource)((IProject)element), result);
            } else if (element instanceof IResource) {
                project = ((IResource)element).getProject();
                if (project.isOpen()) {
                    this.processResource((IResource)element, result);
                }
            } else if (element instanceof IJavaProject) {
                result.add(element);
            } else if (element instanceof IJavaElement) {
                IJavaElement elem = (IJavaElement)element;
                IProject project2 = this.getProject(elem);
                if (project2 != null && project2.isOpen()) {
                    result.add((IAdaptable)elem);
                }
            } else {
                project = (IProject)element.getAdapter(IProject.class);
                if (project != null) {
                    this.processResource((IResource)project, result);
                }
            }
            ++i;
        }
        return result.toArray();
    }

    private void processResource(IResource resource, Collection<IAdaptable> result) {
        IJavaElement elem = JavaCore.create((IResource)resource);
        if (elem != null && elem.exists()) {
            result.add((IAdaptable)elem);
        } else {
            result.add((IAdaptable)resource);
        }
    }

    private IProject getProject(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        if (project == null) {
            return null;
        }
        return project.getProject();
    }

    @Override
    public TreePath[] getTreePaths(Object element) {
        if (element instanceof IWorkingSet) {
            TreePath path = new TreePath(new Object[]{element});
            return new TreePath[]{path};
        }
        List<Object> modelParents = this.getModelPath(element);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        int i = 0;
        while (i < modelParents.size()) {
            result.addAll(this.getTreePaths(modelParents, i));
            ++i;
        }
        return result.toArray(new TreePath[result.size()]);
    }

    private List<Object> getModelPath(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(element);
        Object parent = super.getParent(element);
        Object input = this.getViewerInput();
        while (parent != null && !parent.equals(input) && !(parent instanceof IJavaModel)) {
            result.add(parent);
            parent = super.getParent(parent);
        }
        Collections.reverse(result);
        return result;
    }

    private List<TreePath> getTreePaths(List<Object> modelParents, int index) {
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        Object input = this.getViewerInput();
        Object element = modelParents.get(index);
        Object[] parents = this.fWorkingSetModel.getAllParents(element);
        int i = 0;
        while (i < parents.length) {
            ArrayList<Object> chain = new ArrayList<Object>();
            if (!parents[i].equals(input)) {
                chain.add(parents[i]);
            }
            int m = index;
            while (m < modelParents.size()) {
                chain.add(modelParents.get(m));
                ++m;
            }
            result.add(new TreePath(chain.toArray()));
            ++i;
        }
        return result;
    }

    @Override
    public Object getParent(Object child) {
        Object[] parents = this.fWorkingSetModel.getAllParents(child);
        if (parents.length == 0) {
            return super.getParent(child);
        }
        Object first = parents[0];
        return first;
    }

    @Override
    protected void augmentElementToRefresh(List<Object> toRefresh, int relation, Object affectedElement) {
        Object parent;
        if (JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(affectedElement)) {
            toRefresh.remove(affectedElement);
            toRefresh.add(this.fWorkingSetModel);
        } else if (relation == 2 && (parent = this.internalGetParent(affectedElement)) != null) {
            toRefresh.addAll(Arrays.asList(this.fWorkingSetModel.getAllParents(parent)));
        }
        List<IAdaptable> nonProjetTopLevelElemens = this.fWorkingSetModel.getNonProjectTopLevelElements();
        if (nonProjetTopLevelElemens.isEmpty()) {
            return;
        }
        ArrayList<IAdaptable> toAdd = new ArrayList<IAdaptable>();
        for (IAdaptable element : nonProjetTopLevelElemens) {
            if (!this.isChildOf(element, toRefresh)) continue;
            toAdd.add(element);
        }
        toRefresh.addAll(toAdd);
    }

    private void workingSetModelChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        Object newValue = event.getNewValue();
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        if ("workingSetModelChanged".equals(property)) {
            toRefresh.add(this.fWorkingSetModel);
        } else if ("workingSetContentChange".equals(property)) {
            toRefresh.add(newValue);
        } else if ("workingSetLabelChange".equals(property)) {
            toRefresh.add(newValue);
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.postRefresh(toRefresh, true, runnables);
        this.executeRunnables(runnables);
    }

    private boolean isChildOf(Object element, List<Object> potentialParents) {
        Object parent = super.getParent(element);
        if (parent == null) {
            return false;
        }
        for (Object potentialParent : potentialParents) {
            while (parent != null) {
                if (parent.equals(potentialParent)) {
                    return true;
                }
                parent = super.getParent(parent);
            }
        }
        return false;
    }
}

