/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fx.ui.workbench.base.rendering.AbstractRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPropertyChangeHandler;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseRenderer<M extends MUIElement, W extends WWidget<M>>
extends AbstractRenderer<M, W> {
    private static final String RENDERING_CONTEXT_KEY = "fx.rendering.context";
    public static final String CONTEXT_DOM_ELEMENT = "fx.rendering.domElement";
    public static final String ATTRIBUTE_localizedLabel = "localizedLabel";
    public static final String ATTRIBUTE_localizedTooltip = "localizedTooltip";
    @Inject
    IEclipseContext _context;
    @Inject
    EModelService modelService;
    private Map<String, EAttribute> attributeMap = new HashMap<String, EAttribute>();
    private Map<MUIElement, Boolean> contentProcessing = new HashMap<MUIElement, Boolean>();
    private Map<MUIElement, Boolean> contextModification = new HashMap<MUIElement, Boolean>();
    private Map<MUIElement, Boolean> uiModification = new HashMap<MUIElement, Boolean>();

    protected boolean inContentProcessing(MUIElement element) {
        return this.contentProcessing.get(element) == Boolean.TRUE;
    }

    protected boolean inContextModification(MUIElement element) {
        return this.contextModification.get(element) == Boolean.TRUE;
    }

    protected boolean inUIModification(MUIElement element) {
        return this.uiModification.get(element) == Boolean.TRUE;
    }

    public final W createWidget(M element) {
        IEclipseContext context = this.setupRenderingContext(element);
        WWidget widget = (WWidget)ContextInjectionFactory.make(this.getWidgetClass(element), (IEclipseContext)context);
        widget.setPropertyChangeHandler(new WPropertyChangeHandler<W>((MUIElement)element){
            private final /* synthetic */ MUIElement val$element;
            {
                this.val$element = mUIElement;
            }

            @Override
            public void propertyObjectChanged(WPropertyChangeHandler.WPropertyChangeEvent<W> event) {
                if (BaseRenderer.this.inUIModification(this.val$element) || BaseRenderer.this.inContextModification(this.val$element)) {
                    return;
                }
                try {
                    EStructuralFeature f;
                    BaseRenderer.this.uiModification.put(this.val$element, Boolean.TRUE);
                    EAttribute attribute = (EAttribute)BaseRenderer.this.attributeMap.get(event.propertyname);
                    EObject eo = (EObject)this.val$element;
                    if (attribute == null && (f = eo.eClass().getEStructuralFeature(event.propertyname)) instanceof EAttribute) {
                        attribute = (EAttribute)f;
                        BaseRenderer.this.attributeMap.put(event.propertyname, attribute);
                    }
                    if (attribute != null) {
                        if (attribute.getEType().getInstanceClass() == Integer.TYPE) {
                            eo.eSet((EStructuralFeature)attribute, (Object)((Number)event.newValue).intValue());
                        } else {
                            eo.eSet((EStructuralFeature)attribute, event.newValue);
                        }
                    }
                }
                finally {
                    BaseRenderer.this.uiModification.remove(this.val$element);
                }
            }
        });
        this.initWidget(element, widget);
        this.initDefaultEventListeners((IEventBroker)this._context.get(IEventBroker.class));
        return (W)widget;
    }

    private void initDefaultEventListeners(IEventBroker broker) {
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/application/ApplicationElement/persistedState/*");
    }

    public final IEclipseContext setupRenderingContext(M element) {
        IEclipseContext context = (IEclipseContext)element.getTransientData().get(RENDERING_CONTEXT_KEY);
        if (context == null) {
            context = this._context.createChild("Element RenderingContext");
            element.getTransientData().put(RENDERING_CONTEXT_KEY, context);
            context.set(CONTEXT_DOM_ELEMENT, element);
            this.initRenderingContext(element, context);
            try {
                this.contextModification.put((MUIElement)element, Boolean.TRUE);
                EObject eo = element instanceof MPlaceholder ? (EObject)((MPlaceholder)element).getRef() : (EObject)element;
                this.initContext(eo, context);
                if (element instanceof MPlaceholder) {
                    this.initContext((EObject)element, context);
                }
            }
            finally {
                this.contextModification.remove(element);
            }
        }
        return context;
    }

    protected void initContext(EObject eo, IEclipseContext context) {
        for (EAttribute eAttribute : eo.eClass().getEAllAttributes()) {
            context.set(eAttribute.getName(), eo.eGet((EStructuralFeature)eAttribute));
        }
        if (eo instanceof MApplicationElement) {
            for (Map.Entry entry : ((MApplicationElement)eo).getPersistedState().entrySet()) {
                context.set("persistedState_" + (String)entry.getKey(), entry.getValue());
            }
        }
        if (eo instanceof MUILabel) {
            MUILabel mUILabel = (MUILabel)eo;
            context.set(ATTRIBUTE_localizedLabel, (Object)mUILabel.getLocalizedLabel());
            context.set(ATTRIBUTE_localizedTooltip, (Object)mUILabel.getLocalizedTooltip());
        }
    }

    protected void registerEventListener(IEventBroker broker, String topic) {
        broker.subscribe(topic, new EventHandler(){

            public void handleEvent(Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MUIElement)) {
                    return;
                }
                Object newValue = event.getProperty("NewValue");
                String attributeName = event.getProperty("AttName").toString();
                if (!UIEvents.isSET((Event)event)) {
                    return;
                }
                MUIElement e = (MUIElement)changedObj;
                if (BaseRenderer.this.inContextModification(e)) {
                    return;
                }
                try {
                    IEclipseContext ctx;
                    BaseRenderer.this.contextModification.put(e, Boolean.TRUE);
                    if (changedObj instanceof MUIElement && e.getRenderer() == BaseRenderer.this && (ctx = (IEclipseContext)e.getTransientData().get(BaseRenderer.RENDERING_CONTEXT_KEY)) != null) {
                        if (attributeName.equals("persistedState") && newValue instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry)newValue;
                            ctx.set(String.valueOf(attributeName) + "_" + (String)entry.getKey(), entry.getValue());
                        } else {
                            ctx.set(attributeName, newValue);
                            if (e instanceof MUILabel) {
                                MUILabel l = (MUILabel)e;
                                if (event.getProperty("AttName").equals("label")) {
                                    ctx.set(BaseRenderer.ATTRIBUTE_localizedLabel, (Object)l.getLocalizedLabel());
                                } else if (event.getProperty("AttName").equals("tooltip")) {
                                    ctx.set(BaseRenderer.ATTRIBUTE_localizedTooltip, (Object)l.getLocalizedTooltip());
                                }
                            }
                        }
                    }
                }
                finally {
                    BaseRenderer.this.contextModification.remove(e);
                }
            }
        });
    }

    protected void initRenderingContext(M element, IEclipseContext context) {
    }

    protected void initWidget(M element, W widget) {
    }

    public void destroyWidget(M element) {
        if (element.getTransientData().containsKey(RENDERING_CONTEXT_KEY)) {
            if (element.getWidget() instanceof WWidget) {
                ((WWidget)element.getWidget()).setWidgetState(WWidget.WidgetState.DISPOSED);
            }
            this.unbindWidget(element, (WWidget)element.getWidget());
            IEclipseContext ctx = (IEclipseContext)element.getTransientData().get(RENDERING_CONTEXT_KEY);
            ctx.dispose();
            element.getTransientData().remove(RENDERING_CONTEXT_KEY);
        }
    }

    private void unbindWidget(M me, W widget) {
        widget.setDomElement(null);
        me.setWidget(null);
    }

    public void bindWidget(M me, W widget) {
        widget.setDomElement(me);
        widget.addStyleClasses(me.getTags());
        EObject eo = (EObject)me;
        widget.addStyleClasses("M" + eo.eClass().getName());
        for (EClass e : eo.eClass().getEAllSuperTypes()) {
            widget.addStyleClasses("M" + e.getName());
        }
        if (me.getElementId() != null) {
            widget.setStyleId(Util.toCSSId(me.getElementId()));
        }
        me.setWidget(widget);
    }

    public void postProcess(M element) {
        if (element.getWidget() instanceof WWidget) {
            ((WWidget)element.getWidget()).setWidgetState(WWidget.WidgetState.CREATED);
        }
    }

    public void preDestroy(M element) {
        if (element.getWidget() instanceof WWidget) {
            ((WWidget)element.getWidget()).setWidgetState(WWidget.WidgetState.IN_TEAR_DOWN);
        }
    }

    protected IPresentationEngine getPresentationEngine() {
        return (IPresentationEngine)this._context.get(IPresentationEngine.class);
    }

    protected abstract Class<? extends W> getWidgetClass(M var1);

    protected <LW extends WWidget<PM>, PM extends MUIElement> LW engineCreateWidget(PM pm) {
        return (LW)((WWidget)this.getPresentationEngine().createGui(pm));
    }

    protected <LW extends WWidget<PM>, PM extends MUIElement> LW engineCreateWidget(PM pm, IEclipseContext context) {
        return (LW)((WWidget)this.getPresentationEngine().createGui(pm, null, context));
    }

    protected IEclipseContext getRenderingContext(M element) {
        return (IEclipseContext)element.getTransientData().get(RENDERING_CONTEXT_KEY);
    }

    protected IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    public IEclipseContext getModelContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    protected void activate(MPart element, boolean requiresFocus) {
        EPartService ps;
        IEclipseContext curContext = this.getModelContext((MUIElement)element);
        if (curContext != null && (ps = (EPartService)curContext.get(EPartService.class.getName())) != null) {
            ps.activate(element, requiresFocus);
        }
    }

    public final void processContent(M element) {
        try {
            this.contentProcessing.put((MUIElement)element, Boolean.TRUE);
            this.doProcessContent(element);
        }
        finally {
            this.contentProcessing.remove(element);
        }
    }

    protected int getRenderedIndex(MUIElement parent, MUIElement element) {
        EObject eElement = (EObject)element;
        EObject container = eElement.eContainer();
        List list = (List)container.eGet((EStructuralFeature)eElement.eContainmentFeature());
        int idx = 0;
        for (MUIElement u : list) {
            if (!u.isToBeRendered() || !u.isVisible()) continue;
            if (u == element) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    protected abstract void doProcessContent(M var1);

    public void focus(MUIElement element) {
        if (element.getWidget() instanceof WWidget) {
            WWidget widget = (WWidget)element.getWidget();
            widget.activate();
        }
    }
}

