/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StitchTiles implements Enumerator
{
    STITCH(0, "stitch", "stitch"),
    NO_STITCH(1, "noStitch", "noStitch");

    public static final int STITCH_VALUE = 0;
    public static final int NO_STITCH_VALUE = 1;
    private static final StitchTiles[] VALUES_ARRAY;
    public static final List<StitchTiles> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StitchTiles[]{STITCH, NO_STITCH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StitchTiles get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StitchTiles result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StitchTiles getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StitchTiles result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StitchTiles get(int value) {
        switch (value) {
            case 0: {
                return STITCH;
            }
            case 1: {
                return NO_STITCH;
            }
        }
        return null;
    }

    private StitchTiles(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

