/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.impl;

import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmInnerTypeReference;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;

class NameConcatHelper {
    NameConcatHelper() {
    }

    static void appendConstraintsName(StringBuilder result, List<JvmTypeConstraint> constraints, char innerClassDelimiter, NameType nameType) {
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        int wasLength = result.length();
        boolean hasLowerBound = false;
        if (nameType != NameType.ID) {
            for (JvmTypeConstraint constraint : constraints) {
                if (!(constraint instanceof JvmLowerBound)) continue;
                hasLowerBound = true;
                break;
            }
        }
        for (JvmTypeConstraint constraint : constraints) {
            if (result.length() != wasLength) {
                result.append(" & ");
            }
            if (hasLowerBound && !(constraint instanceof JvmLowerBound) && nameType != NameType.ID) continue;
            switch (nameType) {
                case ID: {
                    result.append(constraint.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(constraint.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(constraint.getSimpleName());
                    break;
                }
                case TO_STRING: {
                    result.append(constraint.toString());
                }
            }
        }
    }

    static String computeFor(JvmWildcardTypeReference typeReference, char innerClassDelimiter, NameType nameType) {
        if (typeReference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_CONSTRAINT_OWNER__CONSTRAINTS)) {
            if (typeReference.getConstraints().size() == 1) {
                JvmTypeReference reference;
                JvmTypeConstraint onlyConstraint = (JvmTypeConstraint)typeReference.getConstraints().get(0);
                if (nameType != NameType.ID && nameType != NameType.TO_STRING ? (reference = onlyConstraint.getTypeReference()) == null || onlyConstraint instanceof JvmUpperBound && Object.class.getCanonicalName().equals(onlyConstraint.getTypeReference().getIdentifier()) : nameType == NameType.ID && onlyConstraint.getTypeReference() == null) {
                    return "?";
                }
            }
            StringBuilder mutableResult = new StringBuilder(64);
            mutableResult.append("? ");
            NameConcatHelper.appendConstraintsName(mutableResult, (List<JvmTypeConstraint>)typeReference.getConstraints(), innerClassDelimiter, nameType);
            return mutableResult.toString();
        }
        return "?";
    }

    static String computeFor(JvmParameterizedTypeReference typeReference, char innerClassDelimiter, NameType nameType) {
        if (typeReference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)) {
            StringBuilder mutableResult = new StringBuilder(64);
            NameConcatHelper.computeFor(typeReference, innerClassDelimiter, nameType, mutableResult);
            return mutableResult.toString();
        }
        return null;
    }

    private static void computeFor(JvmParameterizedTypeReference typeReference, char innerClassDelimiter, NameType nameType, StringBuilder result) {
        if (typeReference.eClass() == TypesPackage.Literals.JVM_INNER_TYPE_REFERENCE) {
            JvmParameterizedTypeReference outer = ((JvmInnerTypeReference)typeReference).getOuter();
            if (outer != null) {
                NameConcatHelper.computeFor(outer, innerClassDelimiter, nameType, result);
                if (result.length() != 0) {
                    JvmType type = typeReference.getType();
                    result.append(innerClassDelimiter);
                    result.append(type.getSimpleName());
                } else {
                    NameConcatHelper.appendType(typeReference, innerClassDelimiter, nameType, result);
                }
            } else {
                NameConcatHelper.appendType(typeReference, innerClassDelimiter, nameType, result);
            }
        } else {
            NameConcatHelper.appendType(typeReference, innerClassDelimiter, nameType, result);
        }
        if (typeReference.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__ARGUMENTS)) {
            result.append("<");
            NameConcatHelper.appendArguments(result, typeReference.getArguments(), innerClassDelimiter, nameType);
            result.append(">");
        }
    }

    private static void appendType(JvmParameterizedTypeReference typeReference, char innerClassDelimiter, NameType nameType, StringBuilder result) {
        JvmType type = typeReference.getType();
        if (type != null) {
            switch (nameType) {
                case ID: {
                    result.append(type.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(type.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(type.getSimpleName());
                    break;
                }
                case TO_STRING: {
                    result.append(type.getIdentifier());
                }
            }
        }
    }

    static void appendArguments(StringBuilder result, List<JvmTypeReference> arguments, char innerClassDelimiter, NameType nameType) {
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        int wasLength = result.length();
        for (JvmTypeReference argument : arguments) {
            if (result.length() != wasLength) {
                result.append(", ");
            }
            switch (nameType) {
                case ID: {
                    result.append(argument.getIdentifier());
                    break;
                }
                case QUALIFIED: {
                    result.append(argument.getQualifiedName(innerClassDelimiter));
                    break;
                }
                case SIMPLE: {
                    result.append(argument.getSimpleName());
                    break;
                }
                case TO_STRING: {
                    result.append(argument.toString());
                }
            }
        }
    }

    static enum NameType {
        ID,
        QUALIFIED,
        SIMPLE,
        TO_STRING;

    }
}

