/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import com.google.common.base.Preconditions;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.ConflictingFormattingException;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IAutowrapFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.debug.HiddenRegionFormattingToString;

public class HiddenRegionFormatting
implements IHiddenRegionFormatter,
IHiddenRegionFormatting {
    private Integer autowrap = null;
    private final AbstractFormatter2 formatter;
    private Integer indentationDecrease = null;
    private Integer indentationIncrease = null;
    private Integer newLineDefault = null;
    private Integer newLineMax = null;
    private Integer newLineMin = null;
    private Boolean noIndentation;
    private IAutowrapFormatter onAutowrap;
    private int priority = 0;
    private String space = null;

    public HiddenRegionFormatting(AbstractFormatter2 formatter) {
        this.formatter = formatter;
    }

    @Override
    public IHiddenRegionFormatting asBean() {
        return this;
    }

    @Override
    public IHiddenRegionFormatter asFormatter() {
        return this;
    }

    @Override
    public void autowrap() {
        if (this.autowrap == null || this.autowrap < 0) {
            this.autowrap = 0;
        }
    }

    @Override
    public void autowrap(int triggerLength) {
        this.autowrap = triggerLength;
    }

    @Override
    public void decreaseIndentation() {
        this.indentationDecrease = this.indentationDecrease == null ? 1 : this.indentationDecrease + 1;
    }

    @Override
    public Integer getAutowrap() {
        return this.autowrap;
    }

    public AbstractFormatter2 getFormatter() {
        return this.formatter;
    }

    @Override
    public Integer getIndentationDecrease() {
        return this.indentationDecrease;
    }

    @Override
    public Integer getIndentationIncrease() {
        return this.indentationIncrease;
    }

    @Override
    public Integer getNewLineDefault() {
        return this.newLineDefault;
    }

    @Override
    public Integer getNewLineMax() {
        return this.newLineMax;
    }

    @Override
    public Integer getNewLineMin() {
        return this.newLineMin;
    }

    @Override
    public Boolean getNoIndentation() {
        return this.noIndentation;
    }

    @Override
    public IAutowrapFormatter getOnAutowrap() {
        return this.onAutowrap;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public FormatterRequest getRequest() {
        return this.formatter.getRequest();
    }

    @Override
    public String getSpace() {
        return this.space;
    }

    @Override
    public void highPriority() {
        this.setPriority(1);
    }

    @Override
    public void increaseIndentation() {
        this.indentationIncrease = this.indentationIncrease == null ? 1 : this.indentationIncrease + 1;
    }

    @Override
    public void lowPriority() {
        this.setPriority(-1);
    }

    protected <T> T merge(T val1, T val2, int strategy, String propertyname) throws ConflictingFormattingException {
        if (val1 != null && val2 != null) {
            if (val1.equals(val2) || strategy < 0) {
                return val1;
            }
            if (strategy > 0) {
                return val2;
            }
            String message = "Conflicting values for '" + propertyname + "': '" + val1 + "' and '" + val2 + "'.";
            throw new ConflictingFormattingException(message);
        }
        return val1 != null ? val1 : val2;
    }

    @Override
    public void mergeValuesFrom(IHiddenRegionFormatting other) throws ConflictingFormattingException {
        int strategy = other.getPriority() - this.getPriority();
        this.setSpace(this.merge(this.getSpace(), other.getSpace(), strategy, "space"));
        this.setNewLinesMin(this.merge(this.getNewLineMin(), other.getNewLineMin(), strategy, "newLineMin"));
        this.setNewLinesDefault(this.merge(this.getNewLineDefault(), other.getNewLineDefault(), strategy, "newLineDefault"));
        this.setNewLinesMax(this.merge(this.getNewLineMax(), other.getNewLineMax(), strategy, "newLineMax"));
        this.setAutowrap(this.merge(this.getAutowrap(), other.getAutowrap(), strategy, "autowrap"));
        this.setOnAutowrap(this.merge(this.getOnAutowrap(), other.getOnAutowrap(), strategy, "onAutowrap"));
        this.setNoIndentation(this.merge(this.getNoIndentation(), other.getNoIndentation(), strategy, "noIndentation"));
        if (this.getIndentationIncrease() != null && other.getIndentationIncrease() != null) {
            this.setIndentationIncrease(this.getIndentationIncrease() + other.getIndentationIncrease());
        } else {
            this.setIndentationIncrease(this.getIndentationIncrease() != null ? this.getIndentationIncrease() : other.getIndentationIncrease());
        }
        if (this.getIndentationDecrease() != null && other.getIndentationDecrease() != null) {
            this.setIndentationDecrease(this.getIndentationDecrease() + other.getIndentationDecrease());
        } else {
            this.setIndentationDecrease(this.getIndentationDecrease() != null ? this.getIndentationDecrease() : other.getIndentationDecrease());
        }
    }

    @Override
    public void newLine() {
        this.setNewLines(1);
    }

    @Override
    public void noAutowrap() {
        this.autowrap = -1;
    }

    @Override
    public void noIndentation() {
        this.noIndentation = Boolean.TRUE;
    }

    @Override
    public void noSpace() {
        this.setSpace("");
    }

    @Override
    public void oneSpace() {
        this.setSpace(" ");
    }

    @Override
    public void setAutowrap(Integer value) {
        this.autowrap = value;
    }

    @Override
    public void setDecreaseIndentation(int indentation) {
        this.indentationDecrease = indentation;
    }

    @Override
    public void setIncreaseIndentation(int indentation) {
        this.indentationIncrease = indentation;
    }

    @Override
    public void setIndentationDecrease(Integer indentation) {
        this.indentationDecrease = indentation;
    }

    @Override
    public void setIndentationIncrease(Integer indentation) {
        this.indentationIncrease = indentation;
    }

    @Override
    public void setNewLines(int newLines) {
        this.setNewLines(newLines, newLines, newLines);
    }

    @Override
    public void setNewLines(int minNewLines, int defaultNewLines, int maxNewLines) {
        Preconditions.checkArgument((minNewLines >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((defaultNewLines >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxNewLines >= 0 ? 1 : 0) != 0);
        this.newLineMin = minNewLines;
        this.newLineDefault = defaultNewLines;
        this.newLineMax = maxNewLines;
    }

    @Override
    public void setNewLinesDefault(Integer newLines) {
        this.newLineDefault = newLines;
    }

    @Override
    public void setNewLinesMax(Integer newLines) {
        this.newLineMax = newLines;
    }

    @Override
    public void setNewLinesMin(Integer newLines) {
        this.newLineMin = newLines;
    }

    @Override
    public void setNoIndentation(Boolean value) {
        this.noIndentation = value;
    }

    @Override
    public void setOnAutowrap(IAutowrapFormatter formatter) {
        this.autowrap();
        this.onAutowrap = formatter;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setSpace(String space) {
        this.space = space;
    }

    public String toString() {
        return new HiddenRegionFormattingToString().apply(this);
    }
}

