/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Display implements Enumerator
{
    INLINE(0, "inline", "inline"),
    BLOCK(1, "block", "block"),
    LIST_ITEM(2, "list_item", "list-item"),
    RUN_IN(3, "run_in", "run-in"),
    COMPACT(4, "compact", "compact"),
    MARKER(5, "marker", "marker"),
    TABLE(6, "table", "table"),
    INLINE_TABLE(7, "inline_table", "inline-table"),
    TABLE_ROW_GROUP(8, "table_row_group", "table-row-group"),
    TABLE_HEADER_GROUP(9, "table_header_group", "table-header-group"),
    TABLE_FOOTER_GROUP(10, "table_footer_group", "table-footer-group"),
    TABLE_ROW(11, "table_row", "table-row"),
    TABLE_COLUMN_GROUP(12, "table_column_group", "table-column-group"),
    TABLE_COLUMN(13, "table_column", "table-column"),
    TABLE_CELL(14, "table_cell", "table-cell"),
    TABLE_CAPTION(15, "table_caption", "table-caption"),
    NONE(16, "none", "none"),
    INHERIT(17, "inherit", "inherit");

    public static final int INLINE_VALUE = 0;
    public static final int BLOCK_VALUE = 1;
    public static final int LIST_ITEM_VALUE = 2;
    public static final int RUN_IN_VALUE = 3;
    public static final int COMPACT_VALUE = 4;
    public static final int MARKER_VALUE = 5;
    public static final int TABLE_VALUE = 6;
    public static final int INLINE_TABLE_VALUE = 7;
    public static final int TABLE_ROW_GROUP_VALUE = 8;
    public static final int TABLE_HEADER_GROUP_VALUE = 9;
    public static final int TABLE_FOOTER_GROUP_VALUE = 10;
    public static final int TABLE_ROW_VALUE = 11;
    public static final int TABLE_COLUMN_GROUP_VALUE = 12;
    public static final int TABLE_COLUMN_VALUE = 13;
    public static final int TABLE_CELL_VALUE = 14;
    public static final int TABLE_CAPTION_VALUE = 15;
    public static final int NONE_VALUE = 16;
    public static final int INHERIT_VALUE = 17;
    private static final Display[] VALUES_ARRAY;
    public static final List<Display> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Display[]{INLINE, BLOCK, LIST_ITEM, RUN_IN, COMPACT, MARKER, TABLE, INLINE_TABLE, TABLE_ROW_GROUP, TABLE_HEADER_GROUP, TABLE_FOOTER_GROUP, TABLE_ROW, TABLE_COLUMN_GROUP, TABLE_COLUMN, TABLE_CELL, TABLE_CAPTION, NONE, INHERIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Display get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Display result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Display getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Display result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Display get(int value) {
        switch (value) {
            case 0: {
                return INLINE;
            }
            case 1: {
                return BLOCK;
            }
            case 2: {
                return LIST_ITEM;
            }
            case 3: {
                return RUN_IN;
            }
            case 4: {
                return COMPACT;
            }
            case 5: {
                return MARKER;
            }
            case 6: {
                return TABLE;
            }
            case 7: {
                return INLINE_TABLE;
            }
            case 8: {
                return TABLE_ROW_GROUP;
            }
            case 9: {
                return TABLE_HEADER_GROUP;
            }
            case 10: {
                return TABLE_FOOTER_GROUP;
            }
            case 11: {
                return TABLE_ROW;
            }
            case 12: {
                return TABLE_COLUMN_GROUP;
            }
            case 13: {
                return TABLE_COLUMN;
            }
            case 14: {
                return TABLE_CELL;
            }
            case 15: {
                return TABLE_CAPTION;
            }
            case 16: {
                return NONE;
            }
            case 17: {
                return INHERIT;
            }
        }
        return null;
    }

    private Display(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

