/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.text;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.log.LoggerCreator;

public interface TextRegistry {
    public Subscription register(Consumer<String> var1, Supplier<String> var2);

    public void updateBindings();

    default public Supplier<String> getSupplierByKey(String key, final Object ... values) {
        if (values.length == 0) {
            try {
                final Method m2 = this.getClass().getMethod(key, new Class[0]);
                return new Supplier<String>(){

                    @Override
                    public String get() {
                        try {
                            return (String)m2.invoke((Object)this, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (NoSuchMethodException | SecurityException exception) {
                LoggerCreator.createLogger(this.getClass()).error("No translation for '" + key + "' is found");
            }
        } else {
            try {
                Stream.of(this.getClass().getMethods()).filter(m -> (String.valueOf(key) + "_supplier").equals(m.getName())).findFirst().map(m -> new Supplier<String>(){

                    @Override
                    public String get() {
                        try {
                            return (String)m.invoke((Object)this, values);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (SecurityException securityException) {
                LoggerCreator.createLogger(this.getClass()).error("No translation for '" + key + "' is found");
            }
        }
        return null;
    }
}

