/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.file;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.FileLocations;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Pure;

public class FileLocationsImpl
implements FileLocations {
    @Inject
    @Accessors
    private Provider<WorkspaceConfig> projectInformationProvider;

    protected ProjectConfig getProjectConfig(Path path) {
        List _segments = path.getSegments();
        String string = (String)_segments.get(0);
        WorkspaceConfig _get = (WorkspaceConfig)this.projectInformationProvider.get();
        ProjectConfig projectConfig = _get.getProject(string);
        boolean _equals = Objects.equal((Object)projectConfig, null);
        if (_equals) {
            throw new IllegalArgumentException("The project '" + string + "' has not been configured.");
        }
        return projectConfig;
    }

    public Path getSourceFolder(Path path) {
        ProjectConfig config = this.getProjectConfig(path);
        return config.getContainingSourceFolder(path);
    }

    public Path getTargetFolder(Path path) {
        ProjectConfig config = this.getProjectConfig(path);
        Map<Path, Path> _sourceFolderMappings = config.getSourceFolderMappings();
        Set<Path> _keySet = _sourceFolderMappings.keySet();
        for (Path src : _keySet) {
            boolean _startsWith = path.startsWith(src);
            if (!_startsWith) continue;
            Map<Path, Path> _sourceFolderMappings_1 = config.getSourceFolderMappings();
            return _sourceFolderMappings_1.get(src);
        }
        return null;
    }

    public Path getProjectFolder(Path path) {
        ProjectConfig config = this.getProjectConfig(path);
        return config.getRootPath();
    }

    public Set<Path> getProjectSourceFolders(Path path) {
        ProjectConfig config = this.getProjectConfig(path);
        Map<Path, Path> _sourceFolderMappings = config.getSourceFolderMappings();
        Set<Path> _keySet = _sourceFolderMappings.keySet();
        return Collections.unmodifiableSet(_keySet);
    }

    @Pure
    public Provider<WorkspaceConfig> getProjectInformationProvider() {
        return this.projectInformationProvider;
    }

    public void setProjectInformationProvider(Provider<WorkspaceConfig> projectInformationProvider) {
        this.projectInformationProvider = projectInformationProvider;
    }
}

