/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractStackedTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationStateWithExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedImplicitFirstArgument;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedImplicitReceiver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeCheckpointComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithExpectation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ExpressionTypeComputationState
extends AbstractStackedTypeComputationState {
    protected final XExpression expression;

    protected ExpressionTypeComputationState(StackedResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, AbstractTypeComputationState parent, XExpression expression) {
        super(resolvedTypes, featureScopeSession, parent);
        this.expression = expression;
    }

    @Override
    protected ExpressionAwareStackedResolvedTypes doComputeTypes(XExpression expression) {
        if (expression == this.expression) {
            throw new IllegalArgumentException("Attempt to compute the type of the currently computed expression: " + expression);
        }
        this.markAsPropagated();
        return super.doComputeTypes(expression);
    }

    protected void markAsPropagated() {
        this.getResolvedTypes().setPropagatedType(this.expression);
    }

    protected void markAsRefinedTypeIfNecessary(IFeatureLinkingCandidate candidate) {
        JvmIdentifiableElement feature = candidate.getFeature();
        if (feature != null && this.resolvedTypes.isRefinedType(feature)) {
            this.resolvedTypes.setRefinedType(candidate.getExpression());
        }
    }

    @Override
    protected ExpressionAwareStackedResolvedTypes pushTypes(XExpression expression) {
        return this.getResolvedTypes().pushTypes(expression);
    }

    @Override
    protected LightweightTypeReference acceptType(ResolvedTypes resolvedTypes, AbstractTypeExpectation expectation, LightweightTypeReference type, boolean returnType, int flags) {
        LightweightTypeReference result = resolvedTypes.acceptType(this.expression, expectation, type, returnType, flags);
        this.getParent().acceptType(this.expression, resolvedTypes, expectation, type, returnType, flags);
        return result;
    }

    @Override
    protected LightweightTypeReference acceptType(XExpression expression, ResolvedTypes resolvedTypes, AbstractTypeExpectation expectation, LightweightTypeReference type, boolean returnType, int flags) {
        if (expression != this.expression) {
            LightweightTypeReference result = resolvedTypes.acceptType(this.expression, expectation, type, returnType, flags);
            this.getParent().acceptType(this.expression, resolvedTypes, expectation, type, returnType, flags);
            return result;
        }
        return this.getParent().acceptType(expression, resolvedTypes, expectation, type, returnType, flags);
    }

    @Override
    public TypeComputationStateWithExpectation withExpectation(LightweightTypeReference expectation) {
        return new ExpressionTypeComputationStateWithExpectation(this.getResolvedTypes(), this.getFeatureScopeSession(), this, expectation);
    }

    @Override
    public AbstractTypeComputationState withoutExpectation() {
        return new ExpressionTypeComputationStateWithExpectation(this.getResolvedTypes(), this.getFeatureScopeSession(), this, null);
    }

    @Override
    public TypeCheckpointComputationState withTypeCheckpoint(EObject context) {
        return new ExpressionAwareTypeCheckpointComputationState(this.getResolvedTypes(), this.getFeatureScopeSession(), this);
    }

    @Override
    protected IFeatureLinkingCandidate createResolvedLink(XAbstractFeatureCall featureCall, JvmIdentifiableElement resolvedTo) {
        if (this.isImplicitReceiver(featureCall)) {
            return new ResolvedImplicitReceiver((XAbstractFeatureCall)featureCall.eContainer(), featureCall, this);
        }
        if (this.isImplicitFirstArgument(featureCall)) {
            return new ResolvedImplicitFirstArgument((XAbstractFeatureCall)featureCall.eContainer(), featureCall, this);
        }
        return super.createResolvedLink(featureCall, resolvedTo);
    }

    protected boolean isImplicitReceiver(XAbstractFeatureCall featureCall) {
        boolean result = featureCall.eContainingFeature() == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__IMPLICIT_RECEIVER;
        return result;
    }

    protected boolean isImplicitFirstArgument(XAbstractFeatureCall featureCall) {
        boolean result = featureCall.eContainingFeature() == XbasePackage.Literals.XABSTRACT_FEATURE_CALL__IMPLICIT_FIRST_ARGUMENT;
        return result;
    }

    protected boolean isInstanceContext() {
        return this.getFeatureScopeSession().isInstanceContext();
    }

    protected StackedResolvedTypes getStackedResolvedTypes() {
        return (StackedResolvedTypes)this.resolvedTypes;
    }

    protected class ExpressionAwareTypeCheckpointComputationState
    extends TypeCheckpointComputationState {
        protected ExpressionAwareTypeCheckpointComputationState(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, AbstractTypeComputationState parent) {
            super(resolvedTypes, featureScopeSession, parent);
        }

        @Override
        protected ExpressionAwareStackedResolvedTypes doComputeTypes(XExpression expression) {
            ExpressionTypeComputationState.this.markAsPropagated();
            return super.doComputeTypes(expression);
        }

        @Override
        public TypeCheckpointComputationState withTypeCheckpoint(EObject context) {
            return new ExpressionAwareTypeCheckpointComputationState(this.getResolvedTypes(), this.getFeatureScopeSession(), this);
        }
    }
}

