/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui;

import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fx.text.ui.ITextInputListener;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.ITextViewerExtension5;
import org.eclipse.fx.text.ui.IUndoManager;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;

public class DefaultUndoManager
implements IUndoManager {
    private IDocument fDocument;
    private IDocumentUndoManager fDocumentUndoManager;
    private ITextViewer fTextViewer;
    private int fUndoLevel;
    private ITextInputListener fTextInputListener = new ITextInputListener(){

        @Override
        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            DefaultUndoManager.this.connectDocumentUndoManager(newInput);
        }

        @Override
        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            DefaultUndoManager.this.disconnectDocumentUndoManager();
        }
    };
    private IDocumentUndoListener fDocumentUndoListener = new IDocumentUndoListener(){

        public void documentUndoNotification(DocumentUndoEvent event) {
            if (!DefaultUndoManager.this.isConnected()) {
                return;
            }
            int eventType = event.getEventType();
            if ((eventType & 1) != 0 || (eventType & 2) != 0) {
                event.isCompound();
            } else if ((eventType & 4) != 0 || (eventType & 8) != 0) {
                event.isCompound();
                if (DefaultUndoManager.this.fTextViewer != null) {
                    DefaultUndoManager.this.fTextViewer.getTextWidget();
                    DefaultUndoManager.this.selectAndReveal(event.getOffset(), event.getText() == null ? 0 : event.getText().length());
                }
            }
        }
    };

    public DefaultUndoManager(int undoLevel) {
        this.fUndoLevel = undoLevel;
    }

    private boolean isConnected() {
        return this.fTextViewer != null && this.fDocumentUndoManager != null;
    }

    private void onKeyPressed(KeyEvent e) {
        switch (e.getCode()) {
            case LEFT: 
            case UP: 
            case RIGHT: 
            case DOWN: {
                if (!this.isConnected()) break;
                this.fDocumentUndoManager.commit();
            }
        }
    }

    private void onMousePressed(MouseEvent e) {
        if (e.getClickCount() == 1 && this.isConnected()) {
            this.fDocumentUndoManager.commit();
        }
    }

    private void selectAndReveal(int offset, int length) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fTextViewer);
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.fTextViewer.overlapsWithVisibleRegion(offset, length)) {
            this.fTextViewer.resetVisibleRegion();
        }
        this.fTextViewer.getTextWidget().setSelection(new TextSelection(offset, length));
    }

    private void connectDocumentUndoManager(IDocument document) {
        this.disconnectDocumentUndoManager();
        if (document != null) {
            this.fDocument = document;
            DocumentUndoManagerRegistry.connect((IDocument)this.fDocument);
            this.fDocumentUndoManager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)this.fDocument);
            this.fDocumentUndoManager.connect((Object)this);
            this.setMaximalUndoLevel(this.fUndoLevel);
            this.fDocumentUndoManager.addDocumentUndoListener(this.fDocumentUndoListener);
        }
    }

    private void disconnectDocumentUndoManager() {
        if (this.fDocumentUndoManager != null) {
            this.fDocumentUndoManager.disconnect((Object)this);
            this.fDocumentUndoManager.removeDocumentUndoListener(this.fDocumentUndoListener);
            this.fDocumentUndoListener = null;
            this.fDocumentUndoManager = null;
        }
    }

    @Override
    public void connect(ITextViewer viewer) {
        this.fTextViewer = viewer;
        this.fTextViewer.getTextWidget().addEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.fTextViewer.getTextWidget().addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyPressed);
        this.fTextViewer.addTextInputListener(this.fTextInputListener);
        this.connectDocumentUndoManager(this.fTextViewer.getDocument());
    }

    @Override
    public void disconnect() {
        this.fTextViewer.getTextWidget().removeEventHandler(MouseEvent.MOUSE_PRESSED, this::onMousePressed);
        this.fTextViewer.getTextWidget().removeEventHandler(KeyEvent.KEY_PRESSED, this::onKeyPressed);
        this.fTextViewer.removeTextInputListener(this.fTextInputListener);
        this.fTextViewer = null;
        this.disconnectDocumentUndoManager();
    }

    @Override
    public void beginCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.beginCompoundChange();
        }
    }

    @Override
    public void endCompoundChange() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.endCompoundChange();
        }
    }

    @Override
    public void reset() {
        if (this.isConnected()) {
            this.fDocumentUndoManager.reset();
        }
    }

    @Override
    public void setMaximalUndoLevel(int undoLevel) {
        this.fUndoLevel = Math.max(0, undoLevel);
        if (this.isConnected()) {
            this.fDocumentUndoManager.setMaximalUndoLevel(this.fUndoLevel);
        }
    }

    @Override
    public boolean undoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.undoable();
        }
        return false;
    }

    @Override
    public boolean redoable() {
        if (this.isConnected()) {
            return this.fDocumentUndoManager.redoable();
        }
        return false;
    }

    @Override
    public void undo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.undo();
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void redo() {
        if (this.isConnected()) {
            try {
                this.fDocumentUndoManager.redo();
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
        }
    }
}

