/*******************************************************************************
 * Copyright (c) 2012 BestSolution.at and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl<tom.schindl@bestsolution.at> - initial API and implementation
 *******************************************************************************/
package org.eclipse.fx.formats.svg.svg;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Font weight</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.fx.formats.svg.svg.SvgPackage#getFont_weight()
 * @model
 * @generated
 */
public enum Font_weight implements Enumerator {
	/**
	 * The '<em><b>Normal</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NORMAL_VALUE
	 * @generated
	 * @ordered
	 */
	NORMAL(0, "normal", "normal"),

	/**
	 * The '<em><b>Bold</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BOLD_VALUE
	 * @generated
	 * @ordered
	 */
	BOLD(1, "bold", "bold"),

	/**
	 * The '<em><b>Bolder</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BOLDER_VALUE
	 * @generated
	 * @ordered
	 */
	BOLDER(2, "bolder", "bolder"),

	/**
	 * The '<em><b>Lighter</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIGHTER_VALUE
	 * @generated
	 * @ordered
	 */
	LIGHTER(3, "lighter", "lighter"),

	/**
	 * The '<em><b>Em100</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM100_VALUE
	 * @generated
	 * @ordered
	 */
	EM100(4, "em100", "100"),

	/**
	 * The '<em><b>Em200</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM200_VALUE
	 * @generated
	 * @ordered
	 */
	EM200(5, "em200", "200"),

	/**
	 * The '<em><b>Em300</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM300_VALUE
	 * @generated
	 * @ordered
	 */
	EM300(6, "em300", "300"),

	/**
	 * The '<em><b>Em400</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM400_VALUE
	 * @generated
	 * @ordered
	 */
	EM400(7, "em400", "400"),

	/**
	 * The '<em><b>Em500</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM500_VALUE
	 * @generated
	 * @ordered
	 */
	EM500(8, "em500", "500"),

	/**
	 * The '<em><b>Em600</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM600_VALUE
	 * @generated
	 * @ordered
	 */
	EM600(9, "em600", "600"),

	/**
	 * The '<em><b>Em700</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM700_VALUE
	 * @generated
	 * @ordered
	 */
	EM700(10, "em700", "700"),

	/**
	 * The '<em><b>Em800</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM800_VALUE
	 * @generated
	 * @ordered
	 */
	EM800(11, "em800", "800"),

	/**
	 * The '<em><b>Em900</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EM900_VALUE
	 * @generated
	 * @ordered
	 */
	EM900(12, "em900", "900"),

	/**
	 * The '<em><b>Inherit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INHERIT_VALUE
	 * @generated
	 * @ordered
	 */
	INHERIT(13, "inherit", "inherit");

	/**
	 * The '<em><b>Normal</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Normal</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NORMAL
	 * @model name="normal"
	 * @generated
	 * @ordered
	 */
	public static final int NORMAL_VALUE = 0;

	/**
	 * The '<em><b>Bold</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Bold</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BOLD
	 * @model name="bold"
	 * @generated
	 * @ordered
	 */
	public static final int BOLD_VALUE = 1;

	/**
	 * The '<em><b>Bolder</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Bolder</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BOLDER
	 * @model name="bolder"
	 * @generated
	 * @ordered
	 */
	public static final int BOLDER_VALUE = 2;

	/**
	 * The '<em><b>Lighter</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Lighter</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIGHTER
	 * @model name="lighter"
	 * @generated
	 * @ordered
	 */
	public static final int LIGHTER_VALUE = 3;

	/**
	 * The '<em><b>Em100</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em100</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM100
	 * @model name="em100" literal="100"
	 * @generated
	 * @ordered
	 */
	public static final int EM100_VALUE = 4;

	/**
	 * The '<em><b>Em200</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em200</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM200
	 * @model name="em200" literal="200"
	 * @generated
	 * @ordered
	 */
	public static final int EM200_VALUE = 5;

	/**
	 * The '<em><b>Em300</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em300</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM300
	 * @model name="em300" literal="300"
	 * @generated
	 * @ordered
	 */
	public static final int EM300_VALUE = 6;

	/**
	 * The '<em><b>Em400</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em400</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM400
	 * @model name="em400" literal="400"
	 * @generated
	 * @ordered
	 */
	public static final int EM400_VALUE = 7;

	/**
	 * The '<em><b>Em500</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em500</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM500
	 * @model name="em500" literal="500"
	 * @generated
	 * @ordered
	 */
	public static final int EM500_VALUE = 8;

	/**
	 * The '<em><b>Em600</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em600</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM600
	 * @model name="em600" literal="600"
	 * @generated
	 * @ordered
	 */
	public static final int EM600_VALUE = 9;

	/**
	 * The '<em><b>Em700</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em700</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM700
	 * @model name="em700" literal="700"
	 * @generated
	 * @ordered
	 */
	public static final int EM700_VALUE = 10;

	/**
	 * The '<em><b>Em800</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em800</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM800
	 * @model name="em800" literal="800"
	 * @generated
	 * @ordered
	 */
	public static final int EM800_VALUE = 11;

	/**
	 * The '<em><b>Em900</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Em900</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EM900
	 * @model name="em900" literal="900"
	 * @generated
	 * @ordered
	 */
	public static final int EM900_VALUE = 12;

	/**
	 * The '<em><b>Inherit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>Inherit</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INHERIT
	 * @model name="inherit"
	 * @generated
	 * @ordered
	 */
	public static final int INHERIT_VALUE = 13;

	/**
	 * An array of all the '<em><b>Font weight</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final Font_weight[] VALUES_ARRAY =
		new Font_weight[] {
			NORMAL,
			BOLD,
			BOLDER,
			LIGHTER,
			EM100,
			EM200,
			EM300,
			EM400,
			EM500,
			EM600,
			EM700,
			EM800,
			EM900,
			INHERIT,
		};

	/**
	 * A public read-only list of all the '<em><b>Font weight</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<Font_weight> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Font weight</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Font_weight get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Font_weight result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Font weight</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Font_weight getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Font_weight result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Font weight</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Font_weight get(int value) {
		switch (value) {
			case NORMAL_VALUE: return NORMAL;
			case BOLD_VALUE: return BOLD;
			case BOLDER_VALUE: return BOLDER;
			case LIGHTER_VALUE: return LIGHTER;
			case EM100_VALUE: return EM100;
			case EM200_VALUE: return EM200;
			case EM300_VALUE: return EM300;
			case EM400_VALUE: return EM400;
			case EM500_VALUE: return EM500;
			case EM600_VALUE: return EM600;
			case EM700_VALUE: return EM700;
			case EM800_VALUE: return EM800;
			case EM900_VALUE: return EM900;
			case INHERIT_VALUE: return INHERIT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private Font_weight(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //Font_weight
