/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.hover.HtmlString;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.IContentAssistListener;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.contentassist.IContextInformationValidator;
import org.eclipse.fx.text.ui.internal.SimpleHtmlViewer;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledString;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;

class ContextInformationPopup
implements IContentAssistListener {
    private ITextViewer fViewer;
    private PopupWindow fContextInfoPopup;
    private BorderPane fRoot;
    private Node fContent;
    private IContextInformationValidator contextInfoValidator;
    private ChangeListener<Number> selectionChange;
    private EventHandler<MouseEvent> mousePressed = me -> {
        Bounds b = this.fViewer.getTextWidget().getBoundsInLocal();
        Bounds bScreen = this.fViewer.getTextWidget().localToScreen(b);
        if (!bScreen.contains(me.getScreenX(), me.getScreenY())) {
            this.fContextInfoPopup.hide();
        }
    };
    private ChangeListener<Boolean> stageFocusChanged = (x, o, n) -> {
        if (!n.booleanValue()) {
            this.fContextInfoPopup.hide();
        }
    };

    public ContextInformationPopup(IContextInformationValidator contextInfoValidator, ITextViewer viewer) {
        this.selectionChange = this::onSelectionChange;
        this.contextInfoValidator = contextInfoValidator;
        this.fViewer = viewer;
        this.fContextInfoPopup = new PopupWindow(){};
        this.fContextInfoPopup.setAutoFix(false);
        this.fContextInfoPopup.setAutoHide(false);
        viewer.getTextWidget().sceneProperty().addListener(e -> {
            if (viewer.getTextWidget().getScene() != null) {
                this.fContextInfoPopup.getScene().getStylesheets().setAll((Collection)viewer.getTextWidget().getScene().getStylesheets());
            }
        });
        if (viewer.getTextWidget().getScene() != null) {
            this.fContextInfoPopup.getScene().getStylesheets().setAll((Collection)viewer.getTextWidget().getScene().getStylesheets());
        }
        this.fRoot = new BorderPane();
        this.fRoot.getStyleClass().add((Object)"styled-text-hover");
        this.fContextInfoPopup.getScene().setRoot((Parent)this.fRoot);
        this.fContextInfoPopup.setOnShowing(this::subscribe);
        this.fContextInfoPopup.setOnHidden(this::unsubscribe);
    }

    private void subscribe(Event e) {
        this.fViewer.getTextWidget().caretOffsetProperty().addListener(this.selectionChange);
        this.fViewer.getTextWidget().getScene().addEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressed);
        this.fViewer.getTextWidget().getScene().getWindow().focusedProperty().addListener(this.stageFocusChanged);
    }

    private void unsubscribe(Event e) {
        this.fViewer.getTextWidget().caretOffsetProperty().removeListener(this.selectionChange);
        this.fViewer.getTextWidget().getScene().removeEventFilter(MouseEvent.MOUSE_PRESSED, this.mousePressed);
        this.fViewer.getTextWidget().getScene().getWindow().focusedProperty().removeListener(this.stageFocusChanged);
    }

    private void onSelectionChange(Observable x, Number oldSelection, Number newSelection) {
        int offset = this.fViewer.getTextWidget().caretOffsetProperty().get();
        if (this.contextInfoValidator != null) {
            if (!this.contextInfoValidator.isContextInformationValid(offset)) {
                this.fContextInfoPopup.hide();
            } else {
                CharSequence infoText = this.contextInfoValidator.getInformationDisplayString(offset);
                if (infoText != null) {
                    this.updateInfoText(infoText);
                }
            }
        }
    }

    public String showContextProposals(boolean autoActivated) {
        return "TODO";
    }

    private void updateInfoText(CharSequence infoText) {
        if (infoText instanceof StyledString) {
            StackPane wrap = new StackPane();
            wrap.getStyleClass().add((Object)"context-info");
            Node content = Util.toNode((StyledString)((StyledString)infoText));
            wrap.getChildren().add((Object)content);
            this.fRoot.setCenter((Node)wrap);
            this.fContent = wrap;
        } else if (infoText instanceof HtmlString) {
            StackPane wrap = new StackPane();
            wrap.getStyleClass().add((Object)"context-info");
            wrap.setPrefHeight(this.fViewer.getTextWidget().getLineHeight(0) + 4.0);
            SimpleHtmlViewer content = new SimpleHtmlViewer(true, true);
            content.setContent((HtmlString)infoText);
            wrap.getChildren().add((Object)content);
            this.fRoot.setCenter((Node)wrap);
            this.fContent = wrap;
        } else {
            Label content = new Label();
            content.getStyleClass().add((Object)"context-info");
            content.setText(infoText.toString());
            this.fRoot.setCenter((Node)content);
            this.fContent = content;
        }
    }

    public void showContextInformation(IContextInformation info, int offset) {
        CharSequence infoText;
        CharSequence charSequence = infoText = info == null ? null : info.getInformationDisplayString();
        if (infoText != null && infoText.length() > 0) {
            if (this.contextInfoValidator != null) {
                this.contextInfoValidator.install(info, this.fViewer, offset);
            }
            this.updateInfoText(infoText);
            Point2D locationAtOffset = this.fViewer.getTextWidget().getLocationAtOffset(offset, StyledTextArea.LineLocation.ABOVE);
            locationAtOffset = this.fViewer.getTextWidget().localToScreen(locationAtOffset);
            if (locationAtOffset != null) {
                this.fContent.applyCss();
                double y = locationAtOffset.getY() - this.fContent.prefHeight(-1.0);
                this.fContextInfoPopup.show(this.fViewer.getTextWidget().getScene().getWindow(), locationAtOffset.getX(), y);
                this.fContextInfoPopup.sizeToScene();
            }
        } else {
            this.fContextInfoPopup.hide();
        }
    }

    @Override
    public boolean verifyKey(VerifyEvent event) {
        return false;
    }
}

