/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ReferencedMetamodel;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.CompositeGeneratorFragment2;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.ImplicitFragment;
import org.eclipse.xtext.xtext.generator.XtextGeneratorResourceSetInitializer;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.StandaloneSetupAccess;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

@Log
public class XtextGeneratorLanguage
extends CompositeGeneratorFragment2
implements IXtextGeneratorLanguage {
    private String grammarUri;
    private String name;
    private Boolean generateXtendStubs;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Grammar grammar;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private RuleNames ruleNames;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> fileExtensions;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> referencedResources = CollectionLiterals.newArrayList();
    @Accessors
    private ResourceSet resourceSet;
    @Accessors
    private Module guiceModule = it -> {};
    @Accessors
    private final StandaloneSetupAccess runtimeGenSetup = new StandaloneSetupAccess();
    @Accessors
    private final GuiceModuleAccess runtimeGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess ideGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess eclipsePluginGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess ideaGenModule = new GuiceModuleAccess();
    @Accessors
    private final GuiceModuleAccess webGenModule = new GuiceModuleAccess();
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    @Inject
    private IXtextProjectConfig projectConfig;
    @Inject
    private CodeConfig codeConfig;
    @Inject
    private XtextGeneratorResourceSetInitializer resourceSetInitializer;
    private static final Logger LOG = Logger.getLogger(XtextGeneratorLanguage.class);

    public void setGrammarUri(String uri) {
        this.grammarUri = uri;
    }

    public String getGrammarUri() {
        String _elvis = null;
        if (this.grammarUri != null) {
            _elvis = this.grammarUri;
        } else {
            String _string;
            String _path = this.projectConfig.getRuntime().getSrc().getPath();
            String _replace = this.name.replace(".", "/");
            String _plus = _replace + ".xtext";
            _elvis = _string = new File(_path, _plus).toURI().toString();
        }
        return _elvis;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileExtensions(String fileExtensions) {
        this.fileExtensions = IterableExtensions.toList((Iterable)((Iterable)Conversions.doWrapArray((Object)fileExtensions.trim().split("\\s*,\\s*"))));
    }

    public void addReferencedResource(String referencedResource) {
        this.referencedResources.add(referencedResource);
    }

    @Override
    public List<String> getFileExtensions() {
        if (this.fileExtensions == null || this.fileExtensions.isEmpty()) {
            this.setFileExtensions(GrammarUtil.getSimpleName((Grammar)this.grammar).toLowerCase());
            LOG.info((Object)("No explicit fileExtensions configured. Using '*." + this.fileExtensions + "'."));
        }
        return this.fileExtensions;
    }

    @Deprecated
    public void setGenerateXtendStubs(Boolean generateXtendStubs) {
        this.generateXtendStubs = generateXtendStubs;
    }

    @Override
    @Deprecated
    public boolean isGenerateXtendStubs() {
        boolean _xifexpression = false;
        _xifexpression = this.generateXtendStubs != null ? this.generateXtendStubs.booleanValue() : this.codeConfig.isPreferXtendStubs();
        return _xifexpression;
    }

    @Override
    public void initialize(Injector injector) {
        boolean _not_1;
        String _grammarUri;
        boolean _tripleEquals;
        String _plus_4;
        String _join;
        String _plus_3;
        String _plus_2;
        String _plus_1;
        String _plus;
        boolean _isEmpty_1;
        boolean _not;
        this.getFragments().addAll(0, this.getImplicitFragments());
        injector.injectMembers((Object)this);
        if (this.resourceSet == null) {
            this.resourceSet = (ResourceSet)this.resourceSetProvider.get();
        }
        this.resourceSetInitializer.initialize(this.resourceSet, this.referencedResources);
        boolean _isEmpty = this.resourceSet.getResources().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _while;
            this.installIndex();
            int i = 0;
            int size = this.resourceSet.getResources().size();
            boolean bl2 = _while = i < size;
            while (_while) {
                Resource res = (Resource)this.resourceSet.getResources().get(i);
                _isEmpty_1 = res.getContents().isEmpty();
                if (_isEmpty_1) {
                    URI _uRI = res.getURI();
                    _plus = "Error loading '" + _uRI;
                    _plus_1 = _plus + "'";
                    LOG.error((Object)_plus_1);
                } else {
                    boolean _not_12;
                    boolean _isEmpty_2 = res.getErrors().isEmpty();
                    boolean bl3 = _not_12 = !_isEmpty_2;
                    if (_not_12) {
                        URI _uRI_1 = res.getURI();
                        _plus_2 = "Error loading '" + _uRI_1;
                        _plus_3 = _plus_2 + "':\n";
                        _join = Joiner.on((String)"\n").join((Iterable)res.getErrors());
                        _plus_4 = _plus_3 + _join;
                        LOG.error((Object)_plus_4);
                    }
                }
                _while = ++i < size;
            }
            EcoreUtil.resolveAll((ResourceSet)this.resourceSet);
        }
        boolean bl4 = _tripleEquals = (_grammarUri = this.getGrammarUri()) == null;
        if (_tripleEquals) {
            throw new IllegalStateException("No grammarUri or language name given");
        }
        Resource _resource = this.resourceSet.getResource(URI.createURI((String)this.getGrammarUri()), true);
        XtextResource resource = (XtextResource)_resource;
        _isEmpty_1 = resource.getContents().isEmpty();
        if (_isEmpty_1) {
            String _grammarUri_1 = this.getGrammarUri();
            _plus = "Couldn't load grammar for '" + _grammarUri_1;
            _plus_1 = _plus + "'.";
            throw new IllegalArgumentException(_plus_1);
        }
        boolean _isEmpty_2 = resource.getErrors().isEmpty();
        boolean bl5 = _not_1 = !_isEmpty_2;
        if (_not_1) {
            LOG.error((Object)resource.getErrors());
            String _grammarUri_2 = this.getGrammarUri();
            _plus_2 = "Problem parsing '" + _grammarUri_2;
            _plus_3 = _plus_2 + "':\n";
            _join = Joiner.on((String)"\n").join((Iterable)resource.getErrors());
            _plus_4 = _plus_3 + _join;
            throw new IllegalStateException(_plus_4);
        }
        EObject _get = (EObject)resource.getContents().get(0);
        Grammar grammar = (Grammar)_get;
        this.validateGrammar(grammar);
        this.initialize(grammar);
        super.initialize(injector);
    }

    protected List<? extends IXtextGeneratorFragment> getImplicitFragments() {
        ArrayList fragments = CollectionLiterals.newArrayList();
        ImplicitFragment _implicitFragment = new ImplicitFragment();
        fragments.add(_implicitFragment);
        return fragments;
    }

    public void initialize(Grammar grammar) {
        this.grammar = grammar;
        this.ruleNames = RuleNames.getRuleNames((Grammar)grammar, (boolean)true);
    }

    private void installIndex() {
        List _emptyList = Collections.emptyList();
        ResourceDescriptionsData index = new ResourceDescriptionsData(_emptyList);
        ArrayList resources = Lists.newArrayList((Iterable)this.resourceSet.getResources());
        for (Resource resource : resources) {
            this.index(resource, resource.getURI(), index);
        }
        ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)this.resourceSet, (ResourceDescriptionsData)index);
    }

    private void index(Resource resource, URI uri, ResourceDescriptionsData index) {
        IResourceDescription resourceDescription;
        IResourceServiceProvider serviceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(uri);
        if (serviceProvider != null && (resourceDescription = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource)) != null) {
            index.addDescription(uri, resourceDescription);
        }
    }

    protected void validateGrammar(final Grammar grammar) {
        this.validateAllImports(grammar);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator((EPackage)XtextPackage.eINSTANCE);
        if (validator != null) {
            DiagnosticChain chain = new DiagnosticChain(){

                public void add(Diagnostic diagnostic) {
                    boolean _equals;
                    int _severity = diagnostic.getSeverity();
                    boolean bl = _equals = _severity == 4;
                    if (_equals) {
                        boolean _tripleEquals;
                        String _name = grammar.getName();
                        String _plus = "Validation Error in " + _name;
                        String grammarName = _plus + ": ";
                        Throwable _exception = diagnostic.getException();
                        boolean bl2 = _tripleEquals = _exception == null;
                        if (_tripleEquals) {
                            String _message = diagnostic.getMessage();
                            String _plus_1 = grammarName + _message;
                            throw new IllegalStateException(_plus_1);
                        }
                        String _message_1 = diagnostic.getMessage();
                        String _plus_2 = grammarName + _message_1;
                        Throwable _exception_1 = diagnostic.getException();
                        throw new IllegalStateException(_plus_2, _exception_1);
                    }
                }

                public void addAll(Diagnostic diagnostic) {
                    this.add(diagnostic);
                }

                public void merge(Diagnostic diagnostic) {
                    throw new UnsupportedOperationException();
                }
            };
            validator.validate((EObject)grammar, chain, null);
            TreeIterator iterator = grammar.eAllContents();
            while (iterator.hasNext()) {
                EObject _next = (EObject)iterator.next();
                HashMap _hashMap = new HashMap();
                validator.validate(_next, chain, _hashMap);
            }
        }
    }

    protected void validateAllImports(Grammar grammar) {
        List _allMetamodelDeclarations = GrammarUtil.allMetamodelDeclarations((Grammar)grammar);
        for (AbstractMetamodelDeclaration amd : _allMetamodelDeclarations) {
            if (!(amd instanceof ReferencedMetamodel)) continue;
            this.validateReferencedMetamodel((ReferencedMetamodel)amd);
        }
    }

    protected void validateReferencedMetamodel(ReferencedMetamodel ref) {
        if (ref.getEPackage() != null && !ref.getEPackage().eIsProxy()) {
            return;
        }
        EReference eref = XtextPackage.Literals.ABSTRACT_METAMODEL_DECLARATION__EPACKAGE;
        List nodes = NodeModelUtils.findNodesForFeature((EObject)ref, (EStructuralFeature)eref);
        String _xifexpression = null;
        boolean _isEmpty = nodes.isEmpty();
        _xifexpression = _isEmpty ? "(unknown)" : NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        String refName = _xifexpression;
        String grammarName = GrammarUtil.getGrammar((EObject)ref).getName();
        String msg = "The EPackage " + refName + " in grammar " + grammarName + " could not be found. " + "You might want to register that EPackage in your workflow file.";
        throw new IllegalStateException(msg);
    }

    @Override
    @Pure
    public Grammar getGrammar() {
        return this.grammar;
    }

    @Pure
    public RuleNames getRuleNames() {
        return this.ruleNames;
    }

    @Pure
    public List<String> getReferencedResources() {
        return this.referencedResources;
    }

    @Override
    @Pure
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    @Pure
    public Module getGuiceModule() {
        return this.guiceModule;
    }

    public void setGuiceModule(Module guiceModule) {
        this.guiceModule = guiceModule;
    }

    @Override
    @Pure
    public StandaloneSetupAccess getRuntimeGenSetup() {
        return this.runtimeGenSetup;
    }

    @Override
    @Pure
    public GuiceModuleAccess getRuntimeGenModule() {
        return this.runtimeGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getIdeGenModule() {
        return this.ideGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getEclipsePluginGenModule() {
        return this.eclipsePluginGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getIdeaGenModule() {
        return this.ideaGenModule;
    }

    @Override
    @Pure
    public GuiceModuleAccess getWebGenModule() {
        return this.webGenModule;
    }
}

