/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class Util {
    private IJavaProject project;
    private IType property;
    private IType readonlyProperty;

    public Util(IJavaProject project) {
        this.project = project;
    }

    public static final String toFirstUpper(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private IType getReadOnlyProperty() {
        if (this.readonlyProperty == null) {
            try {
                this.readonlyProperty = this.project.findType("javafx.beans.property.ReadOnlyProperty");
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.readonlyProperty;
    }

    public boolean isPropertyField(IType owerType, IField f) {
        try {
            IType type = Util.toType(owerType, f.getTypeSignature());
            if (type != null) {
                return Util.assignable(type, this.getReadOnlyProperty());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean assignable(IType fromType, IType toType) {
        if (fromType.equals(toType)) {
            return true;
        }
        try {
            return fromType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).contains(toType);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static IType toType(IType t, String typeSig) throws JavaModelException {
        String erasedType = Signature.getTypeErasure((String)Signature.toString((String)typeSig));
        String[][] types = t.resolveType(erasedType);
        if (types != null && types.length == 1) {
            StringBuilder b = new StringBuilder();
            String[] stringArray = types[0];
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (b.length() > 0) {
                    b.append(".");
                }
                b.append(p);
                ++n2;
            }
            return t.getJavaProject().findType(b.toString());
        }
        return null;
    }
}

