/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.compare;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.egf.model.pattern.util.PatternSwitch;
import org.eclipse.egf.pattern.ui.compare.CompareHelper;
import org.eclipse.egf.pattern.ui.compare.MethodCompareInput;
import org.eclipse.egf.pattern.ui.editors.providers.PatternElementLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternCompareInput
extends CompareEditorInput {
    private List<Object> inputs;

    public PatternCompareInput(List<Object> inputs) {
        super(new CompareConfiguration());
        this.inputs = inputs;
    }

    protected Object prepareInput(IProgressMonitor pm) {
        DiffNode diffNode = new DiffNode(null, 0);
        for (Object input : this.inputs) {
            new InputDiffNodeSwitch(diffNode).doSwitch((EObject)input);
        }
        return diffNode;
    }

    private static final class InputDiffNode
    extends DiffNode {
        private Object input;

        private InputDiffNode(Object input) {
            super(0);
            this.input = input;
        }

        public String getName() {
            return new PatternElementLabelProvider().getText(this.input);
        }

        public Image getImage() {
            return new PatternElementLabelProvider().getImage(this.input);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputDiffNodeSwitch
    extends PatternSwitch<Object> {
        private DiffNode parent;

        public InputDiffNodeSwitch(DiffNode parent) {
            this.parent = parent;
        }

        public Object casePatternViewpoint(PatternViewpoint patternViewpoint) {
            for (PatternLibrary patternLibrary : patternViewpoint.getLibraries()) {
                InputDiffNode newNode = new InputDiffNode(patternLibrary);
                this.parent.add((IDiffElement)newNode);
                new InputDiffNodeSwitch(newNode).doSwitch((EObject)patternLibrary);
            }
            return null;
        }

        public Object casePatternLibrary(PatternLibrary patternLibrary) {
            for (Pattern pattern : patternLibrary.getElements()) {
                InputDiffNode newNode = new InputDiffNode(pattern);
                this.parent.add((IDiffElement)newNode);
                new InputDiffNodeSwitch(newNode).doSwitch((EObject)pattern);
            }
            return null;
        }

        public Object casePattern(Pattern pattern) {
            for (PatternMethod patternMethod : pattern.getMethods()) {
                PatternMethod superMethod = CompareHelper.getSuperMethod(patternMethod);
                if (superMethod == null) continue;
                this.parent.add((IDiffElement)new MethodCompareInput(patternMethod, superMethod).prepareInput(null));
            }
            return null;
        }
    }
}

