/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.egf.core.ui.dialogs.TargetPlatformEcoreDialog;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionHelper;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionProperties;
import org.eclipse.egf.portfolio.genchain.tools.ui.Messages;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.GenerationChainFactory;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.Node;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.NodeContentProvider;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.NodeLabelProvider;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.NodeTypes;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreModelPage
extends WizardPage
implements ExtensionProperties,
NodeTypes {
    private Button addEcoreButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private final Node model;
    protected ContainerCheckedTreeViewer viewer;

    public EcoreModelPage(String pageName, Node model) {
        super(pageName);
        this.model = model;
    }

    public EcoreModelPage(String pageName, Node model, IStructuredSelection selection) {
        this(pageName, model);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            Object obj = objectArray[n2];
            if (obj instanceof IFile && (file = (IFile)obj).getName().endsWith(".ecore")) {
                this.addEcore(file.getFullPath().toString());
            }
            ++n2;
        }
    }

    protected Node addEcore(String modelPath) {
        return this.addEcore(modelPath, null);
    }

    protected Node addEcore(String modelPath, String project) {
        String name = GenerationChainFactory.getModelName(modelPath);
        String bundleName = GenerationChainFactory.getBundleName(modelPath);
        Node chainNode = new Node(this.model, 1);
        chainNode.setName(name);
        this.model.getChildren().add(chainNode);
        for (Map.Entry entrySet : ExtensionHelper.getExtensionsAsMap().entrySet()) {
            Node extensionNode = new Node(chainNode, 2);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("ctx.current.project.name", project);
            context.put("ctx.project.name", bundleName);
            context.put("ctx.model.path", name);
            extensionNode.getProperties().put("id", (String)entrySet.getKey());
            extensionNode.getProperties().put("model.path", modelPath);
            extensionNode.getExtendedProperties().put("property.conflict", ((ExtensionHelper)entrySet.getValue()).getConflictingExtensions());
            extensionNode.setName(((ExtensionHelper)entrySet.getValue()).getLabel());
            chainNode.getChildren().add(extensionNode);
            for (Map.Entry prop : ((ExtensionHelper)entrySet.getValue()).getDefaultProperties(context).entrySet()) {
                Node propertyNode = new Node(extensionNode, 3);
                propertyNode.setName(((EAttribute)prop.getKey()).getName());
                propertyNode.getProperties().put("property.value", (String)prop.getValue());
                propertyNode.getExtendedProperties().put("property.attribute", prop.getKey());
                extensionNode.getChildren().add(propertyNode);
            }
        }
        return chainNode;
    }

    private void createViewerControl(Composite container) {
        this.viewer = new ContainerCheckedTreeViewer(container, 67584);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn col1 = new TreeColumn(tree, 65536);
        col1.setText("");
        col1.setResizable(true);
        col1.setWidth(280);
        TreeColumn col2 = new TreeColumn(tree, 65536);
        col2.setText(Messages.genchain_wizard_valueColumn_label);
        col2.setResizable(true);
        col2.setWidth(200);
        TreeViewerColumn tcol2 = new TreeViewerColumn((TreeViewer)this.viewer, col2);
        tcol2.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){
            private final TextCellEditor textEditor;
            private final ComboBoxViewerCellEditor booleanEditor;
            {
                this.textEditor = new TextCellEditor((Composite)EcoreModelPage.this.viewer.getTree());
                this.booleanEditor = new ComboBoxViewerCellEditor((Composite)EcoreModelPage.this.viewer.getTree());
                this.booleanEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                this.booleanEditor.setContenProvider((IStructuredContentProvider)new ListContentProvider());
                this.booleanEditor.setInput(Arrays.asList("true", "false"));
                this.booleanEditor.getViewer().addDoubleClickListener(new IDoubleClickListener(){

                    public void doubleClick(DoubleClickEvent event) {
                        try {
                            booleanEditor.getViewer().getCombo().setListVisible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            protected void setValue(Object element, Object value) {
                Node node = (Node)element;
                node.getProperties().put("property.value", value.toString());
                EcoreModelPage.this.viewer.refresh((Object)node);
            }

            protected Object getValue(Object element) {
                Node node = (Node)element;
                return node.getProperties().get("property.value");
            }

            protected CellEditor getCellEditor(Object element) {
                Node node = (Node)element;
                EAttribute attr = (EAttribute)node.getExtendedProperties().get("property.attribute");
                if (attr == null) {
                    return null;
                }
                EClassifier eType = attr.getEType();
                if (EcorePackage.eINSTANCE.getEBoolean().equals(eType)) {
                    return this.booleanEditor;
                }
                if (EcorePackage.eINSTANCE.getEString().equals(eType)) {
                    return this.textEditor;
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new NodeLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new NodeContentProvider());
        this.viewer.setComparator(new ViewerComparator());
        GridData gd = new GridData(1808);
        this.viewer.getTree().setLayoutData((Object)gd);
        this.viewer.setInput((Object)this.model);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Node node = (Node)event.getElement();
                if (node.is(3)) {
                    EcoreModelPage.this.viewer.setChecked((Object)node.getParent(), event.getChecked());
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EcoreModelPage.this.refreshButtons();
            }
        });
    }

    public boolean isPageComplete() {
        if (this.viewer != null) {
            boolean complete;
            boolean bl = complete = this.viewer.getVisibleExpandedElements().length == 0 || this.viewer.getCheckedElements().length != 0;
            if (complete) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(Messages.genchain_wizard_error1);
            }
            return complete;
        }
        return super.isPageComplete();
    }

    public void createButtonControl(Composite parent) {
        parent = new Composite(parent, 0);
        GridData gd = new GridData(1040);
        parent.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setFont(parent.getFont());
        parent.setLayout((Layout)layout);
        this.addEcoreButton = new Button(parent, 8);
        this.addEcoreButton.setToolTipText(Messages.genchain_wizard_addButton_label);
        this.addEcoreButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.addEcoreButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            protected void buttonSelected() {
                TargetPlatformEcoreDialog chooseModelDialog = new TargetPlatformEcoreDialog(this.getShell());
                if (chooseModelDialog.open() == 0) {
                    String uri = chooseModelDialog.getURIText();
                    if (uri == null) {
                        return;
                    }
                    if (uri.startsWith("platform:/plugin")) {
                        uri = uri.substring("platform:/plugin".length());
                    } else if (uri.startsWith("platform:/resource")) {
                        uri = uri.substring("platform:/resource".length());
                    } else {
                        return;
                    }
                    Node newNode = this.addEcore(uri);
                    this.newNodeAdded(newNode);
                }
            }
        });
        this.deleteButton = new Button(parent, 8);
        this.deleteButton.setToolTipText(Messages.genchain_wizard_deleteButton_label);
        this.deleteButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.deleteButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            protected void buttonSelected() {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Node node;
                    Object obj = objectArray[n2];
                    if (obj instanceof Node && (node = (Node)obj).is(1)) {
                        node.getParent().getChildren().remove(node);
                    }
                    ++n2;
                }
                viewer.refresh();
            }
        });
        this.upButton = new Button(parent, 8);
        this.upButton.setToolTipText(Messages.genchain_wizard_upButton_label);
        this.upButton.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.upButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            protected void buttonSelected() {
                Node node;
                Node parent2;
                int index;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection.size() == 1 && (index = (parent2 = (node = (Node)selection.getFirstElement()).getParent()).getChildren().indexOf(node)) > 0) {
                    parent2.getChildren().remove(node);
                    parent2.getChildren().add(index - 1, node);
                }
                viewer.refresh();
            }
        });
        this.downButton = new Button(parent, 8);
        this.downButton.setToolTipText(Messages.genchain_wizard_downButton_label);
        this.downButton.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.downButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            protected void buttonSelected() {
                Node node;
                Node parent2;
                int index;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection.size() == 1 && (index = (parent2 = (node = (Node)selection.getFirstElement()).getParent()).getChildren().indexOf(node)) < parent2.getChildren().size() - 1) {
                    parent2.getChildren().remove(node);
                    parent2.getChildren().add(index + 1, node);
                }
                viewer.refresh();
            }
        });
    }

    protected void newNodeAdded(Node newNode) {
        this.viewer.refresh();
        this.viewer.expandToLevel((Object)newNode, 1);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(1, false);
        layout.numColumns = 2;
        container.setFont(parent.getFont());
        container.setLayout((Layout)layout);
        this.createViewerControl(container);
        this.createButtonControl(container);
        this.refreshButtons();
        this.setControl((Control)container);
        container.pack();
        this.viewer.expandToLevel(2);
        this.viewer.setCheckedElements(this.computeCheckedElements());
    }

    protected Object[] computeCheckedElements() {
        HashSet toDeselect = new HashSet();
        for (ExtensionHelper ext : ExtensionHelper.getExtensions()) {
            toDeselect.addAll(ext.getConflictingExtensions());
        }
        ArrayList<Node> selected = new ArrayList<Node>();
        for (Node ecoreNode : this.model.getChildren()) {
            for (Node extNode : ecoreNode.getChildren()) {
                String id = extNode.getProperties().get("id");
                if (id != null && toDeselect.contains(id)) continue;
                selected.add(extNode);
            }
        }
        return selected.toArray();
    }

    protected void refreshButtons() {
        this.deleteButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            Node node = (Node)selection.getFirstElement();
            Node parent2 = node.getParent();
            int index = parent2.getChildren().indexOf(node);
            if (node.is(1)) {
                this.upButton.setEnabled(index > 0);
                this.downButton.setEnabled(index < parent2.getChildren().size() - 1);
            }
        }
        boolean enableDelete = false;
        if (!selection.isEmpty()) {
            enableDelete = true;
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Node node;
                Object obj = objectArray[n2];
                if (obj instanceof Node && !(node = (Node)obj).is(1)) {
                    enableDelete = false;
                    break;
                }
                ++n2;
            }
        }
        this.deleteButton.setEnabled(enableDelete);
        this.getContainer().updateButtons();
    }

    public Set<Node> getCheckedElements() {
        HashSet<Node> checkedElements = new HashSet<Node>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            checkedElements.add((Node)obj);
            ++n2;
        }
        return checkedElements;
    }

    private static class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                viewer.refresh();
            }
        }
    }

    private abstract class MySelectionListener
    implements SelectionListener {
        private MySelectionListener() {
        }

        protected abstract void buttonSelected();

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected();
            EcoreModelPage.this.refreshButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

