/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.ui.EGFCommonUIPlugin;
import org.eclipse.egf.common.ui.l10n.EGFCommonUIMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ResourceTransfer;

public abstract class CopyQualifiedNameAction
extends Action
implements IObjectActionDelegate {
    protected IWorkbenchPart _part;

    public CopyQualifiedNameAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public abstract void selectionChanged(IAction var1, ISelection var2);

    protected EObject getSelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selectedObject != null) {
            Object adaptedObj;
            Object adaptedObj2;
            if (selectedObject instanceof EObject) {
                return (EObject)selectedObject;
            }
            if (selectedObject instanceof IAdaptable && (adaptedObj2 = ((IAdaptable)selectedObject).getAdapter(EObject.class)) != null && adaptedObj2 instanceof EObject) {
                return (EObject)adaptedObj2;
            }
            IAdapterManager adapterManager = Platform.getAdapterManager();
            if (adapterManager.hasAdapter(selectedObject, EObject.class.getName()) && (adaptedObj = adapterManager.loadAdapter(selectedObject, EObject.class.getName())) instanceof EObject) {
                return (EObject)adaptedObj;
            }
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._part = targetPart;
    }

    protected abstract URI getURI();

    public void run(IAction action) {
        URI uri = this.getURI();
        if (uri == null || this._part == null) {
            return;
        }
        try {
            Object[] data = null;
            Transfer[] dataTypes = null;
            IResource resource = null;
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            }
            if (resource != null) {
                IPath location = resource.getLocation();
                if (location != null) {
                    data = new Object[]{uri.toString(), resource, new String[]{location.toOSString()}};
                    dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
                } else {
                    data = new Object[]{uri.toString(), resource};
                    dataTypes = new Transfer[]{TextTransfer.getInstance(), ResourceTransfer.getInstance()};
                }
            } else {
                data = new Object[]{uri.toString()};
                dataTypes = new Transfer[]{TextTransfer.getInstance()};
            }
            Clipboard clipboard = new Clipboard(this._part.getSite().getShell().getDisplay());
            try {
                try {
                    clipboard.setContents(data, dataTypes);
                }
                catch (SWTError e) {
                    if (e.code != 2002) {
                        throw e;
                    }
                    if (MessageDialog.openQuestion((Shell)this._part.getSite().getShell(), (String)EGFCommonUIMessages.CopyQualifiedNameAction_ErrorTitle, (String)EGFCommonUIMessages.CopyQualifiedNameAction_ErrorDescription)) {
                        clipboard.setContents(data, dataTypes);
                    }
                    clipboard.dispose();
                }
            }
            finally {
                clipboard.dispose();
            }
        }
        catch (Throwable t) {
            EGFCommonUIPlugin.getDefault().logError("CopyQualifiedNameAction.run(..) _", t);
        }
    }
}

