/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.buildfile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompressionMethod implements Enumerator
{
    NONE(0, "none", "none"),
    GZIP(1, "gzip", "gzip"),
    BZIP2(2, "bzip2", "bzip2");

    public static final String copyright = "   Copyright (c) 2009-2010 Thales Corporate Services S.A.S.\r\n   This program and the accompanying materials\r\n   are made available under the terms of the Eclipse Public License v2.0\r\n   which accompanies this distribution, and is available at\r\n   https://www.eclipse.org/legal/epl-v2.0\r\n  \r\n  SPDX-License-Identifier: EPL-2.0\r\n  \r\n   Contributors:\r\n       Thales Corporate Services S.A.S - initial API and implementation";
    public static final int NONE_VALUE = 0;
    public static final int GZIP_VALUE = 1;
    public static final int BZIP2_VALUE = 2;
    private static final CompressionMethod[] VALUES_ARRAY;
    public static final List<CompressionMethod> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompressionMethod[]{NONE, GZIP, BZIP2};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompressionMethod get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompressionMethod result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompressionMethod getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompressionMethod result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompressionMethod get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return GZIP;
            }
            case 2: {
                return BZIP2;
            }
        }
        return null;
    }

    private CompressionMethod(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

