/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstorebridge;

import java.util.HashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPWorkspace;
import org.eclipse.emf.ecp.common.model.workSpaceModel.impl.ECPWorkspaceImpl;
import org.eclipse.emf.ecp.emfstorebridge.EMFStoreECPProject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ModelPackage;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.common.observer.ObserverBus;

public class EMFECPWorkspace
extends ECPWorkspaceImpl
implements ECPWorkspace {
    private HashMap<ProjectSpace, EMFStoreECPProject> mapping = new HashMap();
    private AdapterImpl workspaceListenerAdapter;
    private Object activeProjectSpace;

    public EMFECPWorkspace() {
        EList projectSpaces = WorkspaceManager.getInstance().getCurrentWorkspace().getProjectSpaces();
        for (ProjectSpace projectSpace : projectSpaces) {
            EMFStoreECPProject emfStoreECPProject = new EMFStoreECPProject(projectSpace);
            this.getProjects().add((Object)emfStoreECPProject);
            this.mapping.put(projectSpace, emfStoreECPProject);
        }
        this.workspaceListenerAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeatureID(Workspace.class) == 0) {
                    if (msg.getEventType() == 3 && ModelPackage.eINSTANCE.getProjectSpace().isInstance(msg.getNewValue())) {
                        ProjectSpace projectSpace = (ProjectSpace)msg.getNewValue();
                        EMFStoreECPProject emfStoreECPProject = new EMFStoreECPProject(projectSpace);
                        EMFECPWorkspace.this.getProjects().add((Object)emfStoreECPProject);
                        EMFECPWorkspace.this.mapping.put(projectSpace, emfStoreECPProject);
                    } else if (msg.getEventType() == 4 && ModelPackage.eINSTANCE.getProjectSpace().isInstance(msg.getOldValue())) {
                        ProjectSpace projectSpace = (ProjectSpace)msg.getOldValue();
                        ECPProject project = EMFECPWorkspace.this.getProject((EObject)projectSpace);
                        project.dispose();
                        project.setWorkspace(null);
                        EMFECPWorkspace.this.mapping.remove(projectSpace);
                    }
                }
                super.notifyChanged(msg);
            }
        };
        WorkspaceManager.getInstance().getCurrentWorkspace().eAdapters().add((Object)this.workspaceListenerAdapter);
    }

    public EditingDomain getEditingDomain() {
        return Configuration.getEditingDomain();
    }

    public ECPProject getProject(EObject me) {
        if (me instanceof EObject) {
            try {
                ProjectSpace projectSpace = WorkspaceManager.getProjectSpace((EObject)me);
                return this.mapping.get(projectSpace);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        if (me instanceof ProjectSpace) {
            return this.mapping.get(me);
        }
        return null;
    }

    public ECPProject getActiveProject() {
        return this.mapping.get(this.activeProjectSpace);
    }

    public ObserverBus getObserverBus() {
        return WorkspaceManager.getObserverBus();
    }

    public void setActiveModelelement(EObject modelelement) {
        ProjectSpace projectSpace;
        if (modelelement == null) {
            return;
        }
        if (modelelement instanceof ProjectSpace) {
            projectSpace = (ProjectSpace)modelelement;
        } else if (modelelement instanceof EObject) {
            try {
                projectSpace = WorkspaceManager.getProjectSpace((EObject)modelelement);
            }
            catch (IllegalArgumentException exception) {
                return;
            }
        } else {
            projectSpace = null;
        }
        if (projectSpace == null) {
            return;
        }
        if (this.activeProjectSpace != null && this.activeProjectSpace.equals(projectSpace)) {
            return;
        }
        this.activeProjectSpace = projectSpace;
    }
}

