/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui;

import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.components.ContextComponent;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.components.DescriptionComponent;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.components.DetailsComponent;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.components.OptionComponent;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DecisionBox
extends Composite {
    private final Conflict conflict;
    private final DecisionManager decisionManager;
    private OptionComponent optionComponent;

    public DecisionBox(Composite parent, DecisionManager decisionManager, Color color, Conflict conflict) {
        super(parent, 2048);
        this.decisionManager = decisionManager;
        this.conflict = conflict;
        this.init(color);
    }

    private void init(Color color) {
        GridLayout decisionLayout = new GridLayout(2, true);
        this.setLayout((Layout)decisionLayout);
        this.setLayoutData(new GridData(4, 4, true, false));
        if (color != null) {
            this.setBackground(color);
        }
        new ContextComponent(this, this.conflict);
        this.optionComponent = new OptionComponent(this, this.conflict);
        new DescriptionComponent(this, this.conflict);
        if (DecisionUtil.detailsNeeded(this.conflict)) {
            new DetailsComponent(this, this.conflict);
        }
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setBackground(this.getBackground());
            ++n2;
        }
    }

    public DecisionManager getDecisionManager() {
        return this.decisionManager;
    }

    public void setSolution(ConflictOption option) {
        this.conflict.setSolution(option);
        this.optionComponent.refreshButtonColor();
    }

    public void layoutPage(int heightSizeChange) {
        ScrolledComposite scrollArea = (ScrolledComposite)this.getParent().getParent();
        scrollArea.setMinSize(scrollArea.getMinWidth(), scrollArea.getMinHeight() + heightSizeChange);
        scrollArea.layout();
    }

    public Conflict getConflict() {
        return this.conflict;
    }
}

