/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.importexport.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.emfstore.internal.client.importexport.IExportImportController;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

public class ImportChangesController
implements IExportImportController {
    private final ProjectSpaceBase projectSpace;

    public ImportChangesController(ProjectSpaceBase projectSpace) {
        this.projectSpace = projectSpace;
    }

    public String getLabel() {
        return "changes";
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore change package (" + ExportImportDataUnits.Change.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Change.getExtension(), "*.*"};
    }

    public String getParentFolderPropertyKey() {
        return null;
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)file.getAbsolutePath()), true);
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !(directContents.get(0) instanceof ChangePackage)) {
            throw new IOException("File is corrupt, does not contain changes.");
        }
        ChangePackage changePackage = (ChangePackage)directContents.get(0);
        this.projectSpace.applyOperations((Iterable<AbstractOperation>)changePackage.getOperations(), true);
    }

    public String getFilename() {
        return null;
    }

    public boolean isExport() {
        return false;
    }
}

