/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Record;

public class PageDataOverflow
extends Record {
    static final int START_LAST = 7;
    static final int START_MORE = 9;
    private final PageScanIndex index;
    private int type;
    private int parentPage;
    private int nextPage;
    private int size;
    private Data data;

    PageDataOverflow(PageDataLeaf pageDataLeaf, int n, int n2, int n3, int n4, Data data, int n5, int n6) {
        this.index = pageDataLeaf.index;
        this.setPos(n);
        this.type = n2;
        this.parentPage = n3;
        this.nextPage = n4;
        this.size = n6;
        this.data = this.index.getPageStore().createData();
        this.data.writeInt(this.parentPage);
        this.data.writeByte((byte)n2);
        if (n2 == 3) {
            this.data.writeInt(this.nextPage);
        } else {
            this.data.writeShortInt(n6);
        }
        this.data.write(data.getBytes(), n5, n6);
    }

    PageDataOverflow(PageDataLeaf pageDataLeaf, int n, Data data, int n2) {
        this.index = pageDataLeaf.index;
        this.setPos(n);
        this.data = data;
    }

    void read() throws SQLException {
        this.parentPage = this.data.readInt();
        this.type = this.data.readByte();
        if (this.type == 19) {
            this.size = this.data.readShortInt();
            this.nextPage = 0;
        } else if (this.type == 3) {
            this.size = this.index.getPageStore().getPageSize() - 9;
            this.nextPage = this.data.readInt();
        } else {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " type:" + this.type);
        }
    }

    int readInto(Data data) {
        data.checkCapacity(this.size);
        if (this.type == 19) {
            data.write(this.data.getBytes(), 7, this.size);
            return 0;
        }
        data.write(this.data.getBytes(), 9, this.size);
        return this.nextPage;
    }

    int getNextOverflow() {
        return this.nextPage;
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf overflow parent:" + this.parentPage + " next:" + this.nextPage;
    }

    public int getMemorySize() {
        return this.index.getPageStore().getPageSize() >> 1;
    }

    void setParent(int n) {
        this.parentPage = n;
    }
}

