/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooldef;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AppearanceStyle implements Enumerator
{
    FONT_LITERAL(0, "Font", "Font"),
    FILL_LITERAL(1, "Fill", "Fill"),
    LINE_LITERAL(2, "Line", "Line");

    public static final int FONT = 0;
    public static final int FILL = 1;
    public static final int LINE = 2;
    private static final AppearanceStyle[] VALUES_ARRAY;
    public static final List<AppearanceStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AppearanceStyle[]{FONT_LITERAL, FILL_LITERAL, LINE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AppearanceStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AppearanceStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AppearanceStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AppearanceStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AppearanceStyle get(int value) {
        switch (value) {
            case 0: {
                return FONT_LITERAL;
            }
            case 1: {
                return FILL_LITERAL;
            }
            case 2: {
                return LINE_LITERAL;
            }
        }
        return null;
    }

    private AppearanceStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

