/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.properties.figure;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FontStyle;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.FontHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesImages;
import org.eclipse.gmf.runtime.diagram.ui.properties.internal.l10n.DiagramUIPropertiesMessages;
import org.eclipse.gmf.tooling.simplemap.diagram.properties.AbstractExtendedPropertiesSection;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleCompartment;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLabelNode;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleLinkMapping;
import org.eclipse.gmf.tooling.simplemap.simplemappings.SimpleNode;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public abstract class ElementWithLabelPropertySection
extends AbstractExtendedPropertiesSection {
    protected static final String FONTS_AND_COLORS_LABEL = DiagramUIPropertiesMessages.FontAndColor_nameLabel;
    protected CCombo fontFamilyCombo;
    private CCombo fontSizeCombo;
    private Button fontBoldButton;
    private Button fontItalicButton;
    protected Group fontsGroup;
    private DataBindingContext bindingContext = new DataBindingContext();

    @Override
    protected void initializeControls(Composite parent) {
        super.initializeControls(parent);
        this.createFontsAndColorsGroups(this.composite);
    }

    protected Group createFontsAndColorsGroups(Composite parent) {
        this.fontsGroup = this.getWidgetFactory().createGroup(parent, FONTS_AND_COLORS_LABEL);
        GridLayout layout = new GridLayout(1, false);
        this.fontsGroup.setLayout((Layout)layout);
        this.createFontsGroup((Composite)this.fontsGroup);
        return this.fontsGroup;
    }

    protected Composite createFontsGroup(Composite parent) {
        Composite familySize = this.getWidgetFactory().createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        familySize.setLayout((Layout)layout);
        this.fontFamilyCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontFamilyCombo.setItems(FontHelper.getFontNames());
        this.fontSizeCombo = this.getWidgetFactory().createCCombo(familySize, 2060);
        this.fontSizeCombo.setItems(FontHelper.getFontSizes());
        Composite toolBar = new Composite(parent, 32);
        toolBar.setLayout((Layout)new GridLayout(7, false));
        toolBar.setBackground(parent.getBackground());
        this.fontBoldButton = new Button(toolBar, 2);
        this.fontBoldButton.setImage(DiagramUIPropertiesImages.get((String)"icons/bold.gif"));
        this.fontBoldButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_FontStyle_Bold;
            }
        });
        this.fontItalicButton = new Button(toolBar, 2);
        this.fontItalicButton.setImage(DiagramUIPropertiesImages.get((String)"icons/italic.gif"));
        this.fontItalicButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DiagramUIMessages.PropertyDescriptorFactory_FontStyle_Italic;
            }
        });
        return toolBar;
    }

    protected Figure getLabelFigure(Object transformSelection) {
        DiagramLabel diagramLabel;
        Figure figure = null;
        if (transformSelection instanceof SimpleNode && (diagramLabel = ((SimpleNode)transformSelection).getDiagramLabel()) != null && diagramLabel.getAccessor() != null) {
            figure = diagramLabel.getAccessor().getFigure();
        }
        if (transformSelection instanceof SimpleLabelNode) {
            figure = ((SimpleNode)transformSelection).getDiagramLabel().getFigure().getActualFigure();
        }
        if (transformSelection instanceof SimpleCompartment) {
            figure = ((SimpleCompartment)transformSelection).getCompartment().getFigure().getActualFigure();
        }
        if (transformSelection instanceof SimpleLinkMapping) {
            figure = ((SimpleLinkMapping)transformSelection).getDiagramLabel().getFigure().getActualFigure();
        }
        return figure;
    }

    public void dispose() {
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        if (this.fontFamilyCombo != null) {
            this.fontFamilyCombo.dispose();
        }
        if (this.fontSizeCombo != null) {
            this.fontSizeCombo.dispose();
        }
        if (this.fontBoldButton != null) {
            this.fontBoldButton.dispose();
        }
        if (this.fontItalicButton != null) {
            this.fontItalicButton.dispose();
        }
        super.dispose();
    }

    protected void setEObject(EObject object) {
        this.eObject = object;
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.fontFamilyCombo), EMFProperties.value((EStructuralFeature)GMFGraphPackage.eINSTANCE.getBasicFont_FaceName()).observe((Object)this.eObject));
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.fontSizeCombo), EMFProperties.value((EStructuralFeature)GMFGraphPackage.eINSTANCE.getBasicFont_Height()).observe((Object)this.eObject), (UpdateValueStrategy)new UpdateSizeTargetToModel(), (UpdateValueStrategy)new UpdateSizeModelToTarget());
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.fontBoldButton), EMFProperties.value((EStructuralFeature)GMFGraphPackage.eINSTANCE.getBasicFont_Style()).observe((Object)this.eObject), (UpdateValueStrategy)new UpdateBoldButtonTargetToModel(), (UpdateValueStrategy)new UpdateBoldButtonModelToTarget());
    }

    class UpdateBoldButtonModelToTarget
    extends UpdateValueStrategy {
        UpdateBoldButtonModelToTarget() {
        }

        public Object convert(Object value) {
            if (value == FontStyle.BOLD_LITERAL) {
                return true;
            }
            return false;
        }
    }

    class UpdateBoldButtonTargetToModel
    extends UpdateValueStrategy {
        UpdateBoldButtonTargetToModel() {
        }

        public Object convert(Object value) {
            boolean isBold = (Boolean)value;
            FontStyle style = isBold ? FontStyle.BOLD_LITERAL : FontStyle.NORMAL_LITERAL;
            return style;
        }
    }

    class UpdateSizeModelToTarget
    extends UpdateValueStrategy {
        UpdateSizeModelToTarget() {
        }

        public Object convert(Object value) {
            return Integer.toString((Integer)value);
        }
    }

    class UpdateSizeTargetToModel
    extends UpdateValueStrategy {
        UpdateSizeTargetToModel() {
        }

        public Object convert(Object value) {
            return Integer.parseInt((String)value);
        }
    }
}

