/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.equivalence;

import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.automata.OutgoingEdgeIterator;
import org.eclipse.escet.cif.eventbased.equivalence.Block;
import org.eclipse.escet.cif.eventbased.equivalence.BlockLocation;
import org.eclipse.escet.cif.eventbased.equivalence.BlockPartitioner;
import org.eclipse.escet.cif.eventbased.equivalence.CounterExample;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class LangEquivCalculation
extends BlockPartitioner {
    public LangEquivCalculation(List<Automaton> automs) {
        super(automs, true);
        Assert.check((automs.size() == 2 ? 1 : 0) != 0);
    }

    public CounterExample checkLanguageEquivalence() {
        return this.performBlockPartitioning();
    }

    @Override
    protected CounterExample constructCounterExample(Block block, Event finalEvent) {
        List<Event> path = this.getReversePath(block);
        Collections.reverse(path);
        Assert.areEqual((Object)2, (Object)this.automs.size());
        Location[] locs = new Location[]{((Automaton)this.automs.get((int)0)).initial, ((Automaton)this.automs.get((int)1)).initial};
        Location[] newLocs = new Location[2];
        int pathIdx = 0;
        while (pathIdx < path.size()) {
            Event evt = path.get(pathIdx);
            newLocs[0] = this.getNextLocation(locs[0], evt);
            newLocs[1] = this.getNextLocation(locs[1], evt);
            if (newLocs[0] == null || newLocs[1] == null) {
                Assert.check((newLocs[0] != null || newLocs[1] != null ? 1 : 0) != 0);
                return new CounterExample(path.subList(0, pathIdx), locs, evt);
            }
            locs[0] = newLocs[0];
            locs[1] = newLocs[1];
            newLocs[0] = null;
            newLocs[1] = null;
            ++pathIdx;
        }
        if (finalEvent == null) {
            return new CounterExample(path, locs, null);
        }
        return this.constructCounterExample(path, locs[0], locs[1]);
    }

    @Override
    protected CounterExample constructCounterExample(Location[] initLocs) {
        Assert.areEqual((Object)2, (Object)initLocs.length);
        Location initLoc1 = initLocs[0];
        Location initLoc2 = initLocs[1];
        return this.constructCounterExample(List.of(), initLoc1, initLoc2);
    }

    private CounterExample constructCounterExample(List<Event> prefix, Location loc1, Location loc2) {
        List<Event> splitExplanationPath = this.getSplitExplanationPath(loc1, loc2);
        List path = Lists.listc((int)(prefix.size() + splitExplanationPath.size() - 1));
        path.addAll(prefix);
        int pathIdx = 0;
        while (pathIdx < splitExplanationPath.size() - 1) {
            Event evt = splitExplanationPath.get(pathIdx);
            path.add(evt);
            loc1 = this.getNextLocation(loc1, evt);
            loc2 = this.getNextLocation(loc2, evt);
            Assert.notNull((Object)loc1);
            Assert.notNull((Object)loc2);
            ++pathIdx;
        }
        Event lastExplanationEvent = (Event)Lists.last(splitExplanationPath);
        if (lastExplanationEvent == null) {
            return new CounterExample(path, new Location[]{loc1, loc2}, null);
        }
        int numAutsEnabled = (this.getNextLocation(loc1, lastExplanationEvent) == null ? 0 : 1) + (this.getNextLocation(loc2, lastExplanationEvent) == null ? 0 : 1);
        if (numAutsEnabled != 1) {
            Assert.fail();
        }
        return new CounterExample(path, new Location[]{loc1, loc2}, lastExplanationEvent);
    }

    private List<Event> getReversePath(Block blk) {
        List reversePath = Lists.list();
        BlockLocation best = null;
        for (BlockLocation bl : blk.locs) {
            if (best != null && bl.depth >= best.depth) continue;
            best = bl;
        }
        while (best.depth != 0) {
            BlockLocation bestPrev = null;
            Edge bestIncEdge = null;
            for (Edge incEdge : best.loc.getIncoming()) {
                BlockLocation prev = (BlockLocation)this.blockLocs.get(incEdge.srcLoc);
                if (bestPrev != null && prev.depth >= bestPrev.depth) continue;
                bestPrev = prev;
                bestIncEdge = incEdge;
            }
            reversePath.add(bestIncEdge.event);
            best = bestPrev;
        }
        return reversePath;
    }

    private Location getNextLocation(Location loc, Event evt) {
        OutgoingEdgeIterator iter = loc.getOutgoing(evt);
        if (!iter.hasNext()) {
            return null;
        }
        return ((Edge)iter.next()).dstLoc;
    }

    private List<Event> getSplitExplanationPath(Location loc1, Location loc2) {
        List splitPath = Lists.list();
        Location curLoc1 = loc1;
        Location curLoc2 = loc2;
        while (true) {
            Block block2;
            Block block1;
            Assert.check(((block1 = (Block)this.blocks.get(((BlockLocation)this.blockLocs.get((Object)curLoc1)).blockNumber)) != (block2 = (Block)this.blocks.get(((BlockLocation)this.blockLocs.get((Object)curLoc2)).blockNumber)) ? 1 : 0) != 0);
            while (block1.parent != block2.parent) {
                int maxDepth = Math.max(block1.depth, block2.depth);
                if (block1.depth == maxDepth) {
                    block1 = block1.parent;
                }
                if (block2.depth != maxDepth) continue;
                block2 = block2.parent;
            }
            Assert.check((block1 != block2 ? 1 : 0) != 0);
            Assert.areEqual((Object)block1.splitEvent, (Object)block2.splitEvent);
            splitPath.add(block1.splitEvent);
            if (block1.splitEvent == null) break;
            Location nextLoc1 = this.getNextLocation(curLoc1, block1.splitEvent);
            Location nextLoc2 = this.getNextLocation(curLoc2, block2.splitEvent);
            Assert.check((nextLoc1 != null || nextLoc2 != null ? 1 : 0) != 0);
            if (nextLoc1 == null || nextLoc2 == null) break;
            curLoc1 = nextLoc1;
            curLoc2 = nextLoc2;
        }
        return splitPath;
    }
}

