/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EnumerationTypeGen {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private RoomHelpers _roomHelpers;

    public void doGenerate(Root root) {
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Consumer<EnumerationType> consumer = et -> {
            String path = this._roomExtensions.getPath((RoomClass)et);
            String file = this._javaExtensions.getJavaFileName((RoomClass)et);
            this.fileIO.generateFile("generating Enumeration implementation", path + file, this.generate(root, (EnumerationType)et));
        };
        IterableExtensions.filter((Iterable)root.getEnumClasses(), (Functions.Function1)function1).forEach(consumer);
    }

    public CharSequence generate(Root root, EnumerationType et) {
        StringConcatenation stringConcatenation = null;
        String type = this._javaExtensions.getTargetType(et);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("package ");
        String string = this._roomExtensions.getPackage((RoomClass)et);
        stringConcatenation2.append(string);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("public interface ");
        String string2 = et.getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        EList eList = et.getLiterals();
        for (EnumLiteral lit : eList) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("static final ");
            stringConcatenation2.append(type, "\t");
            stringConcatenation2.append(" ");
            String string3 = lit.getName();
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(" = ");
            long l = lit.getLiteralValue();
            stringConcatenation2.append((Object)l, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

