/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.ApplicationJspConfigDescriptor;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DefaultInstanceManager;
import org.apache.catalina.core.NamingContextListener;
import org.apache.catalina.core.StandardContextValve;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ApplicationListener;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.Injectable;
import org.apache.catalina.deploy.InjectionTarget;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.MessageDestination;
import org.apache.catalina.deploy.MessageDestinationRef;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.deploy.ResourceBase;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.CharsetMapper;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.URLEncoder;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.ContextBindings;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.WARDirContext;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.scan.StandardJarScanner;

public class StandardContext
extends ContainerBase
implements Context,
NotificationEmitter {
    private static final Log log = LogFactory.getLog(StandardContext.class);
    private static final String info = "org.apache.catalina.core.StandardContext/1.0";
    protected static URLEncoder urlEncoder = new URLEncoder();
    protected boolean allowCasualMultipartParsing = false;
    private boolean swallowAbortedUploads = true;
    private String altDDName = null;
    private InstanceManager instanceManager = null;
    private String hostName;
    private boolean antiJARLocking = false;
    private boolean antiResourceLocking = false;
    private ApplicationListener[] applicationListeners = new ApplicationListener[0];
    private final Object applicationListenersLock = new Object();
    private Object[] applicationEventListenersObjects = new Object[0];
    private Object[] applicationLifecycleListenersObjects = new Object[0];
    private Map<ServletContainerInitializer, Set<Class<?>>> initializers = new LinkedHashMap();
    private ApplicationParameter[] applicationParameters = new ApplicationParameter[0];
    private final Object applicationParametersLock = new Object();
    private NotificationBroadcasterSupport broadcaster = null;
    private CharsetMapper charsetMapper = null;
    private String charsetMapperClass = "org.apache.catalina.util.CharsetMapper";
    private URL configFile = null;
    private boolean configured = false;
    private volatile SecurityConstraint[] constraints = new SecurityConstraint[0];
    private final Object constraintsLock = new Object();
    protected ApplicationContext context = null;
    private String compilerClasspath = null;
    private boolean cookies = true;
    private boolean crossContext = false;
    private String encodedPath = null;
    private String path = null;
    private boolean delegate = false;
    private String displayName = null;
    private String defaultContextXml;
    private String defaultWebXml;
    private boolean distributable = false;
    private String docBase = null;
    private HashMap<String, ErrorPage> exceptionPages = new HashMap();
    private HashMap<String, ApplicationFilterConfig> filterConfigs = new HashMap();
    private HashMap<String, FilterDef> filterDefs = new HashMap();
    private final ContextFilterMaps filterMaps = new ContextFilterMaps();
    private boolean ignoreAnnotations = false;
    private String[] instanceListeners = new String[0];
    private final Object instanceListenersLock = new Object();
    private LoginConfig loginConfig = null;
    private Mapper mapper = new Mapper();
    private NamingContextListener namingContextListener = null;
    private NamingResources namingResources = null;
    private HashMap<String, MessageDestination> messageDestinations = new HashMap();
    private HashMap<String, String> mimeMappings = new HashMap();
    private ErrorPage okErrorPage = null;
    private HashMap<String, String> parameters = new HashMap();
    private volatile boolean paused = false;
    private String publicId = null;
    private boolean reloadable = false;
    private boolean unpackWAR = true;
    private boolean copyXML = false;
    private boolean override = false;
    private String originalDocBase = null;
    private boolean privileged = false;
    private boolean replaceWelcomeFiles = false;
    private HashMap<String, String> roleMappings = new HashMap();
    private String[] securityRoles = new String[0];
    private final Object securityRolesLock = new Object();
    private HashMap<String, String> servletMappings = new HashMap();
    private final Object servletMappingsLock = new Object();
    private int sessionTimeout = 30;
    private AtomicLong sequenceNumber = new AtomicLong(0L);
    private HashMap<Integer, ErrorPage> statusPages = new HashMap();
    private boolean swallowOutput = false;
    private long unloadDelay = 2000L;
    private String[] watchedResources = new String[0];
    private final Object watchedResourcesLock = new Object();
    private String[] welcomeFiles = new String[0];
    private final Object welcomeFilesLock = new Object();
    private String[] wrapperLifecycles = new String[0];
    private final Object wrapperLifecyclesLock = new Object();
    private String[] wrapperListeners = new String[0];
    private final Object wrapperListenersLock = new Object();
    private String workDir = null;
    private String wrapperClassName = StandardWrapper.class.getName();
    private Class<?> wrapperClass = null;
    private boolean useNaming = true;
    private boolean filesystemBased = false;
    private String namingContextName = null;
    private boolean cachingAllowed = true;
    protected boolean allowLinking = false;
    protected int cacheMaxSize = 10240;
    private boolean xmlBlockExternal = true;
    protected int cacheObjectMaxSize = 512;
    protected int cacheTTL = 5000;
    private String aliases = null;
    private DirContext webappResources = null;
    private long startupTime;
    private long startTime;
    private long tldScanTime;
    private String j2EEApplication = "none";
    private String j2EEServer = "none";
    private boolean webXmlValidation = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean webXmlNamespaceAware = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean processTlds = true;
    private boolean tldValidation = Globals.STRICT_SERVLET_COMPLIANCE;
    private boolean saveConfig = true;
    private String sessionCookieName;
    private boolean useHttpOnly = true;
    private String sessionCookieDomain;
    private String sessionCookiePath;
    private boolean sessionCookiePathUsesTrailingSlash = true;
    private JarScanner jarScanner = null;
    private boolean clearReferencesStatic = false;
    private boolean clearReferencesStopThreads = false;
    private boolean clearReferencesStopTimerThreads = false;
    private boolean clearReferencesHttpClientKeepAliveThread = true;
    private boolean renewThreadsWhenStoppingContext = true;
    private boolean logEffectiveWebXml = false;
    private int effectiveMajorVersion = 3;
    private int effectiveMinorVersion = 0;
    private JspConfigDescriptor jspConfigDescriptor = new ApplicationJspConfigDescriptor();
    private Set<String> resourceOnlyServlets = new HashSet<String>();
    private String webappVersion = "";
    private boolean addWebinfClassesResources = false;
    private boolean fireRequestListenersOnForwards = false;
    private Set<Servlet> createdServlets = new HashSet<Servlet>();
    private boolean preemptiveAuthentication = false;
    private boolean sendRedirectBody = false;
    private boolean jndiExceptionOnFailedWrite = true;
    private Map<String, String> postConstructMethods = new HashMap<String, String>();
    private Map<String, String> preDestroyMethods = new HashMap<String, String>();
    private String containerSciFilter;
    private Boolean failCtxIfServletStartFails;
    private MBeanNotificationInfo[] notificationInfo;
    private String server = null;
    private String[] javaVMs = null;

    public StandardContext() {
        this.pipeline.setBasic(new StandardContextValve());
        this.broadcaster = new NotificationBroadcasterSupport();
        if (!Globals.STRICT_SERVLET_COMPLIANCE) {
            this.resourceOnlyServlets.add("jsp");
        }
    }

    @Override
    public void setContainerSciFilter(String containerSciFilter) {
        this.containerSciFilter = containerSciFilter;
    }

    @Override
    public String getContainerSciFilter() {
        return this.containerSciFilter;
    }

    @Override
    public boolean getSendRedirectBody() {
        return this.sendRedirectBody;
    }

    @Override
    public void setSendRedirectBody(boolean sendRedirectBody) {
        this.sendRedirectBody = sendRedirectBody;
    }

    @Override
    public boolean getPreemptiveAuthentication() {
        return this.preemptiveAuthentication;
    }

    @Override
    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    @Override
    public void setFireRequestListenersOnForwards(boolean enable) {
        this.fireRequestListenersOnForwards = enable;
    }

    @Override
    public boolean getFireRequestListenersOnForwards() {
        return this.fireRequestListenersOnForwards;
    }

    public void setAddWebinfClassesResources(boolean addWebinfClassesResources) {
        this.addWebinfClassesResources = addWebinfClassesResources;
    }

    public boolean getAddWebinfClassesResources() {
        return this.addWebinfClassesResources;
    }

    @Override
    public void setWebappVersion(String webappVersion) {
        this.webappVersion = null == webappVersion ? "" : webappVersion;
    }

    @Override
    public String getWebappVersion() {
        return this.webappVersion;
    }

    @Override
    public String getBaseName() {
        return new ContextName(this.path, this.webappVersion).getBaseName();
    }

    @Override
    public String getResourceOnlyServlets() {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String servletName : this.resourceOnlyServlets) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(servletName);
        }
        return result.toString();
    }

    @Override
    public void setResourceOnlyServlets(String resourceOnlyServlets) {
        this.resourceOnlyServlets.clear();
        if (resourceOnlyServlets == null) {
            return;
        }
        for (String servletName : resourceOnlyServlets.split(",")) {
            if ((servletName = servletName.trim()).length() <= 0) continue;
            this.resourceOnlyServlets.add(servletName);
        }
    }

    @Override
    public boolean isResourceOnlyServlet(String servletName) {
        return this.resourceOnlyServlets.contains(servletName);
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.effectiveMajorVersion;
    }

    @Override
    public void setEffectiveMajorVersion(int effectiveMajorVersion) {
        this.effectiveMajorVersion = effectiveMajorVersion;
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.effectiveMinorVersion;
    }

    @Override
    public void setEffectiveMinorVersion(int effectiveMinorVersion) {
        this.effectiveMinorVersion = effectiveMinorVersion;
    }

    @Override
    public void setLogEffectiveWebXml(boolean logEffectiveWebXml) {
        this.logEffectiveWebXml = logEffectiveWebXml;
    }

    @Override
    public boolean getLogEffectiveWebXml() {
        return this.logEffectiveWebXml;
    }

    @Override
    public Authenticator getAuthenticator() {
        if (this instanceof Authenticator) {
            return (Authenticator)((Object)this);
        }
        Pipeline pipeline = this.getPipeline();
        if (pipeline != null) {
            Valve basic = pipeline.getBasic();
            if (basic != null && basic instanceof Authenticator) {
                return (Authenticator)((Object)basic);
            }
            Valve[] valves = pipeline.getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof Authenticator)) continue;
                return (Authenticator)((Object)valves[i]);
            }
        }
        return null;
    }

    @Override
    public JarScanner getJarScanner() {
        if (this.jarScanner == null) {
            this.jarScanner = new StandardJarScanner();
        }
        return this.jarScanner;
    }

    @Override
    public void setJarScanner(JarScanner jarScanner) {
        this.jarScanner = jarScanner;
    }

    @Override
    public InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    @Override
    public void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    @Override
    public String getEncodedPath() {
        return this.encodedPath;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void setAllowCasualMultipartParsing(boolean allowCasualMultipartParsing) {
        this.allowCasualMultipartParsing = allowCasualMultipartParsing;
    }

    @Override
    public boolean getAllowCasualMultipartParsing() {
        return this.allowCasualMultipartParsing;
    }

    @Override
    public void setSwallowAbortedUploads(boolean swallowAbortedUploads) {
        this.swallowAbortedUploads = swallowAbortedUploads;
    }

    @Override
    public boolean getSwallowAbortedUploads() {
        return this.swallowAbortedUploads;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public int getCacheObjectMaxSize() {
        return this.cacheObjectMaxSize;
    }

    public void setCacheObjectMaxSize(int cacheObjectMaxSize) {
        this.cacheObjectMaxSize = cacheObjectMaxSize;
    }

    public String getAliases() {
        return this.aliases;
    }

    @Override
    public void addResourceJarUrl(URL url) {
        if (this.webappResources instanceof BaseDirContext) {
            ((BaseDirContext)this.webappResources).addResourcesJar(url);
        } else {
            log.error((Object)sm.getString("standardContext.noResourceJar", new Object[]{url, this.getName()}));
        }
    }

    public void addResourcesDirContext(DirContext altDirContext) {
        if (this.webappResources instanceof BaseDirContext) {
            ((BaseDirContext)this.webappResources).addAltDirContext(altDirContext);
        } else {
            log.error((Object)sm.getString("standardContext.noResourceJar", new Object[]{altDirContext, this.getName()}));
        }
    }

    public void setAliases(String aliases) {
        this.aliases = aliases;
    }

    @Override
    public void addServletContainerInitializer(ServletContainerInitializer sci, Set<Class<?>> classes) {
        this.initializers.put(sci, classes);
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", oldDelegate, this.delegate);
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    @Deprecated
    public boolean isFilesystemBased() {
        return this.filesystemBased;
    }

    @Override
    public Object[] getApplicationEventListeners() {
        return this.applicationEventListenersObjects;
    }

    @Override
    public void setApplicationEventListeners(Object[] listeners) {
        this.applicationEventListenersObjects = listeners;
    }

    public void addApplicationEventListener(Object listener) {
        int len = this.applicationEventListenersObjects.length;
        Object[] newListeners = Arrays.copyOf(this.applicationEventListenersObjects, len + 1);
        newListeners[len] = listener;
        this.applicationEventListenersObjects = newListeners;
    }

    @Override
    public Object[] getApplicationLifecycleListeners() {
        return this.applicationLifecycleListenersObjects;
    }

    @Override
    public void setApplicationLifecycleListeners(Object[] listeners) {
        this.applicationLifecycleListenersObjects = listeners;
    }

    public void addApplicationLifecycleListener(Object listener) {
        int len = this.applicationLifecycleListenersObjects.length;
        Object[] newListeners = Arrays.copyOf(this.applicationLifecycleListenersObjects, len + 1);
        newListeners[len] = listener;
        this.applicationLifecycleListenersObjects = newListeners;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public boolean getAntiResourceLocking() {
        return this.antiResourceLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        boolean oldAntiJARLocking = this.antiJARLocking;
        this.antiJARLocking = antiJARLocking;
        this.support.firePropertyChange("antiJARLocking", oldAntiJARLocking, this.antiJARLocking);
    }

    public void setAntiResourceLocking(boolean antiResourceLocking) {
        boolean oldAntiResourceLocking = this.antiResourceLocking;
        this.antiResourceLocking = antiResourceLocking;
        this.support.firePropertyChange("antiResourceLocking", oldAntiResourceLocking, this.antiResourceLocking);
    }

    @Override
    public boolean getAvailable() {
        return this.getState().isAvailable();
    }

    @Override
    public CharsetMapper getCharsetMapper() {
        if (this.charsetMapper == null) {
            try {
                Class<?> clazz = Class.forName(this.charsetMapperClass);
                this.charsetMapper = (CharsetMapper)clazz.newInstance();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.charsetMapper = new CharsetMapper();
            }
        }
        return this.charsetMapper;
    }

    @Override
    public void setCharsetMapper(CharsetMapper mapper) {
        CharsetMapper oldCharsetMapper = this.charsetMapper;
        this.charsetMapper = mapper;
        if (mapper != null) {
            this.charsetMapperClass = mapper.getClass().getName();
        }
        this.support.firePropertyChange("charsetMapper", oldCharsetMapper, this.charsetMapper);
    }

    @Override
    public String getCharset(Locale locale) {
        return this.getCharsetMapper().getCharset(locale);
    }

    @Override
    public URL getConfigFile() {
        return this.configFile;
    }

    @Override
    public void setConfigFile(URL configFile) {
        this.configFile = configFile;
    }

    @Override
    public boolean getConfigured() {
        return this.configured;
    }

    @Override
    public void setConfigured(boolean configured) {
        boolean oldConfigured = this.configured;
        this.configured = configured;
        this.support.firePropertyChange("configured", oldConfigured, this.configured);
    }

    @Override
    public boolean getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(boolean cookies) {
        boolean oldCookies = this.cookies;
        this.cookies = cookies;
        this.support.firePropertyChange("cookies", oldCookies, this.cookies);
    }

    @Override
    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    @Override
    public void setSessionCookieName(String sessionCookieName) {
        String oldSessionCookieName = this.sessionCookieName;
        this.sessionCookieName = sessionCookieName;
        this.support.firePropertyChange("sessionCookieName", oldSessionCookieName, sessionCookieName);
    }

    @Override
    public boolean getUseHttpOnly() {
        return this.useHttpOnly;
    }

    @Override
    public void setUseHttpOnly(boolean useHttpOnly) {
        boolean oldUseHttpOnly = this.useHttpOnly;
        this.useHttpOnly = useHttpOnly;
        this.support.firePropertyChange("useHttpOnly", oldUseHttpOnly, this.useHttpOnly);
    }

    @Override
    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    @Override
    public void setSessionCookieDomain(String sessionCookieDomain) {
        String oldSessionCookieDomain = this.sessionCookieDomain;
        this.sessionCookieDomain = sessionCookieDomain;
        this.support.firePropertyChange("sessionCookieDomain", oldSessionCookieDomain, sessionCookieDomain);
    }

    @Override
    public String getSessionCookiePath() {
        return this.sessionCookiePath;
    }

    @Override
    public void setSessionCookiePath(String sessionCookiePath) {
        String oldSessionCookiePath = this.sessionCookiePath;
        this.sessionCookiePath = sessionCookiePath;
        this.support.firePropertyChange("sessionCookiePath", oldSessionCookiePath, sessionCookiePath);
    }

    @Override
    public boolean getSessionCookiePathUsesTrailingSlash() {
        return this.sessionCookiePathUsesTrailingSlash;
    }

    @Override
    public void setSessionCookiePathUsesTrailingSlash(boolean sessionCookiePathUsesTrailingSlash) {
        this.sessionCookiePathUsesTrailingSlash = sessionCookiePathUsesTrailingSlash;
    }

    @Override
    public boolean getCrossContext() {
        return this.crossContext;
    }

    @Override
    public void setCrossContext(boolean crossContext) {
        boolean oldCrossContext = this.crossContext;
        this.crossContext = crossContext;
        this.support.firePropertyChange("crossContext", oldCrossContext, this.crossContext);
    }

    public String getDefaultContextXml() {
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String defaultContextXml) {
        this.defaultContextXml = defaultContextXml;
    }

    public String getDefaultWebXml() {
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String defaultWebXml) {
        this.defaultWebXml = defaultWebXml;
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getTldScanTime() {
        return this.tldScanTime;
    }

    public void setTldScanTime(long tldScanTime) {
        this.tldScanTime = tldScanTime;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getAltDDName() {
        return this.altDDName;
    }

    @Override
    public void setAltDDName(String altDDName) {
        this.altDDName = altDDName;
        if (this.context != null) {
            this.context.setAttribute("org.apache.catalina.deploy.alt_dd", altDDName);
        }
    }

    @Deprecated
    public String getCompilerClasspath() {
        return this.compilerClasspath;
    }

    @Deprecated
    public void setCompilerClasspath(String compilerClasspath) {
        this.compilerClasspath = compilerClasspath;
    }

    @Override
    public void setDisplayName(String displayName) {
        String oldDisplayName = this.displayName;
        this.displayName = displayName;
        this.support.firePropertyChange("displayName", oldDisplayName, this.displayName);
    }

    @Override
    public boolean getDistributable() {
        return this.distributable;
    }

    @Override
    public void setDistributable(boolean distributable) {
        boolean oldDistributable = this.distributable;
        this.distributable = distributable;
        this.support.firePropertyChange("distributable", oldDistributable, this.distributable);
        if (this.getManager() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Propagating distributable=" + distributable + " to manager"));
            }
            this.getManager().setDistributable(distributable);
        }
    }

    @Override
    public String getDocBase() {
        return this.docBase;
    }

    @Override
    public void setDocBase(String docBase) {
        this.docBase = docBase;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getJ2EEApplication() {
        return this.j2EEApplication;
    }

    public void setJ2EEApplication(String j2EEApplication) {
        this.j2EEApplication = j2EEApplication;
    }

    public String getJ2EEServer() {
        return this.j2EEServer;
    }

    public void setJ2EEServer(String j2EEServer) {
        this.j2EEServer = j2EEServer;
    }

    @Override
    public synchronized void setLoader(Loader loader) {
        super.setLoader(loader);
    }

    @Override
    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    @Override
    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        boolean oldIgnoreAnnotations = this.ignoreAnnotations;
        this.ignoreAnnotations = ignoreAnnotations;
        this.support.firePropertyChange("ignoreAnnotations", oldIgnoreAnnotations, this.ignoreAnnotations);
    }

    @Override
    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    @Override
    public void setLoginConfig(LoginConfig config) {
        String errorPage;
        if (config == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.required"));
        }
        String loginPage = config.getLoginPage();
        if (loginPage != null && !loginPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.loginWarning", new Object[]{loginPage}));
                }
                config.setLoginPage("/" + loginPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.loginPage", new Object[]{loginPage}));
            }
        }
        if ((errorPage = config.getErrorPage()) != null && !errorPage.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.loginConfig.errorWarning", new Object[]{errorPage}));
                }
                config.setErrorPage("/" + errorPage);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.loginConfig.errorPage", new Object[]{errorPage}));
            }
        }
        LoginConfig oldLoginConfig = this.loginConfig;
        this.loginConfig = config;
        this.support.firePropertyChange("loginConfig", oldLoginConfig, this.loginConfig);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public NamingResources getNamingResources() {
        if (this.namingResources == null) {
            this.setNamingResources(new NamingResources());
        }
        return this.namingResources;
    }

    @Override
    public void setNamingResources(NamingResources namingResources) {
        NamingResources oldNamingResources = this.namingResources;
        this.namingResources = namingResources;
        if (namingResources != null) {
            namingResources.setContainer(this);
        }
        this.support.firePropertyChange("namingResources", oldNamingResources, this.namingResources);
        if (this.getState() == LifecycleState.NEW || this.getState() == LifecycleState.INITIALIZING || this.getState() == LifecycleState.INITIALIZED) {
            return;
        }
        if (oldNamingResources != null) {
            try {
                oldNamingResources.stop();
                oldNamingResources.destroy();
            }
            catch (LifecycleException e) {
                log.warn((Object)"standardContext.namingResource.destroy.fail", (Throwable)e);
            }
        }
        if (namingResources != null) {
            try {
                namingResources.init();
                namingResources.start();
            }
            catch (LifecycleException e) {
                log.warn((Object)"standardContext.namingResource.init.fail", (Throwable)e);
            }
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        if (path == null || !path.equals("") && !path.startsWith("/")) {
            this.path = "/" + path;
            log.warn((Object)sm.getString("standardContext.pathInvalid", new Object[]{path, this.path}));
        } else {
            this.path = path;
        }
        this.encodedPath = urlEncoder.encode(this.path);
        if (this.getName() == null) {
            this.setName(this.path);
        }
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting deployment descriptor public ID to '" + publicId + "'"));
        }
        String oldPublicId = this.publicId;
        this.publicId = publicId;
        this.support.firePropertyChange("publicId", oldPublicId, publicId);
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public boolean getOverride() {
        return this.override;
    }

    public String getOriginalDocBase() {
        return this.originalDocBase;
    }

    public void setOriginalDocBase(String docBase) {
        this.originalDocBase = docBase;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.getPrivileged()) {
            return this.getClass().getClassLoader();
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public boolean getPrivileged() {
        return this.privileged;
    }

    @Override
    public void setPrivileged(boolean privileged) {
        boolean oldPrivileged = this.privileged;
        this.privileged = privileged;
        this.support.firePropertyChange("privileged", oldPrivileged, this.privileged);
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", oldReloadable, this.reloadable);
    }

    @Override
    public void setOverride(boolean override) {
        boolean oldOverride = this.override;
        this.override = override;
        this.support.firePropertyChange("override", oldOverride, this.override);
    }

    @Deprecated
    public boolean isReplaceWelcomeFiles() {
        return this.replaceWelcomeFiles;
    }

    public void setReplaceWelcomeFiles(boolean replaceWelcomeFiles) {
        boolean oldReplaceWelcomeFiles = this.replaceWelcomeFiles;
        this.replaceWelcomeFiles = replaceWelcomeFiles;
        this.support.firePropertyChange("replaceWelcomeFiles", oldReplaceWelcomeFiles, this.replaceWelcomeFiles);
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ApplicationContext(this);
            if (this.altDDName != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", this.altDDName);
            }
        }
        return this.context.getFacade();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int timeout) {
        int oldSessionTimeout = this.sessionTimeout;
        this.sessionTimeout = timeout == 0 ? -1 : timeout;
        this.support.firePropertyChange("sessionTimeout", oldSessionTimeout, this.sessionTimeout);
    }

    @Override
    public boolean getSwallowOutput() {
        return this.swallowOutput;
    }

    @Override
    public void setSwallowOutput(boolean swallowOutput) {
        boolean oldSwallowOutput = this.swallowOutput;
        this.swallowOutput = swallowOutput;
        this.support.firePropertyChange("swallowOutput", oldSwallowOutput, this.swallowOutput);
    }

    public long getUnloadDelay() {
        return this.unloadDelay;
    }

    public void setUnloadDelay(long unloadDelay) {
        long oldUnloadDelay = this.unloadDelay;
        this.unloadDelay = unloadDelay;
        this.support.firePropertyChange("unloadDelay", oldUnloadDelay, this.unloadDelay);
    }

    public boolean getUnpackWAR() {
        return this.unpackWAR;
    }

    public void setUnpackWAR(boolean unpackWAR) {
        this.unpackWAR = unpackWAR;
    }

    public boolean getCopyXML() {
        return this.copyXML;
    }

    public void setCopyXML(boolean copyXML) {
        this.copyXML = copyXML;
    }

    @Override
    public String getWrapperClass() {
        return this.wrapperClassName;
    }

    @Override
    public void setWrapperClass(String wrapperClassName) {
        this.wrapperClassName = wrapperClassName;
        try {
            this.wrapperClass = Class.forName(wrapperClassName);
            if (!StandardWrapper.class.isAssignableFrom(this.wrapperClass)) {
                throw new IllegalArgumentException(sm.getString("standardContext.invalidWrapperClass", new Object[]{wrapperClassName}));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException(cnfe.getMessage());
        }
    }

    @Override
    public synchronized void setResources(DirContext resources) {
        if (this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardContext.resources.started"));
        }
        DirContext oldResources = this.webappResources;
        if (oldResources == resources) {
            return;
        }
        if (resources instanceof BaseDirContext) {
            ((BaseDirContext)resources).setCached(this.isCachingAllowed());
            ((BaseDirContext)resources).setCacheTTL(this.getCacheTTL());
            ((BaseDirContext)resources).setCacheMaxSize(this.getCacheMaxSize());
            ((BaseDirContext)resources).setCacheObjectMaxSize(this.getCacheObjectMaxSize());
            ((BaseDirContext)resources).setAliases(this.getAliases());
        }
        if (resources instanceof FileDirContext) {
            this.filesystemBased = true;
            ((FileDirContext)resources).setAllowLinking(this.isAllowLinking());
        }
        this.webappResources = resources;
        this.resources = null;
        this.support.firePropertyChange("resources", oldResources, this.webappResources);
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.jspConfigDescriptor;
    }

    public boolean getJndiExceptionOnFailedWrite() {
        return this.jndiExceptionOnFailedWrite;
    }

    public void setJndiExceptionOnFailedWrite(boolean jndiExceptionOnFailedWrite) {
        this.jndiExceptionOnFailedWrite = jndiExceptionOnFailedWrite;
    }

    public String getCharsetMapperClass() {
        return this.charsetMapperClass;
    }

    public void setCharsetMapperClass(String mapper) {
        String oldCharsetMapperClass = this.charsetMapperClass;
        this.charsetMapperClass = mapper;
        this.support.firePropertyChange("charsetMapperClass", oldCharsetMapperClass, this.charsetMapperClass);
    }

    public String getWorkPath() {
        if (this.getWorkDir() == null) {
            return null;
        }
        File workDir = new File(this.getWorkDir());
        if (!workDir.isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                workDir = new File(catalinaHomePath, this.getWorkDir());
            }
            catch (IOException e) {
                log.warn((Object)sm.getString("standardContext.workPath", new Object[]{this.getName()}), (Throwable)e);
            }
        }
        return workDir.getAbsolutePath();
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
        if (this.getState().isAvailable()) {
            this.postWorkDirectory();
        }
    }

    @Deprecated
    public boolean isSaveConfig() {
        return this.saveConfig;
    }

    @Deprecated
    public void setSaveConfig(boolean saveConfig) {
        this.saveConfig = saveConfig;
    }

    public boolean getClearReferencesStatic() {
        return this.clearReferencesStatic;
    }

    public void setClearReferencesStatic(boolean clearReferencesStatic) {
        boolean oldClearReferencesStatic = this.clearReferencesStatic;
        this.clearReferencesStatic = clearReferencesStatic;
        this.support.firePropertyChange("clearReferencesStatic", oldClearReferencesStatic, this.clearReferencesStatic);
    }

    public boolean getClearReferencesStopThreads() {
        return this.clearReferencesStopThreads;
    }

    public void setClearReferencesStopThreads(boolean clearReferencesStopThreads) {
        boolean oldClearReferencesStopThreads = this.clearReferencesStopThreads;
        this.clearReferencesStopThreads = clearReferencesStopThreads;
        this.support.firePropertyChange("clearReferencesStopThreads", oldClearReferencesStopThreads, this.clearReferencesStopThreads);
    }

    public boolean getClearReferencesStopTimerThreads() {
        return this.clearReferencesStopTimerThreads;
    }

    public void setClearReferencesStopTimerThreads(boolean clearReferencesStopTimerThreads) {
        boolean oldClearReferencesStopTimerThreads = this.clearReferencesStopTimerThreads;
        this.clearReferencesStopTimerThreads = clearReferencesStopTimerThreads;
        this.support.firePropertyChange("clearReferencesStopTimerThreads", oldClearReferencesStopTimerThreads, this.clearReferencesStopTimerThreads);
    }

    public boolean getClearReferencesHttpClientKeepAliveThread() {
        return this.clearReferencesHttpClientKeepAliveThread;
    }

    public void setClearReferencesHttpClientKeepAliveThread(boolean clearReferencesHttpClientKeepAliveThread) {
        this.clearReferencesHttpClientKeepAliveThread = clearReferencesHttpClientKeepAliveThread;
    }

    public boolean getRenewThreadsWhenStoppingContext() {
        return this.renewThreadsWhenStoppingContext;
    }

    public void setRenewThreadsWhenStoppingContext(boolean renewThreadsWhenStoppingContext) {
        boolean oldRenewThreadsWhenStoppingContext = this.renewThreadsWhenStoppingContext;
        this.renewThreadsWhenStoppingContext = renewThreadsWhenStoppingContext;
        this.support.firePropertyChange("renewThreadsWhenStoppingContext", oldRenewThreadsWhenStoppingContext, this.renewThreadsWhenStoppingContext);
    }

    public Boolean getFailCtxIfServletStartFails() {
        return this.failCtxIfServletStartFails;
    }

    public void setFailCtxIfServletStartFails(Boolean failCtxIfServletStartFails) {
        Boolean oldFailCtxIfServletStartFails = this.failCtxIfServletStartFails;
        this.failCtxIfServletStartFails = failCtxIfServletStartFails;
        this.support.firePropertyChange("failCtxIfServletStartFails", oldFailCtxIfServletStartFails, failCtxIfServletStartFails);
    }

    protected boolean getComputedFailCtxIfServletStartFails() {
        if (this.failCtxIfServletStartFails != null) {
            return this.failCtxIfServletStartFails;
        }
        if (this.getParent() instanceof StandardHost) {
            return ((StandardHost)this.getParent()).isFailCtxIfServletStartFails();
        }
        return false;
    }

    @Override
    public void addApplicationListener(String listener) {
        this.addApplicationListener(new ApplicationListener(listener, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationListener(ApplicationListener listener) {
        Object object = this.applicationListenersLock;
        synchronized (object) {
            ApplicationListener[] results = new ApplicationListener[this.applicationListeners.length + 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (listener.equals(this.applicationListeners[i])) {
                    log.info((Object)sm.getString("standardContext.duplicateListener", new Object[]{listener.getClassName()}));
                    return;
                }
                results[i] = this.applicationListeners[i];
            }
            results[this.applicationListeners.length] = listener;
            this.applicationListeners = results;
        }
        this.fireContainerEvent("addApplicationListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApplicationParameter(ApplicationParameter parameter) {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            String newName = parameter.getName();
            for (ApplicationParameter p : this.applicationParameters) {
                if (!newName.equals(p.getName()) || p.getOverride()) continue;
                return;
            }
            ApplicationParameter[] results = Arrays.copyOf(this.applicationParameters, this.applicationParameters.length + 1);
            results[this.applicationParameters.length] = parameter;
            this.applicationParameters = results;
        }
        this.fireContainerEvent("addApplicationParameter", parameter);
    }

    @Override
    public void addChild(Container child) {
        Wrapper oldJspServlet = null;
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        boolean isJspServlet = "jsp".equals(child.getName());
        if (isJspServlet && (oldJspServlet = (Wrapper)this.findChild("jsp")) != null) {
            this.removeChild(oldJspServlet);
        }
        super.addChild(child);
        if (isJspServlet && oldJspServlet != null) {
            String[] jspMappings = oldJspServlet.findMappings();
            for (int i = 0; jspMappings != null && i < jspMappings.length; ++i) {
                this.addServletMapping(jspMappings[i], child.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConstraint(SecurityConstraint constraint) {
        SecurityCollection[] collections = constraint.findCollections();
        for (int i = 0; i < collections.length; ++i) {
            String[] patterns = collections[i].findPatterns();
            for (int j = 0; j < patterns.length; ++j) {
                patterns[j] = this.adjustURLPattern(patterns[j]);
                if (this.validateURLPattern(patterns[j])) continue;
                throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.pattern", new Object[]{patterns[j]}));
            }
            if (collections[i].findMethods().length <= 0 || collections[i].findOmittedMethods().length <= 0) continue;
            throw new IllegalArgumentException(sm.getString("standardContext.securityConstraint.mixHttpMethod"));
        }
        Object object = this.constraintsLock;
        synchronized (object) {
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length + 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                results[i] = this.constraints[i];
            }
            results[this.constraints.length] = constraint;
            this.constraints = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorPage(ErrorPage errorPage) {
        String exceptionType;
        if (errorPage == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.errorPage.required"));
        }
        String location = errorPage.getLocation();
        if (location != null && !location.startsWith("/")) {
            if (this.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.errorPage.warning", new Object[]{location}));
                }
                errorPage.setLocation("/" + location);
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.errorPage.error", new Object[]{location}));
            }
        }
        if ((exceptionType = errorPage.getExceptionType()) != null) {
            HashMap<String, ErrorPage> hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.put(exceptionType, errorPage);
            }
        }
        HashMap<Integer, ErrorPage> hashMap = this.statusPages;
        synchronized (hashMap) {
            if (errorPage.getErrorCode() == 200) {
                this.okErrorPage = errorPage;
            }
            this.statusPages.put(errorPage.getErrorCode(), errorPage);
        }
        this.fireContainerEvent("addErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilterDef(FilterDef filterDef) {
        HashMap<String, FilterDef> hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.put(filterDef.getFilterName(), filterDef);
        }
        this.fireContainerEvent("addFilterDef", filterDef);
    }

    @Override
    public void addFilterMap(FilterMap filterMap) {
        this.validateFilterMap(filterMap);
        this.filterMaps.add(filterMap);
        this.fireContainerEvent("addFilterMap", filterMap);
    }

    @Override
    public void addFilterMapBefore(FilterMap filterMap) {
        this.validateFilterMap(filterMap);
        this.filterMaps.addBefore(filterMap);
        this.fireContainerEvent("addFilterMap", filterMap);
    }

    private void validateFilterMap(FilterMap filterMap) {
        String filterName = filterMap.getFilterName();
        String[] servletNames = filterMap.getServletNames();
        String[] urlPatterns = filterMap.getURLPatterns();
        if (this.findFilterDef(filterName) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.name", new Object[]{filterName}));
        }
        if (!filterMap.getMatchAllServletNames() && !filterMap.getMatchAllUrlPatterns() && servletNames.length == 0 && urlPatterns.length == 0) {
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.either"));
        }
        for (int i = 0; i < urlPatterns.length; ++i) {
            if (this.validateURLPattern(urlPatterns[i])) continue;
            throw new IllegalArgumentException(sm.getString("standardContext.filterMap.pattern", new Object[]{urlPatterns[i]}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInstanceListener(String listener) {
        Object object = this.instanceListenersLock;
        synchronized (object) {
            String[] results = new String[this.instanceListeners.length + 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                results[i] = this.instanceListeners[i];
            }
            results[this.instanceListeners.length] = listener;
            this.instanceListeners = results;
        }
        this.fireContainerEvent("addInstanceListener", listener);
    }

    @Override
    public void addLocaleEncodingMappingParameter(String locale, String encoding) {
        this.getCharsetMapper().addCharsetMappingFromDeploymentDescriptor(locale, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageDestination(MessageDestination md) {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.put(md.getName(), md);
        }
        this.fireContainerEvent("addMessageDestination", md.getName());
    }

    public void addMessageDestinationRef(MessageDestinationRef mdr) {
        this.namingResources.addMessageDestinationRef(mdr);
        this.fireContainerEvent("addMessageDestinationRef", mdr.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMimeMapping(String extension, String mimeType) {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.put(extension, mimeType);
        }
        this.fireContainerEvent("addMimeMapping", extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.required"));
        }
        if (this.parameters.get(name) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.parameter.duplicate", new Object[]{name}));
        }
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        this.fireContainerEvent("addParameter", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoleMapping(String role, String link) {
        HashMap<String, String> hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.put(role, link);
        }
        this.fireContainerEvent("addRoleMapping", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSecurityRole(String role) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            String[] results = new String[this.securityRoles.length + 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                results[i] = this.securityRoles[i];
            }
            results[this.securityRoles.length] = role;
            this.securityRoles = results;
        }
        this.fireContainerEvent("addSecurityRole", role);
    }

    @Override
    public void addServletMapping(String pattern, String name) {
        this.addServletMapping(pattern, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServletMapping(String pattern, String name, boolean jspWildCard) {
        if (this.findChild(name) == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.name", new Object[]{name}));
        }
        String decodedPattern = this.adjustURLPattern(RequestUtil.URLDecode(pattern));
        if (!this.validateURLPattern(decodedPattern)) {
            throw new IllegalArgumentException(sm.getString("standardContext.servletMap.pattern", new Object[]{decodedPattern}));
        }
        Object object = this.servletMappingsLock;
        synchronized (object) {
            String name2 = this.servletMappings.get(decodedPattern);
            if (name2 != null) {
                Wrapper wrapper = (Wrapper)this.findChild(name2);
                wrapper.removeMapping(decodedPattern);
                this.mapper.removeWrapper(decodedPattern);
            }
            this.servletMappings.put(decodedPattern, name);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        wrapper.addMapping(decodedPattern);
        this.mapper.addWrapper(decodedPattern, (Object)wrapper, jspWildCard, this.resourceOnlyServlets.contains(name));
        this.fireContainerEvent("addServletMapping", decodedPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWatchedResource(String name) {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            String[] results = new String[this.watchedResources.length + 1];
            for (int i = 0; i < this.watchedResources.length; ++i) {
                results[i] = this.watchedResources[i];
            }
            results[this.watchedResources.length] = name;
            this.watchedResources = results;
        }
        this.fireContainerEvent("addWatchedResource", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWelcomeFile(String name) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            if (this.replaceWelcomeFiles) {
                this.fireContainerEvent("clearWelcomeFiles", null);
                this.welcomeFiles = new String[0];
                this.setReplaceWelcomeFiles(false);
            }
            String[] results = new String[this.welcomeFiles.length + 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                results[i] = this.welcomeFiles[i];
            }
            results[this.welcomeFiles.length] = name;
            this.welcomeFiles = results;
        }
        if (this.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("addWelcomeFile", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperLifecycle(String listener) {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            String[] results = new String[this.wrapperLifecycles.length + 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                results[i] = this.wrapperLifecycles[i];
            }
            results[this.wrapperLifecycles.length] = listener;
            this.wrapperLifecycles = results;
        }
        this.fireContainerEvent("addWrapperLifecycle", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperListener(String listener) {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            String[] results = new String[this.wrapperListeners.length + 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                results[i] = this.wrapperListeners[i];
            }
            results[this.wrapperListeners.length] = listener;
            this.wrapperListeners = results;
        }
        this.fireContainerEvent("addWrapperListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Wrapper createWrapper() {
        Object listener;
        Class<?> clazz;
        int i;
        Wrapper wrapper = null;
        if (this.wrapperClass != null) {
            try {
                wrapper = (Wrapper)this.wrapperClass.newInstance();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                log.error((Object)"createWrapper", t);
                return null;
            }
        } else {
            wrapper = new StandardWrapper();
        }
        Object object = this.instanceListenersLock;
        synchronized (object) {
            for (i = 0; i < this.instanceListeners.length; ++i) {
                try {
                    clazz = Class.forName(this.instanceListeners[i]);
                    listener = (InstanceListener)clazz.newInstance();
                    wrapper.addInstanceListener((InstanceListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperLifecyclesLock;
        synchronized (object) {
            for (i = 0; i < this.wrapperLifecycles.length; ++i) {
                try {
                    clazz = Class.forName(this.wrapperLifecycles[i]);
                    listener = (LifecycleListener)clazz.newInstance();
                    wrapper.addLifecycleListener((LifecycleListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        object = this.wrapperListenersLock;
        synchronized (object) {
            for (i = 0; i < this.wrapperListeners.length; ++i) {
                try {
                    clazz = Class.forName(this.wrapperListeners[i]);
                    listener = (ContainerListener)clazz.newInstance();
                    wrapper.addContainerListener((ContainerListener)listener);
                    continue;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    log.error((Object)"createWrapper", t);
                    return null;
                }
            }
        }
        return wrapper;
    }

    @Override
    public String[] findApplicationListeners() {
        ArrayList<String> list = new ArrayList<String>(this.applicationListeners.length);
        for (ApplicationListener applicationListener : this.applicationListeners) {
            list.add(applicationListener.getClassName());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationParameter[] findApplicationParameters() {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            return this.applicationParameters;
        }
    }

    @Override
    public SecurityConstraint[] findConstraints() {
        return this.constraints;
    }

    @Override
    public ErrorPage findErrorPage(int errorCode) {
        if (errorCode == 200) {
            return this.okErrorPage;
        }
        return this.statusPages.get(errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage findErrorPage(String exceptionType) {
        HashMap<String, ErrorPage> hashMap = this.exceptionPages;
        synchronized (hashMap) {
            return this.exceptionPages.get(exceptionType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorPage[] findErrorPages() {
        HashMap<String, ErrorPage> hashMap = this.exceptionPages;
        synchronized (hashMap) {
            HashMap<Integer, ErrorPage> hashMap2 = this.statusPages;
            synchronized (hashMap2) {
                int i;
                ErrorPage[] results1 = new ErrorPage[this.exceptionPages.size()];
                results1 = this.exceptionPages.values().toArray(results1);
                ErrorPage[] results2 = new ErrorPage[this.statusPages.size()];
                results2 = this.statusPages.values().toArray(results2);
                ErrorPage[] results = new ErrorPage[results1.length + results2.length];
                for (i = 0; i < results1.length; ++i) {
                    results[i] = results1[i];
                }
                for (i = results1.length; i < results.length; ++i) {
                    results[i] = results2[i - results1.length];
                }
                return results;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef findFilterDef(String filterName) {
        HashMap<String, FilterDef> hashMap = this.filterDefs;
        synchronized (hashMap) {
            return this.filterDefs.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterDef[] findFilterDefs() {
        HashMap<String, FilterDef> hashMap = this.filterDefs;
        synchronized (hashMap) {
            FilterDef[] results = new FilterDef[this.filterDefs.size()];
            return this.filterDefs.values().toArray(results);
        }
    }

    @Override
    public FilterMap[] findFilterMaps() {
        return this.filterMaps.asArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findInstanceListeners() {
        Object object = this.instanceListenersLock;
        synchronized (object) {
            return this.instanceListeners;
        }
    }

    @Deprecated
    public Context findMappingObject() {
        return (Context)this.getMappingObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination findMessageDestination(String name) {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            return this.messageDestinations.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDestination[] findMessageDestinations() {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            MessageDestination[] results = new MessageDestination[this.messageDestinations.size()];
            return this.messageDestinations.values().toArray(results);
        }
    }

    public MessageDestinationRef findMessageDestinationRef(String name) {
        return this.namingResources.findMessageDestinationRef(name);
    }

    public MessageDestinationRef[] findMessageDestinationRefs() {
        return this.namingResources.findMessageDestinationRefs();
    }

    @Override
    public String findMimeMapping(String extension) {
        return this.mimeMappings.get(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findMimeMappings() {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            String[] results = new String[this.mimeMappings.size()];
            return this.mimeMappings.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            return this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findParameters() {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findRoleMapping(String role) {
        String realRole = null;
        HashMap<String, String> hashMap = this.roleMappings;
        synchronized (hashMap) {
            realRole = this.roleMappings.get(role);
        }
        if (realRole != null) {
            return realRole;
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findSecurityRole(String role) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!role.equals(this.securityRoles[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findSecurityRoles() {
        Object object = this.securityRolesLock;
        synchronized (object) {
            return this.securityRoles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findServletMapping(String pattern) {
        Object object = this.servletMappingsLock;
        synchronized (object) {
            return this.servletMappings.get(pattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findServletMappings() {
        Object object = this.servletMappingsLock;
        synchronized (object) {
            String[] results = new String[this.servletMappings.size()];
            return this.servletMappings.keySet().toArray(results);
        }
    }

    @Override
    public String findStatusPage(int status) {
        ErrorPage errorPage = this.statusPages.get(status);
        if (errorPage != null) {
            return errorPage.getLocation();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] findStatusPages() {
        HashMap<Integer, ErrorPage> hashMap = this.statusPages;
        synchronized (hashMap) {
            int[] results = new int[this.statusPages.size()];
            Iterator<Integer> elements = this.statusPages.keySet().iterator();
            int i = 0;
            while (elements.hasNext()) {
                results[i++] = elements.next();
            }
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findWelcomeFile(String name) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!name.equals(this.welcomeFiles[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWatchedResources() {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            return this.watchedResources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWelcomeFiles() {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            return this.welcomeFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWrapperLifecycles() {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            return this.wrapperLifecycles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findWrapperListeners() {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            return this.wrapperListeners;
        }
    }

    @Override
    public synchronized void reload() {
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardContext.notStarted", new Object[]{this.getName()}));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardContext.reloadingStarted", new Object[]{this.getName()}));
        }
        this.setPaused(true);
        try {
            this.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)sm.getString("standardContext.stoppingContext", new Object[]{this.getName()}), (Throwable)e);
        }
        try {
            this.start();
        }
        catch (LifecycleException e) {
            log.error((Object)sm.getString("standardContext.startingContext", new Object[]{this.getName()}), (Throwable)e);
        }
        this.setPaused(false);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardContext.reloadingCompleted", new Object[]{this.getName()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationListener(String listener) {
        Object object = this.applicationListenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (!this.applicationListeners[i].getClassName().equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            ApplicationListener[] results = new ApplicationListener[this.applicationListeners.length - 1];
            for (int i = 0; i < this.applicationListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationListeners[i];
            }
            this.applicationListeners = results;
        }
        this.fireContainerEvent("removeApplicationListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApplicationParameter(String name) {
        Object object = this.applicationParametersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (!name.equals(this.applicationParameters[i].getName())) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            ApplicationParameter[] results = new ApplicationParameter[this.applicationParameters.length - 1];
            for (int i = 0; i < this.applicationParameters.length; ++i) {
                if (i == n) continue;
                results[j++] = this.applicationParameters[i];
            }
            this.applicationParameters = results;
        }
        this.fireContainerEvent("removeApplicationParameter", name);
    }

    @Override
    public void removeChild(Container child) {
        if (!(child instanceof Wrapper)) {
            throw new IllegalArgumentException(sm.getString("standardContext.notWrapper"));
        }
        super.removeChild(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConstraint(SecurityConstraint constraint) {
        Object object = this.constraintsLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.constraints.length; ++i) {
                if (!this.constraints[i].equals(constraint)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            SecurityConstraint[] results = new SecurityConstraint[this.constraints.length - 1];
            for (int i = 0; i < this.constraints.length; ++i) {
                if (i == n) continue;
                results[j++] = this.constraints[i];
            }
            this.constraints = results;
        }
        this.fireContainerEvent("removeConstraint", constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeErrorPage(ErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType != null) {
            HashMap<String, ErrorPage> hashMap = this.exceptionPages;
            synchronized (hashMap) {
                this.exceptionPages.remove(exceptionType);
            }
        }
        HashMap<Integer, ErrorPage> hashMap = this.statusPages;
        synchronized (hashMap) {
            if (errorPage.getErrorCode() == 200) {
                this.okErrorPage = null;
            }
            this.statusPages.remove(errorPage.getErrorCode());
        }
        this.fireContainerEvent("removeErrorPage", errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterDef(FilterDef filterDef) {
        HashMap<String, FilterDef> hashMap = this.filterDefs;
        synchronized (hashMap) {
            this.filterDefs.remove(filterDef.getFilterName());
        }
        this.fireContainerEvent("removeFilterDef", filterDef);
    }

    @Override
    public void removeFilterMap(FilterMap filterMap) {
        this.filterMaps.remove(filterMap);
        this.fireContainerEvent("removeFilterMap", filterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInstanceListener(String listener) {
        Object object = this.instanceListenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (!this.instanceListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.instanceListeners.length - 1];
            for (int i = 0; i < this.instanceListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.instanceListeners[i];
            }
            this.instanceListeners = results;
        }
        this.fireContainerEvent("removeInstanceListener", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageDestination(String name) {
        HashMap<String, MessageDestination> hashMap = this.messageDestinations;
        synchronized (hashMap) {
            this.messageDestinations.remove(name);
        }
        this.fireContainerEvent("removeMessageDestination", name);
    }

    public void removeMessageDestinationRef(String name) {
        this.namingResources.removeMessageDestinationRef(name);
        this.fireContainerEvent("removeMessageDestinationRef", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMimeMapping(String extension) {
        HashMap<String, String> hashMap = this.mimeMappings;
        synchronized (hashMap) {
            this.mimeMappings.remove(extension);
        }
        this.fireContainerEvent("removeMimeMapping", extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String name) {
        HashMap<String, String> hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        this.fireContainerEvent("removeParameter", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoleMapping(String role) {
        HashMap<String, String> hashMap = this.roleMappings;
        synchronized (hashMap) {
            this.roleMappings.remove(role);
        }
        this.fireContainerEvent("removeRoleMapping", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSecurityRole(String role) {
        Object object = this.securityRolesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (!role.equals(this.securityRoles[i])) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.securityRoles.length - 1];
            for (int i = 0; i < this.securityRoles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.securityRoles[i];
            }
            this.securityRoles = results;
        }
        this.fireContainerEvent("removeSecurityRole", role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServletMapping(String pattern) {
        String name = null;
        Object object = this.servletMappingsLock;
        synchronized (object) {
            name = this.servletMappings.remove(pattern);
        }
        Wrapper wrapper = (Wrapper)this.findChild(name);
        if (wrapper != null) {
            wrapper.removeMapping(pattern);
        }
        this.mapper.removeWrapper(pattern);
        this.fireContainerEvent("removeServletMapping", pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWatchedResource(String name) {
        Object object = this.watchedResourcesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.watchedResources.length; ++i) {
                if (!this.watchedResources[i].equals(name)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.watchedResources.length - 1];
            for (int i = 0; i < this.watchedResources.length; ++i) {
                if (i == n) continue;
                results[j++] = this.watchedResources[i];
            }
            this.watchedResources = results;
        }
        this.fireContainerEvent("removeWatchedResource", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWelcomeFile(String name) {
        Object object = this.welcomeFilesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (!this.welcomeFiles[i].equals(name)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.welcomeFiles.length - 1];
            for (int i = 0; i < this.welcomeFiles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.welcomeFiles[i];
            }
            this.welcomeFiles = results;
        }
        if (this.getState().equals((Object)LifecycleState.STARTED)) {
            this.fireContainerEvent("removeWelcomeFile", name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperLifecycle(String listener) {
        Object object = this.wrapperLifecyclesLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (!this.wrapperLifecycles[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperLifecycles.length - 1];
            for (int i = 0; i < this.wrapperLifecycles.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperLifecycles[i];
            }
            this.wrapperLifecycles = results;
        }
        this.fireContainerEvent("removeWrapperLifecycle", listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperListener(String listener) {
        Object object = this.wrapperListenersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (!this.wrapperListeners[i].equals(listener)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            int j = 0;
            String[] results = new String[this.wrapperListeners.length - 1];
            for (int i = 0; i < this.wrapperListeners.length; ++i) {
                if (i == n) continue;
                results[j++] = this.wrapperListeners[i];
            }
            this.wrapperListeners = results;
        }
        this.fireContainerEvent("removeWrapperListener", listener);
    }

    public long getProcessingTime() {
        long result = 0L;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result += ((StandardWrapper)children[i]).getProcessingTime();
            }
        }
        return result;
    }

    public long getMaxTime() {
        long result = 0L;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                long time = ((StandardWrapper)children[i]).getMaxTime();
                if (time <= result) continue;
                result = time;
            }
        }
        return result;
    }

    public long getMinTime() {
        long result = -1L;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                long time = ((StandardWrapper)children[i]).getMinTime();
                if (result >= 0L && time >= result) continue;
                result = time;
            }
        }
        return result;
    }

    public int getRequestCount() {
        int result = 0;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result += ((StandardWrapper)children[i]).getRequestCount();
            }
        }
        return result;
    }

    public int getErrorCount() {
        int result = 0;
        Container[] children = this.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                result += ((StandardWrapper)children[i]).getErrorCount();
            }
        }
        return result;
    }

    @Override
    public String getRealPath(String path) {
        if (this.webappResources instanceof BaseDirContext) {
            return ((BaseDirContext)this.webappResources).getRealPath(path);
        }
        return null;
    }

    public ServletRegistration.Dynamic dynamicServletAdded(Wrapper wrapper) {
        Servlet s = wrapper.getServlet();
        if (s != null && this.createdServlets.contains(s)) {
            wrapper.setServletSecurityAnnotationScanRequired(true);
        }
        return new ApplicationServletRegistration(wrapper, this);
    }

    public void dynamicServletCreated(Servlet servlet) {
        this.createdServlets.add(servlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStart() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Starting filters");
        }
        boolean ok = true;
        HashMap<String, ApplicationFilterConfig> hashMap = this.filterConfigs;
        synchronized (hashMap) {
            this.filterConfigs.clear();
            for (String name : this.filterDefs.keySet()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(" Starting filter '" + name + "'"));
                }
                ApplicationFilterConfig filterConfig = null;
                try {
                    filterConfig = new ApplicationFilterConfig(this, this.filterDefs.get(name));
                    this.filterConfigs.put(name, filterConfig);
                }
                catch (Throwable t) {
                    t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLogger().error((Object)sm.getString("standardContext.filterStart", new Object[]{name}), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterStop() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Stopping filters");
        }
        HashMap<String, ApplicationFilterConfig> hashMap = this.filterConfigs;
        synchronized (hashMap) {
            for (String name : this.filterConfigs.keySet()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(" Stopping filter '" + name + "'"));
                }
                ApplicationFilterConfig filterConfig = this.filterConfigs.get(name);
                filterConfig.release();
            }
            this.filterConfigs.clear();
        }
        return true;
    }

    public FilterConfig findFilterConfig(String name) {
        return this.filterConfigs.get(name);
    }

    public boolean listenerStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring application event listeners");
        }
        ApplicationListener[] listeners = this.applicationListeners;
        Object[] results = new Object[listeners.length];
        boolean ok = true;
        HashSet<Object> noPluggabilityListeners = new HashSet<Object>();
        for (int i = 0; i < results.length; ++i) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(" Configuring event listener class '" + listeners[i] + "'"));
            }
            try {
                ApplicationListener listener = listeners[i];
                results[i] = this.instanceManager.newInstance(listener.getClassName());
                if (!listener.isPluggabilityBlocked()) continue;
                noPluggabilityListeners.add(results[i]);
                continue;
            }
            catch (Throwable t) {
                t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                ExceptionUtils.handleThrowable((Throwable)t);
                this.getLogger().error((Object)sm.getString("standardContext.applicationListener", new Object[]{listeners[i].getClassName()}), t);
                ok = false;
            }
        }
        if (!ok) {
            this.getLogger().error((Object)sm.getString("standardContext.applicationSkipped"));
            return false;
        }
        ArrayList<Object> eventListeners = new ArrayList<Object>();
        ArrayList<Object> lifecycleListeners = new ArrayList<Object>();
        for (int i = 0; i < results.length; ++i) {
            if (results[i] instanceof ServletContextAttributeListener || results[i] instanceof ServletRequestAttributeListener || results[i] instanceof ServletRequestListener || results[i] instanceof HttpSessionAttributeListener) {
                eventListeners.add(results[i]);
            }
            if (!(results[i] instanceof ServletContextListener) && !(results[i] instanceof HttpSessionListener)) continue;
            lifecycleListeners.add(results[i]);
        }
        for (Object eventListener : this.getApplicationEventListeners()) {
            eventListeners.add(eventListener);
        }
        this.setApplicationEventListeners(eventListeners.toArray());
        for (Object lifecycleListener : this.getApplicationLifecycleListeners()) {
            lifecycleListeners.add(lifecycleListener);
            if (!(lifecycleListener instanceof ServletContextListener)) continue;
            noPluggabilityListeners.add(lifecycleListener);
        }
        this.setApplicationLifecycleListeners(lifecycleListeners.toArray());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Sending application start events");
        }
        this.getServletContext();
        this.context.setNewServletContextListenerAllowed(false);
        Object[] instances = this.getApplicationLifecycleListeners();
        if (instances == null || instances.length == 0) {
            return ok;
        }
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        ServletContextEvent tldEvent = null;
        if (noPluggabilityListeners.size() > 0) {
            tldEvent = new ServletContextEvent((ServletContext)new NoPluggabilityServletContext(this.getServletContext()));
        }
        for (int i = 0; i < instances.length; ++i) {
            if (instances[i] == null || !(instances[i] instanceof ServletContextListener)) continue;
            ServletContextListener listener = (ServletContextListener)instances[i];
            try {
                this.fireContainerEvent("beforeContextInitialized", listener);
                if (noPluggabilityListeners.contains(listener)) {
                    listener.contextInitialized(tldEvent);
                } else {
                    listener.contextInitialized(event);
                }
                this.fireContainerEvent("afterContextInitialized", listener);
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.fireContainerEvent("afterContextInitialized", listener);
                this.getLogger().error((Object)sm.getString("standardContext.listenerStart", new Object[]{instances[i].getClass().getName()}), t);
                ok = false;
            }
        }
        return ok;
    }

    public boolean listenerStop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sending application stop events");
        }
        boolean ok = true;
        Object[] listeners = this.getApplicationLifecycleListeners();
        if (listeners != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (int i = 0; i < listeners.length; ++i) {
                int j = listeners.length - 1 - i;
                if (listeners[j] == null) continue;
                if (listeners[j] instanceof ServletContextListener) {
                    ServletContextListener listener = (ServletContextListener)listeners[j];
                    try {
                        this.fireContainerEvent("beforeContextDestroyed", listener);
                        listener.contextDestroyed(event);
                        this.fireContainerEvent("afterContextDestroyed", listener);
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable((Throwable)t);
                        this.fireContainerEvent("afterContextDestroyed", listener);
                        this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{listeners[j].getClass().getName()}), t);
                        ok = false;
                    }
                }
                try {
                    this.getInstanceManager().destroyInstance(listeners[j]);
                    continue;
                }
                catch (Throwable t) {
                    t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{listeners[j].getClass().getName()}), t);
                    ok = false;
                }
            }
        }
        if ((listeners = this.getApplicationEventListeners()) != null) {
            for (int i = 0; i < listeners.length; ++i) {
                int j = listeners.length - 1 - i;
                if (listeners[j] == null) continue;
                try {
                    this.getInstanceManager().destroyInstance(listeners[j]);
                    continue;
                }
                catch (Throwable t) {
                    t = ExceptionUtils.unwrapInvocationTargetException((Throwable)t);
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{listeners[j].getClass().getName()}), t);
                    ok = false;
                }
            }
        }
        this.setApplicationEventListeners(null);
        this.setApplicationLifecycleListeners(null);
        return ok;
    }

    public boolean resourcesStart() {
        boolean ok = true;
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        try {
            ProxyDirContext proxyDirContext = new ProxyDirContext(env, this.webappResources);
            if (this.webappResources instanceof FileDirContext) {
                this.filesystemBased = true;
                ((FileDirContext)this.webappResources).setAllowLinking(this.isAllowLinking());
            }
            if (this.webappResources instanceof BaseDirContext) {
                ((BaseDirContext)this.webappResources).setDocBase(this.getBasePath());
                ((BaseDirContext)this.webappResources).setCached(this.isCachingAllowed());
                ((BaseDirContext)this.webappResources).setCacheTTL(this.getCacheTTL());
                ((BaseDirContext)this.webappResources).setCacheMaxSize(this.getCacheMaxSize());
                ((BaseDirContext)this.webappResources).allocate();
                ((BaseDirContext)this.webappResources).setAliases(this.getAliases());
                if (this.effectiveMajorVersion >= 3 && this.addWebinfClassesResources) {
                    try {
                        DirContext webInfCtx = (DirContext)this.webappResources.lookup("/WEB-INF/classes");
                        webInfCtx.lookup("META-INF/resources");
                        ((BaseDirContext)this.webappResources).addAltDirContext(webInfCtx);
                    }
                    catch (NamingException e) {
                        // empty catch block
                    }
                }
            }
            if (this.isCachingAllowed()) {
                String contextName = this.getName();
                if (!contextName.startsWith("/")) {
                    contextName = "/" + contextName;
                }
                ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",context=" + contextName);
                Registry.getRegistry(null, null).registerComponent((Object)proxyDirContext.getCache(), resourcesName, null);
            }
            this.resources = proxyDirContext;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("standardContext.resourcesStart"), t);
            ok = false;
        }
        return ok;
    }

    public boolean resourcesStop() {
        boolean ok = true;
        try {
            if (this.resources != null) {
                if (this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).stop();
                }
                if (this.webappResources instanceof BaseDirContext) {
                    ((BaseDirContext)this.webappResources).release();
                }
                if (this.isCachingAllowed()) {
                    String contextName = this.getName();
                    if (!contextName.startsWith("/")) {
                        contextName = "/" + contextName;
                    }
                    ObjectName resourcesName = new ObjectName(this.getDomain() + ":type=Cache,host=" + this.getHostname() + ",context=" + contextName);
                    Registry.getRegistry(null, null).unregisterComponent(resourcesName);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            log.error((Object)sm.getString("standardContext.resourcesStop"), t);
            ok = false;
        }
        this.resources = null;
        return ok;
    }

    public boolean loadOnStartup(Container[] children) {
        TreeMap<Integer, ArrayList<Wrapper>> map = new TreeMap<Integer, ArrayList<Wrapper>>();
        for (int i = 0; i < children.length; ++i) {
            Wrapper wrapper = (Wrapper)children[i];
            int loadOnStartup = wrapper.getLoadOnStartup();
            if (loadOnStartup < 0) continue;
            Integer key = loadOnStartup;
            ArrayList<Wrapper> list = (ArrayList<Wrapper>)map.get(key);
            if (list == null) {
                list = new ArrayList<Wrapper>();
                map.put(key, list);
            }
            list.add(wrapper);
        }
        for (ArrayList list : map.values()) {
            for (Wrapper wrapper : list) {
                try {
                    wrapper.load();
                }
                catch (ServletException e) {
                    this.getLogger().error((Object)sm.getString("standardWrapper.loadException", new Object[]{this.getName()}), StandardWrapper.getRootCause(e));
                    if (!this.getComputedFailCtxIfServletStartFails()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void startInternal() throws LifecycleException {
        String useNamingProperty;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting " + this.getBaseName()));
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        this.setConfigured(false);
        boolean ok = true;
        if (this.namingResources != null) {
            this.namingResources.start();
        }
        if (this.webappResources == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Configuring default Resources");
            }
            try {
                if (this.getDocBase() != null && this.getDocBase().endsWith(".war") && !new File(this.getBasePath()).isDirectory()) {
                    this.setResources(new WARDirContext());
                } else {
                    this.setResources(new FileDirContext());
                }
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error initializing resources: " + e.getMessage()));
                ok = false;
            }
        }
        if (ok && !this.resourcesStart()) {
            throw new LifecycleException("Error in resourceStart()");
        }
        if (this.getLoader() == null) {
            WebappLoader webappLoader = new WebappLoader(this.getParentClassLoader());
            webappLoader.setDelegate(this.getDelegate());
            this.setLoader(webappLoader);
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        boolean dependencyCheck = true;
        try {
            dependencyCheck = ExtensionValidator.validateApplication(this.getResources(), this);
        }
        catch (IOException ioe) {
            log.error((Object)"Error in dependencyCheck", (Throwable)ioe);
            dependencyCheck = false;
        }
        if (!dependencyCheck) {
            ok = false;
        }
        if ((useNamingProperty = System.getProperty("catalina.useNaming")) != null && useNamingProperty.equals("false")) {
            this.useNaming = false;
        }
        if (ok && this.isUseNaming() && this.getNamingContextListener() == null) {
            NamingContextListener ncl = new NamingContextListener();
            ncl.setName(this.getNamingContextName());
            ncl.setExceptionOnFailedWrite(this.getJndiExceptionOnFailedWrite());
            this.addLifecycleListener(ncl);
            this.setNamingContextListener(ncl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing standard container startup");
        }
        ClassLoader oldCCL = this.bindThread();
        try {
            if (ok) {
                Realm realm;
                if (this.loader != null && this.loader instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.loader)).start();
                }
                this.unbindThread(oldCCL);
                oldCCL = this.bindThread();
                this.logger = null;
                this.getLogger();
                if (this.cluster != null && this.cluster instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.cluster)).start();
                }
                if ((realm = this.getRealmInternal()) != null && realm instanceof Lifecycle) {
                    ((Lifecycle)((Object)realm)).start();
                }
                if (this.resources != null && this.resources instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.resources)).start();
                }
                this.fireLifecycleEvent("configure_start", null);
                for (Container child : this.findChildren()) {
                    if (child.getState().isAvailable()) continue;
                    child.start();
                }
                if (this.pipeline instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.pipeline)).start();
                }
                Manager contextManager = null;
                if (this.manager == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("standardContext.cluster.noManager", new Object[]{this.getCluster() != null, this.distributable}));
                    }
                    if (this.getCluster() != null && this.distributable) {
                        try {
                            contextManager = this.getCluster().createManager(this.getName());
                        }
                        catch (Exception ex) {
                            log.error((Object)"standardContext.clusterFail", (Throwable)ex);
                            ok = false;
                        }
                    } else {
                        contextManager = new StandardManager();
                    }
                }
                if (contextManager != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("standardContext.manager", new Object[]{contextManager.getClass().getName()}));
                    }
                    this.setManager(contextManager);
                }
                if (this.manager != null && this.getCluster() != null && this.distributable) {
                    this.getCluster().registerManager(this.manager);
                }
            }
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (!this.getConfigured()) {
            log.error((Object)"Error getConfigured");
            ok = false;
        }
        if (ok) {
            this.getServletContext().setAttribute("org.apache.catalina.resources", (Object)this.getResources());
        }
        this.mapper.setContext(this.getPath(), this.welcomeFiles, (javax.naming.Context)this.resources);
        oldCCL = this.bindThread();
        if (ok && this.getInstanceManager() == null) {
            javax.naming.Context context = null;
            if (this.isUseNaming() && this.getNamingContextListener() != null) {
                context = this.getNamingContextListener().getEnvContext();
            }
            Map<String, Map<String, String>> injectionMap = this.buildInjectionMap(this.getIgnoreAnnotations() ? new NamingResources() : this.getNamingResources());
            this.setInstanceManager(new DefaultInstanceManager(context, injectionMap, this, this.getClass().getClassLoader()));
            this.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)this.getInstanceManager());
        }
        try {
            if (ok) {
                this.getServletContext().setAttribute(JarScanner.class.getName(), (Object)this.getJarScanner());
            }
            this.mergeParameters();
            for (Map.Entry<ServletContainerInitializer, Set<Class<?>>> entry : this.initializers.entrySet()) {
                try {
                    entry.getKey().onStartup(entry.getValue(), this.getServletContext());
                }
                catch (ServletException e) {
                    log.error((Object)sm.getString("standardContext.sciFail"), (Throwable)e);
                    ok = false;
                    break;
                }
            }
            if (ok && !this.listenerStart()) {
                log.error((Object)"Error listenerStart");
                ok = false;
            }
            try {
                if (this.manager != null && this.manager instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.getManager())).start();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error manager.start()", (Throwable)e);
                ok = false;
            }
            if (ok && !this.filterStart()) {
                log.error((Object)"Error filterStart");
                ok = false;
            }
            if (ok && !this.loadOnStartup(this.findChildren())) {
                log.error((Object)"Error loadOnStartup");
                ok = false;
            }
            super.threadStart();
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (ok) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting completed");
            }
        } else {
            log.error((Object)sm.getString("standardContext.startFailed", new Object[]{this.getName()}));
        }
        this.startTime = System.currentTimeMillis();
        if (ok && this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        if (this.getLoader() instanceof WebappLoader) {
            ((WebappLoader)this.getLoader()).closeJARs(true);
        }
        if (!ok) {
            this.setState(LifecycleState.FAILED);
        } else {
            this.setState(LifecycleState.STARTING);
        }
    }

    private Map<String, Map<String, String>> buildInjectionMap(NamingResources namingResources) {
        HashMap<String, Map<String, String>> injectionMap = new HashMap<String, Map<String, String>>();
        for (ContextLocalEjb contextLocalEjb : namingResources.findLocalEjbs()) {
            this.addInjectionTarget(contextLocalEjb, injectionMap);
        }
        for (ResourceBase resourceBase : namingResources.findEjbs()) {
            this.addInjectionTarget(resourceBase, injectionMap);
        }
        for (ResourceBase resourceBase : namingResources.findEnvironments()) {
            this.addInjectionTarget(resourceBase, injectionMap);
        }
        for (ResourceBase resourceBase : namingResources.findMessageDestinationRefs()) {
            this.addInjectionTarget(resourceBase, injectionMap);
        }
        for (ResourceBase resourceBase : namingResources.findResourceEnvRefs()) {
            this.addInjectionTarget(resourceBase, injectionMap);
        }
        for (ResourceBase resourceBase : namingResources.findResources()) {
            this.addInjectionTarget(resourceBase, injectionMap);
        }
        for (ResourceBase resourceBase : namingResources.findServices()) {
            this.addInjectionTarget(resourceBase, injectionMap);
        }
        return injectionMap;
    }

    private void addInjectionTarget(Injectable resource, Map<String, Map<String, String>> injectionMap) {
        List<InjectionTarget> injectionTargets = resource.getInjectionTargets();
        if (injectionTargets != null && injectionTargets.size() > 0) {
            String jndiName = resource.getName();
            for (InjectionTarget injectionTarget : injectionTargets) {
                String clazz = injectionTarget.getTargetClass();
                Map<String, String> injections = injectionMap.get(clazz);
                if (injections == null) {
                    injections = new HashMap<String, String>();
                    injectionMap.put(clazz, injections);
                }
                injections.put(injectionTarget.getTargetName(), jndiName);
            }
        }
    }

    private void mergeParameters() {
        HashMap<String, String> mergedParams = new HashMap<String, String>();
        String[] names = this.findParameters();
        for (int i = 0; i < names.length; ++i) {
            mergedParams.put(names[i], this.findParameter(names[i]));
        }
        ApplicationParameter[] params = this.findApplicationParameters();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getOverride()) {
                if (mergedParams.get(params[i].getName()) != null) continue;
                mergedParams.put(params[i].getName(), params[i].getValue());
                continue;
            }
            mergedParams.put(params[i].getName(), params[i].getValue());
        }
        ServletContext sc = this.getServletContext();
        for (Map.Entry entry : mergedParams.entrySet()) {
            sc.setInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        this.setState(LifecycleState.STOPPING);
        ClassLoader oldCCL = this.bindThread();
        try {
            Container[] children = this.findChildren();
            ClassLoader old = this.bindThread();
            try {
                this.threadStop();
                for (int i = 0; i < children.length; ++i) {
                    children[i].stop();
                }
                this.filterStop();
                if (this.manager != null && this.manager instanceof Lifecycle && ((Lifecycle)((Object)this.manager)).getState().isAvailable()) {
                    ((Lifecycle)((Object)this.manager)).stop();
                }
                this.listenerStop();
            }
            finally {
                this.unbindThread(old);
            }
            this.setCharsetMapper(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Processing standard container shutdown");
            }
            if (this.namingResources != null) {
                this.namingResources.stop();
            }
            this.fireLifecycleEvent("configure_stop", null);
            if (this.pipeline instanceof Lifecycle && ((Lifecycle)((Object)this.pipeline)).getState().isAvailable()) {
                ((Lifecycle)((Object)this.pipeline)).stop();
            }
            if (this.context != null) {
                this.context.clearAttributes();
            }
            this.resourcesStop();
            Realm realm = this.getRealmInternal();
            if (realm != null && realm instanceof Lifecycle) {
                ((Lifecycle)((Object)realm)).stop();
            }
            if (this.cluster != null && this.cluster instanceof Lifecycle) {
                ((Lifecycle)((Object)this.cluster)).stop();
            }
            if (this.loader != null && this.loader instanceof Lifecycle) {
                ((Lifecycle)((Object)this.loader)).stop();
            }
        }
        finally {
            this.unbindThread(oldCCL);
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        this.context = null;
        try {
            this.resetContext();
        }
        catch (Exception ex) {
            log.error((Object)("Error reseting context " + this + " " + ex), (Throwable)ex);
        }
        this.instanceManager = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
        if (this.namingResources != null) {
            this.namingResources.destroy();
        }
        Object object = this.instanceListenersLock;
        synchronized (object) {
            this.instanceListeners = new String[0];
        }
        super.destroyInternal();
    }

    private void resetContext() throws Exception {
        for (Container child : this.findChildren()) {
            this.removeChild(child);
        }
        this.startupTime = 0L;
        this.startTime = 0L;
        this.tldScanTime = 0L;
        this.distributable = false;
        this.applicationListeners = new ApplicationListener[0];
        this.applicationEventListenersObjects = new Object[0];
        this.applicationLifecycleListenersObjects = new Object[0];
        this.jspConfigDescriptor = new ApplicationJspConfigDescriptor();
        this.initializers.clear();
        this.createdServlets.clear();
        this.postConstructMethods.clear();
        this.preDestroyMethods.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("resetContext " + this.getObjectName()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardContext[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    protected String adjustURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return urlPattern;
        }
        if (urlPattern.startsWith("/") || urlPattern.startsWith("*.")) {
            return urlPattern;
        }
        if (!this.isServlet22()) {
            return urlPattern;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("standardContext.urlPattern.patternWarning", new Object[]{urlPattern}));
        }
        return "/" + urlPattern;
    }

    @Override
    public boolean isServlet22() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(this.publicId);
    }

    @Override
    public Set<String> addServletSecurity(ApplicationServletRegistration registration, ServletSecurityElement servletSecurityElement) {
        HashSet<String> conflicts = new HashSet<String>();
        Collection<String> urlPatterns = registration.getMappings();
        for (String urlPattern : urlPatterns) {
            SecurityConstraint[] newSecurityConstraints;
            SecurityConstraint[] securityConstraints;
            boolean foundConflict = false;
            for (SecurityConstraint securityConstraint : securityConstraints = this.findConstraints()) {
                SecurityCollection[] collections;
                for (SecurityCollection collection : collections = securityConstraint.findCollections()) {
                    if (collection.findPattern(urlPattern)) {
                        if (collection.isFromDescriptor()) {
                            foundConflict = true;
                            conflicts.add(urlPattern);
                        } else {
                            this.removeConstraint(securityConstraint);
                        }
                    }
                    if (foundConflict) break;
                }
                if (foundConflict) break;
            }
            if (foundConflict) continue;
            for (SecurityConstraint securityConstraint : newSecurityConstraints = SecurityConstraint.createConstraints(servletSecurityElement, urlPattern)) {
                this.addConstraint(securityConstraint);
            }
        }
        return conflicts;
    }

    protected File engineBase() {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine eng = (StandardEngine)this.getParent().getParent();
            base = eng.getBaseDir();
        }
        return new File(base);
    }

    protected ClassLoader bindThread() {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.getResources() == null) {
            return oldContextClassLoader;
        }
        if (this.getLoader() != null && this.getLoader().getClassLoader() != null) {
            Thread.currentThread().setContextClassLoader(this.getLoader().getClassLoader());
        }
        DirContextURLStreamHandler.bindThread(this.getResources());
        if (this.isUseNaming()) {
            try {
                ContextBindings.bindThread(this, this);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return oldContextClassLoader;
    }

    protected void unbindThread(ClassLoader oldContextClassLoader) {
        if (this.isUseNaming()) {
            ContextBindings.unbindThread(this, this);
        }
        DirContextURLStreamHandler.unbindThread();
        Thread.currentThread().setContextClassLoader(oldContextClassLoader);
    }

    protected String getBasePath() {
        Container container;
        String docBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(this.getDocBase());
        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = new File(this.engineBase(), this.getDocBase()).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(), appBase);
                }
                docBase = new File(file, this.getDocBase()).getPath();
            }
        } else {
            docBase = file.getPath();
        }
        return docBase;
    }

    protected String getAppBase() {
        Container container;
        String appBase = null;
        for (container = this; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        if (container != null) {
            appBase = ((Host)container).getAppBase();
        }
        return appBase;
    }

    private String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuilder buff = new StringBuilder();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/" + (String)stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
        }
        return this.namingContextName;
    }

    public NamingContextListener getNamingContextListener() {
        return this.namingContextListener;
    }

    public void setNamingContextListener(NamingContextListener namingContextListener) {
        this.namingContextListener = namingContextListener;
    }

    @Override
    public boolean getPaused() {
        return this.paused;
    }

    @Deprecated
    public String getHostname() {
        Container parentHost = this.getParent();
        if (parentHost != null) {
            this.hostName = parentHost.getName();
        }
        if (this.hostName == null || this.hostName.length() < 1) {
            this.hostName = "_";
        }
        return this.hostName;
    }

    @Override
    public boolean fireRequestInitEvent(ServletRequest request) {
        Object[] instances = this.getApplicationEventListeners();
        if (instances != null && instances.length > 0) {
            ServletRequestEvent event = new ServletRequestEvent(this.getServletContext(), request);
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLogger().error((Object)sm.getString("standardContext.requestListener.requestInit", new Object[]{instances[i].getClass().getName()}), t);
                    request.setAttribute("javax.servlet.error.exception", (Object)t);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean fireRequestDestroyEvent(ServletRequest request) {
        Object[] instances = this.getApplicationEventListeners();
        if (instances != null && instances.length > 0) {
            ServletRequestEvent event = new ServletRequestEvent(this.getServletContext(), request);
            for (int i = 0; i < instances.length; ++i) {
                int j = instances.length - 1 - i;
                if (instances[j] == null || !(instances[j] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[j];
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLogger().error((Object)sm.getString("standardContext.requestListener.requestInit", new Object[]{instances[j].getClass().getName()}), t);
                    request.setAttribute("javax.servlet.error.exception", (Object)t);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void addPostConstructMethod(String clazz, String method) {
        if (clazz == null || method == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.postconstruct.required"));
        }
        if (this.postConstructMethods.get(clazz) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.postconstruct.duplicate", new Object[]{clazz}));
        }
        this.postConstructMethods.put(clazz, method);
        this.fireContainerEvent("addPostConstructMethod", clazz);
    }

    @Override
    public void removePostConstructMethod(String clazz) {
        this.postConstructMethods.remove(clazz);
        this.fireContainerEvent("removePostConstructMethod", clazz);
    }

    @Override
    public void addPreDestroyMethod(String clazz, String method) {
        if (clazz == null || method == null) {
            throw new IllegalArgumentException(sm.getString("standardContext.predestroy.required"));
        }
        if (this.preDestroyMethods.get(clazz) != null) {
            throw new IllegalArgumentException(sm.getString("standardContext.predestroy.duplicate", new Object[]{clazz}));
        }
        this.preDestroyMethods.put(clazz, method);
        this.fireContainerEvent("addPreDestroyMethod", clazz);
    }

    @Override
    public void removePreDestroyMethod(String clazz) {
        this.preDestroyMethods.remove(clazz);
        this.fireContainerEvent("removePreDestroyMethod", clazz);
    }

    @Override
    public String findPostConstructMethod(String clazz) {
        return this.postConstructMethods.get(clazz);
    }

    @Override
    public String findPreDestroyMethod(String clazz) {
        return this.preDestroyMethods.get(clazz);
    }

    @Override
    public Map<String, String> findPostConstructMethods() {
        return this.postConstructMethods;
    }

    @Override
    public Map<String, String> findPreDestroyMethods() {
        return this.preDestroyMethods;
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null || workDir.length() == 0) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getName()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "_";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            File catalinaHome = this.engineBase();
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                log.warn((Object)sm.getString("standardContext.workCreateException", new Object[]{workDir, catalinaHomePath, this.getName()}), (Throwable)e);
            }
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            log.warn((Object)sm.getString("standardContext.workCreateFail", new Object[]{dir, this.getName()}));
        }
        if (this.context == null) {
            this.getServletContext();
        }
        this.context.setAttribute("javax.servlet.context.tempdir", dir);
        this.context.setAttributeReadOnly("javax.servlet.context.tempdir");
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    private boolean validateURLPattern(String urlPattern) {
        if (urlPattern == null) {
            return false;
        }
        if (urlPattern.indexOf(10) >= 0 || urlPattern.indexOf(13) >= 0) {
            return false;
        }
        if (urlPattern.equals("")) {
            return true;
        }
        if (urlPattern.startsWith("*.")) {
            if (urlPattern.indexOf(47) < 0) {
                this.checkUnusualURLPattern(urlPattern);
                return true;
            }
            return false;
        }
        if (urlPattern.startsWith("/") && urlPattern.indexOf("*.") < 0) {
            this.checkUnusualURLPattern(urlPattern);
            return true;
        }
        return false;
    }

    private void checkUnusualURLPattern(String urlPattern) {
        if (log.isInfoEnabled() && (urlPattern.endsWith("*") && (urlPattern.length() < 2 || urlPattern.charAt(urlPattern.length() - 2) != '/') || urlPattern.startsWith("*.") && urlPattern.length() > 2 && urlPattern.lastIndexOf(46) > 1)) {
            log.info((Object)("Suspicious url pattern: \"" + urlPattern + "\"" + " in context [" + this.getName() + "] - see" + " sections 12.1 and 12.2 of the Servlet specification"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentDescriptor() {
        InputStream stream = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        }
        if (stream == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(stream));
            String strRead = "";
            while (strRead != null) {
                sb.append(strRead);
                strRead = br.readLine();
            }
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        return sb.toString();
    }

    public String[] getServlets() {
        String[] result = null;
        Container[] children = this.findChildren();
        if (children != null) {
            result = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = children[i].getObjectName().toString();
            }
        }
        return result;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("j2eeType=WebModule,");
        keyProperties.append(this.getObjectKeyPropertiesNameOnly());
        keyProperties.append(",J2EEApplication=");
        keyProperties.append(this.getJ2EEApplication());
        keyProperties.append(",J2EEServer=");
        keyProperties.append(this.getJ2EEServer());
        return keyProperties.toString();
    }

    private String getObjectKeyPropertiesNameOnly() {
        StringBuilder result = new StringBuilder("name=//");
        String hostname = this.getParent().getName();
        if (hostname == null) {
            result.append("DEFAULT");
        } else {
            result.append(hostname);
        }
        String contextName = this.getName();
        if (!contextName.startsWith("/")) {
            result.append('/');
        }
        result.append(contextName);
        return result.toString();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.processTlds) {
            this.addLifecycleListener(new TldConfig());
        }
        if (this.namingResources != null) {
            this.namingResources.init();
        }
        if (this.getObjectName() != null) {
            Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber.getAndIncrement());
            this.broadcaster.sendNotification(notification);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "web application is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "change web application is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "web application is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopping"}, Notification.class.getName(), "web application start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "web application is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "web application is deleted")};
        }
        return this.notificationInfo;
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    @Deprecated
    public DirContext getStaticResources() {
        return this.getResources();
    }

    @Deprecated
    public DirContext findStaticResources() {
        return this.getResources();
    }

    public String[] getWelcomeFiles() {
        return this.findWelcomeFiles();
    }

    @Override
    public boolean getXmlNamespaceAware() {
        return this.webXmlNamespaceAware;
    }

    @Override
    public void setXmlNamespaceAware(boolean webXmlNamespaceAware) {
        this.webXmlNamespaceAware = webXmlNamespaceAware;
    }

    @Override
    public void setXmlValidation(boolean webXmlValidation) {
        this.webXmlValidation = webXmlValidation;
    }

    @Override
    public boolean getXmlValidation() {
        return this.webXmlValidation;
    }

    @Override
    public boolean getTldNamespaceAware() {
        return true;
    }

    @Override
    public void setTldNamespaceAware(boolean tldNamespaceAware) {
    }

    @Override
    public void setXmlBlockExternal(boolean xmlBlockExternal) {
        this.xmlBlockExternal = xmlBlockExternal;
    }

    @Override
    public boolean getXmlBlockExternal() {
        return this.xmlBlockExternal;
    }

    @Override
    public void setTldValidation(boolean tldValidation) {
        this.tldValidation = tldValidation;
    }

    @Override
    public boolean getTldValidation() {
        return this.tldValidation;
    }

    public void setProcessTlds(boolean newProcessTlds) {
        this.processTlds = newProcessTlds;
    }

    public boolean getProcessTlds() {
        return this.processTlds;
    }

    public boolean isStateManageable() {
        return true;
    }

    @Deprecated
    public void startRecursive() throws LifecycleException {
        this.start();
    }

    public String getServer() {
        return this.server;
    }

    public String setServer(String server) {
        this.server = server;
        return this.server;
    }

    public String[] getJavaVMs() {
        return this.javaVMs;
    }

    public String[] setJavaVMs(String[] javaVMs) {
        this.javaVMs = javaVMs;
        return javaVMs;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Deprecated
    public boolean isEventProvider() {
        return false;
    }

    @Deprecated
    public boolean isStatisticsProvider() {
        return false;
    }

    static {
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }

    private static final class ContextFilterMaps {
        private final Object lock = new Object();
        private FilterMap[] array = new FilterMap[0];
        private int insertPoint = 0;

        private ContextFilterMaps() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FilterMap[] asArray() {
            Object object = this.lock;
            synchronized (object) {
                return this.array;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(FilterMap filterMap) {
            Object object = this.lock;
            synchronized (object) {
                FilterMap[] results = Arrays.copyOf(this.array, this.array.length + 1);
                results[this.array.length] = filterMap;
                this.array = results;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBefore(FilterMap filterMap) {
            Object object = this.lock;
            synchronized (object) {
                FilterMap[] results = new FilterMap[this.array.length + 1];
                System.arraycopy(this.array, 0, results, 0, this.insertPoint);
                System.arraycopy(this.array, this.insertPoint, results, this.insertPoint + 1, this.array.length - this.insertPoint);
                results[this.insertPoint] = filterMap;
                this.array = results;
                ++this.insertPoint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(FilterMap filterMap) {
            Object object = this.lock;
            synchronized (object) {
                int n = -1;
                for (int i = 0; i < this.array.length; ++i) {
                    if (this.array[i] != filterMap) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    return;
                }
                FilterMap[] results = new FilterMap[this.array.length - 1];
                System.arraycopy(this.array, 0, results, 0, n);
                System.arraycopy(this.array, n + 1, results, n, this.array.length - 1 - n);
                this.array = results;
                if (n < this.insertPoint) {
                    --this.insertPoint;
                }
            }
        }
    }

    private static class NoPluggabilityServletContext
    implements ServletContext {
        private final ServletContext sc;

        public NoPluggabilityServletContext(ServletContext sc) {
            this.sc = sc;
        }

        public String getContextPath() {
            return this.sc.getContextPath();
        }

        public ServletContext getContext(String uripath) {
            return this.sc.getContext(uripath);
        }

        public int getMajorVersion() {
            return this.sc.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.sc.getMinorVersion();
        }

        public int getEffectiveMajorVersion() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public int getEffectiveMinorVersion() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public String getMimeType(String file) {
            return this.sc.getMimeType(file);
        }

        public Set<String> getResourcePaths(String path) {
            return this.sc.getResourcePaths(path);
        }

        public URL getResource(String path) throws MalformedURLException {
            return this.sc.getResource(path);
        }

        public InputStream getResourceAsStream(String path) {
            return this.sc.getResourceAsStream(path);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.sc.getRequestDispatcher(path);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return this.sc.getNamedDispatcher(name);
        }

        @Deprecated
        public Servlet getServlet(String name) throws ServletException {
            return this.sc.getServlet(name);
        }

        @Deprecated
        public Enumeration<Servlet> getServlets() {
            return this.sc.getServlets();
        }

        @Deprecated
        public Enumeration<String> getServletNames() {
            return this.sc.getServletNames();
        }

        public void log(String msg) {
            this.sc.log(msg);
        }

        @Deprecated
        public void log(Exception exception, String msg) {
            this.sc.log(exception, msg);
        }

        public void log(String message, Throwable throwable) {
            this.sc.log(message, throwable);
        }

        public String getRealPath(String path) {
            return this.sc.getRealPath(path);
        }

        public String getServerInfo() {
            return this.sc.getServerInfo();
        }

        public String getInitParameter(String name) {
            return this.sc.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.sc.getInitParameterNames();
        }

        public boolean setInitParameter(String name, String value) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Object getAttribute(String name) {
            return this.sc.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.sc.getAttributeNames();
        }

        public void setAttribute(String name, Object object) {
            this.sc.setAttribute(name, object);
        }

        public void removeAttribute(String name) {
            this.sc.removeAttribute(name);
        }

        public String getServletContextName() {
            return this.sc.getServletContextName();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ServletRegistration getServletRegistration(String servletName) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public SessionCookieConfig getSessionCookieConfig() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void addListener(String className) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends EventListener> void addListener(T t) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public <T extends EventListener> T createListener(Class<T> c) throws ServletException {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public ClassLoader getClassLoader() {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }

        public void declareRoles(String ... roleNames) {
            throw new UnsupportedOperationException(ContainerBase.sm.getString("noPluggabilityServletContext.notAllowed"));
        }
    }
}

