/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.url.PackageMergeUtils;
import org.eclipse.gemini.web.internal.url.PackagesInWarScanner;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

public final class SystemBundleExportsImportingWebBundleManifestTransformer
implements WebBundleManifestTransformer {
    private final Map<String, VersionRange> systemBundleExports;
    private final PackagesInWarScanner warPackagesScanner = new PackagesInWarScanner();

    public SystemBundleExportsImportingWebBundleManifestTransformer(Map<String, VersionRange> systemBundleExports) {
        this.systemBundleExports = systemBundleExports;
    }

    @Override
    public void transform(BundleManifest manifest, URL sourceURL, InstallationOptions options, boolean webBundle) throws IOException {
        if (!webBundle || options.getDefaultWABHeaders()) {
            this.addImportsForSystemBundleExports(manifest, this.warPackagesScanner.getPackagesContainedInWar(sourceURL));
        }
    }

    protected void addImportsForSystemBundleExports(BundleManifest bundleManifest, Set<String> packagesInWar) {
        for (Map.Entry<String, VersionRange> exportedPackage : this.systemBundleExports.entrySet()) {
            String packageName = exportedPackage.getKey();
            if (packagesInWar.contains(packageName) || PackageMergeUtils.findImportedPackage(bundleManifest, packageName) != null) continue;
            bundleManifest.getImportPackage().addImportedPackage(packageName).setVersion(exportedPackage.getValue());
        }
    }
}

