/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.schema.SchemaDescriptor;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.schema.SchemaEditor;
import org.eclipse.swt.widgets.Shell;

public class OpenSchemaAction
extends Action {
    private ISchema fSchema = null;
    private String fFullPointID = null;

    public OpenSchemaAction() {
        this.initialize();
    }

    private void initialize() {
        this.setImageDescriptor(PDEPluginImages.DESC_SCHEMA_OBJ);
        this.setText(PDEUIMessages.HyperlinkActionOpenSchema);
        this.setToolTipText(PDEUIMessages.HyperlinkActionOpenSchema);
        this.setEnabled(false);
    }

    public void setInput(ISchema schema) {
        if (schema == null) {
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = schema.getQualifiedPointId();
        this.fSchema = schema;
    }

    public void setInput(IPluginExtensionPoint point) {
        if (point == null) {
            this.fSchema = null;
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = point.getFullId();
        if (this.fFullPointID.indexOf(46) == -1) {
            this.fSchema = null;
            return;
        }
        this.fSchema = this.findSchema(point);
    }

    public void setInput(String fullPointID) {
        if (fullPointID == null) {
            this.fSchema = null;
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = fullPointID;
        IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(this.fFullPointID);
        if (point == null) {
            this.fSchema = null;
            return;
        }
        this.fSchema = this.findSchema(point);
    }

    public void setInput(IPluginExtension extension) {
        if (extension == null) {
            this.fSchema = null;
            this.fFullPointID = PDEUIMessages.OpenSchemaAction_msgUnknown;
            return;
        }
        this.fFullPointID = extension.getPoint();
        IPluginExtensionPoint point = PDECore.getDefault().getExtensionsRegistry().findExtensionPoint(this.fFullPointID);
        if (point == null) {
            this.fSchema = null;
            return;
        }
        this.fSchema = this.findSchema(point);
    }

    private ISchema findSchema(IPluginExtensionPoint point) {
        URL url = SchemaRegistry.getSchemaURL((IPluginExtensionPoint)point);
        if (url == null) {
            return null;
        }
        SchemaDescriptor descriptor = new SchemaDescriptor(this.fFullPointID, url);
        ISchema schema = descriptor.getSchema(false);
        if (schema == null) {
            return null;
        }
        return schema;
    }

    private void displayErrorDialog() {
        String title = PDEUIMessages.OpenSchemaAction_titleExtensionPointSchema;
        String message = NLS.bind((String)PDEUIMessages.OpenSchemaAction_errorMsgSchemaNotFound, (Object)this.fFullPointID);
        MessageDialog.openWarning((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    public void run() {
        if (this.fSchema == null) {
            this.displayErrorDialog();
            return;
        }
        URL schemaURL = this.fSchema.getURL();
        if (schemaURL == null) {
            this.displayErrorDialog();
            return;
        }
        if (schemaURL.getProtocol().startsWith("jar")) {
            this.openSchemaJar(schemaURL);
        } else {
            this.openSchemaFile(schemaURL);
        }
    }

    private void openSchemaFile(URL url) {
        try {
            URI uri = URIUtil.toURI((URL)url);
            File schemaFile = URIUtil.toFile((URI)uri);
            if (schemaFile == null || !schemaFile.exists()) {
                this.displayErrorDialog();
                return;
            }
            IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
            IFile[] filesForLocation = root.findFilesForLocationURI(uri);
            if (filesForLocation.length > 0) {
                SchemaEditor.openSchema(filesForLocation[0]);
                return;
            }
            SchemaEditor.openSchema(schemaFile);
        }
        catch (URISyntaxException e) {
            PDEPlugin.log(e);
            this.displayErrorDialog();
        }
    }

    private void openSchemaJar(URL url) {
        try {
            String stringUrl = url.getPath();
            int jarSuffix = stringUrl.indexOf(33);
            if (jarSuffix <= 0 || jarSuffix + 1 >= stringUrl.length()) {
                this.displayErrorDialog();
                return;
            }
            String fileUrl = stringUrl.substring(0, jarSuffix);
            URI uri = URIUtil.toURI((URL)new URL(fileUrl));
            File jarFile = URIUtil.toFile((URI)uri);
            if (jarFile == null || !jarFile.exists()) {
                this.displayErrorDialog();
                return;
            }
            String schemaEntryName = stringUrl.substring(jarSuffix + 1);
            if (schemaEntryName.startsWith("/")) {
                schemaEntryName = schemaEntryName.substring(1);
            }
            if (!SchemaEditor.openSchema(jarFile, schemaEntryName)) {
                this.displayErrorDialog();
            }
        }
        catch (URISyntaxException e) {
            PDEPlugin.log(e);
            this.displayErrorDialog();
        }
        catch (MalformedURLException e) {
            PDEPlugin.log(e);
            this.displayErrorDialog();
        }
    }
}

