/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.util.ImageOverlayIcon;
import org.eclipse.pde.internal.ui.util.OverlayIcon;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SharedLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int F_ERROR = 1;
    public static final int F_WARNING = 2;
    public static final int F_EXPORT = 4;
    public static final int F_EDIT = 8;
    public static final int F_BINARY = 16;
    public static final int F_EXTERNAL = 32;
    public static final int F_JAVA = 64;
    public static final int F_JAR = 128;
    public static final int F_PROJECT = 256;
    public static final int F_OPTIONAL = 512;
    public static final int F_INTERNAL = 1024;
    public static final int F_FRIEND = 2048;
    Hashtable<Object, Image> images = new Hashtable();
    ArrayList<Object> consumers = new ArrayList();
    private Image fBlankImage;

    public void connect(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void disconnect(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.size() == 0) {
            this.dispose();
        }
    }

    public void dispose() {
        if (this.consumers.size() == 0) {
            Enumeration<Image> elements = this.images.elements();
            while (elements.hasMoreElements()) {
                elements.nextElement().dispose();
            }
            this.images.clear();
            if (this.fBlankImage != null) {
                this.fBlankImage.dispose();
                this.fBlankImage = null;
            }
        }
    }

    public Image get(ImageDescriptor desc) {
        return this.get(desc, 0);
    }

    public Image get(ImageDescriptor desc, int flags) {
        Image image;
        Object key = desc;
        if (flags != 0) {
            key = this.getKey(desc.hashCode(), flags);
        }
        if ((image = this.images.get(key)) == null) {
            image = this.createImage(desc, flags);
            this.images.put(key, image);
        }
        return image;
    }

    public Image get(Image image, int flags) {
        if (flags == 0) {
            return image;
        }
        String key = this.getKey(image.hashCode(), flags);
        Image resultImage = this.images.get(key);
        if (resultImage == null) {
            resultImage = this.createImage(image, flags);
            this.images.put(key, resultImage);
        }
        return resultImage;
    }

    private String getKey(long hashCode, int flags) {
        return hashCode + ":" + flags;
    }

    private Image createImage(ImageDescriptor baseDesc, int flags) {
        if (flags == 0) {
            return baseDesc.createImage();
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        OverlayIcon compDesc = new OverlayIcon(baseDesc, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private Image createImage(Image baseImage, int flags) {
        if (flags == 0) {
            return baseImage;
        }
        ImageDescriptor[] lowerLeft = this.getLowerLeftOverlays(flags);
        ImageDescriptor[] upperRight = this.getUpperRightOverlays(flags);
        ImageDescriptor[] lowerRight = this.getLowerRightOverlays(flags);
        ImageDescriptor[] upperLeft = this.getUpperLeftOverlays(flags);
        ImageOverlayIcon compDesc = new ImageOverlayIcon(baseImage, new ImageDescriptor[][]{upperRight, lowerRight, lowerLeft, upperLeft});
        return compDesc.createImage();
    }

    private ImageDescriptor[] getLowerLeftOverlays(int flags) {
        if ((flags & 1) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_ERROR_CO};
        }
        if ((flags & 2) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_WARNING_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperRightOverlays(int flags) {
        if ((flags & 4) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_EXPORT_CO};
        }
        if ((flags & 8) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_DOC_CO};
        }
        if ((flags & 0x40) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_JAVA_CO};
        }
        return null;
    }

    private ImageDescriptor[] getLowerRightOverlays(int flags) {
        if ((flags & 0x80) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_JAR_CO};
        }
        if ((flags & 0x100) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_PROJECT_CO};
        }
        if ((flags & 0x200) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_OPTIONAL_CO};
        }
        if ((flags & 0x400) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_INTERNAL_CO};
        }
        if ((flags & 0x800) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_FRIEND_CO};
        }
        return null;
    }

    private ImageDescriptor[] getUpperLeftOverlays(int flags) {
        if ((flags & 0x20) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_EXTERNAL_CO};
        }
        if ((flags & 0x10) != 0) {
            return new ImageDescriptor[]{PDEPluginImages.DESC_BINARY_CO};
        }
        return null;
    }

    public String getColumnText(Object obj, int index) {
        return this.getText(obj);
    }

    public Image getColumnImage(Object obj, int index) {
        return this.getImage(obj);
    }

    public Image getImageFromPlugin(String bundleID, String path) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundleID, (String)path);
        return desc != null ? this.get(desc) : this.getBlankImage();
    }

    /*
     * Unable to fully structure code
     */
    public Image getImageFromPlugin(IPluginModelBase model, String relativePath) {
        block39: {
            block38: {
                platform = "platform:/plugin/";
                if (relativePath.startsWith(platform)) {
                    index = (relativePath = relativePath.substring(platform.length())).indexOf(47);
                    if (index == -1) {
                        return null;
                    }
                    model = PluginRegistry.findModel((String)relativePath.substring(0, index));
                    if (model == null) {
                        return null;
                    }
                    relativePath = relativePath.substring(index + 1);
                }
                if ((location = model.getInstallLocation()) == null) {
                    return null;
                }
                pluginLocation = new File(location);
                stream = null;
                jarFile = null;
                if (pluginLocation.isDirectory()) {
                    file = new File(pluginLocation, relativePath);
                    if (file.exists()) {
                        stream = new FileInputStream(file);
                    } else if (relativePath.length() > 5 && relativePath.startsWith("$nl$/") && (file = new File(pluginLocation, relativePath.substring(5))).exists()) {
                        stream = new FileInputStream(file);
                    }
                } else {
                    jarFile = new ZipFile(pluginLocation, 1);
                    manifestEntry = jarFile.getEntry(relativePath);
                    if (manifestEntry != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    } else if (relativePath.length() > 5 && relativePath.startsWith("$nl$/") && (manifestEntry = jarFile.getEntry(relativePath.substring(5))) != null) {
                        stream = jarFile.getInputStream(manifestEntry);
                    }
                }
                if (stream == null) break block38;
                desc = ImageDescriptor.createFromImageData((ImageData)new ImageData(stream));
                var10_10 = this.get(desc);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException v0) {}
                return var10_10;
                catch (FileNotFoundException v1) {
                    ** try [egrp 2[TRYBLOCK] [6 : 328->329)] { 
lbl44:
                    // 1 sources

                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block39;
                    }
                    catch (IOException v2) {}
                    break block39;
                }
                catch (IOException v3) {
                    ** try [egrp 4[TRYBLOCK] [7 : 356->357)] { 
lbl-1000:
                    // 3 sources

                    {
                        catch (Throwable var9_11) {
                            try {
                                if (stream != null) {
                                    stream.close();
                                }
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                            }
                            catch (IOException v4) {}
                            throw var9_11;
                        }
                    }
lbl64:
                    // 1 sources

                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        break block39;
                    }
                    catch (IOException v5) {}
                    break block39;
                }
            }
            try {
                if (stream != null) {
                    stream.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException v6) {}
        }
        return this.getBlankImage();
    }

    public Image getBlankImage() {
        if (this.fBlankImage == null) {
            this.fBlankImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.fBlankImage;
    }
}

