/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.description;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tree.description.ConditionalTreeItemStyleDescription;
import org.eclipse.sirius.tree.description.TreeCreationDescription;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeItemStyleDescription;
import org.eclipse.sirius.tree.description.TreeItemTool;
import org.eclipse.sirius.tree.description.TreeNavigationDescription;
import org.eclipse.sirius.tree.description.TreePopupMenu;
import org.eclipse.sirius.tree.description.util.DescriptionSwitch;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class TreeInterpretedExpressionTargetSwitch
extends DescriptionSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected int featureID;
    protected IInterpretedExpressionTargetSwitch globalSwitch;
    private int lastFeatureID;

    public TreeInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch globalSwitch) {
        this.lastFeatureID = this.featureID = feature != null ? feature.getFeatureID() : -1;
        this.globalSwitch = globalSwitch;
    }

    @Override
    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        LinkedHashSet defaultResult = Sets.newLinkedHashSet();
        return Options.newSome((Object)defaultResult);
    }

    private EObject getFirstRelevantContainer(EObject element) {
        return this.globalSwitch.getFirstRelevantContainer(element);
    }

    @Override
    public Option<Collection<String>> caseTreeDescription(TreeDescription object) {
        Option result = null;
        LinkedHashSet target = Sets.newLinkedHashSet();
        switch (this.featureID) {
            case -1: 
            case 4: 
            case 11: {
                target.add(object.getDomainClass());
                result = Options.newSome((Object)target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseTreeItemMapping(TreeItemMapping object) {
        Option result = null;
        LinkedHashSet target = Sets.newLinkedHashSet();
        switch (this.featureID) {
            case 12: {
                result = this.globalSwitch.doSwitch(this.getFirstRelevantContainer(object), false);
                break;
            }
            case -1: 
            case 4: 
            case 11: {
                target.add(object.getDomainClass());
                result = Options.newSome((Object)target);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseTreeCreationDescription(TreeCreationDescription toolDescription) {
        Option result = null;
        LinkedHashSet targets = Sets.newLinkedHashSet();
        switch (this.featureID) {
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                for (RepresentationElementMapping mapping : toolDescription.getMappings()) {
                    Option mappingTypes = this.globalSwitch.doSwitch((EObject)mapping, false);
                    if (!mappingTypes.some()) continue;
                    targets.addAll((Collection)mappingTypes.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseTreeNavigationDescription(TreeNavigationDescription toolDescription) {
        Option result = null;
        LinkedHashSet targets = Sets.newLinkedHashSet();
        switch (this.featureID) {
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                for (RepresentationElementMapping mapping : toolDescription.getMappings()) {
                    Option mappingTypes = this.globalSwitch.doSwitch((EObject)mapping, false);
                    if (!mappingTypes.some()) continue;
                    targets.addAll((Collection)mappingTypes.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseTreeItemStyleDescription(TreeItemStyleDescription object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    @Override
    public Option<Collection<String>> caseConditionalTreeItemStyleDescription(ConditionalTreeItemStyleDescription object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    @Override
    public Option<Collection<String>> caseTreeItemTool(TreeItemTool object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    @Override
    public Option<Collection<String>> caseTreePopupMenu(TreePopupMenu object) {
        return this.globalSwitch.doSwitch(this.getFirstRelevantContainer((EObject)object), false);
    }

    public void setConsiderFeature(boolean considerFeature) {
        if (considerFeature) {
            this.featureID = this.lastFeatureID;
        } else {
            this.lastFeatureID = this.featureID;
            this.featureID = -1;
        }
    }
}

