/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.PointcutElement;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewAspectWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewAspectWizardPage";
    private static final String SETTINGS_CREATEMAIN = "create_main";
    private static final String SETTINGS_CREATEUNIMPLEMENTED_PC = "create_unimplemented_pc";
    private static final String SETTINGS_CREATEUNIMPLEMENTED_METH = "create_unimplemented_meth";
    private final int ISSINGLETON_INDEX = 0;
    private final int PERTHIS_INDEX = 1;
    private final int PERTARGET_INDEX = 2;
    private final int PERCFLOW_INDEX = 3;
    private final int PERCFLOWBELOW_INDEX = 4;
    private final int PERTYPEWITHIN_INDEX = 5;
    private SelectionButtonDialogFieldGroup fStubsButtons;
    private SelectionButtonDialogFieldGroup fPerClauseButtons;
    private SelectionButtonDialogField fPerClauseSelection;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public NewAspectWizardPage() {
        super(1, PAGE_NAME);
        this.setTitle(UIMessages.NewAspectCreationWizardPage_title);
        this.setDescription(UIMessages.NewAspectCreationWizardPage_description);
        String[] buttonNames3 = new String[]{NewWizardMessages.NewClassWizardPage_methods_main, UIMessages.NewAspectCreationWizardPage_pointcuts_inherited, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.fStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames3, 1);
        this.fStubsButtons.setLabelText(UIMessages.NewAspectCreationWizardPage_stubs_label);
        this.fPerClauseSelection = new SelectionButtonDialogField(32);
        this.fPerClauseSelection.setLabelText(UIMessages.NewAspectCreationWizardPage_instantiation_label);
        String[] perClauseButtonNames = new String[]{"i&ssingleton", "p&erthis", "pertar&get", "per&cflow", "pe&rcflowbelow", "pertypewithi&n"};
        this.fPerClauseButtons = new SelectionButtonDialogFieldGroup(16, perClauseButtonNames, 3);
        this.fPerClauseSelection.attachDialogField((DialogField)this.fPerClauseButtons);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        boolean createMain = false;
        boolean createUnimplementedPointcuts = true;
        boolean createUnimplementedMethods = true;
        IDialogSettings section = this.getDialogSettings().getSection(PAGE_NAME);
        if (section != null) {
            createMain = section.getBoolean(SETTINGS_CREATEMAIN);
            createUnimplementedPointcuts = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED_PC);
            createUnimplementedMethods = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED_PC);
        }
        this.setMethodStubSelection(createMain, createUnimplementedPointcuts, createUnimplementedMethods, true);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    @Override
    protected IStatus typeNameChanged() {
        StatusInfo status = (StatusInfo)super.typeNameChanged();
        IPackageFragment pack = this.getPackageFragment();
        if (pack == null) {
            return status;
        }
        IProject project = pack.getJavaProject().getProject();
        if (!AspectJPlugin.isAJProject((IProject)project)) {
            status.setError(NLS.bind((String)UIMessages.NewAspectCreationWizardPage_must_be_AJ_project, (Object)project.getName()));
        }
        if (!this.isEnclosingTypeSelected() && status.getSeverity() < 4 && pack != null) {
            IResource res;
            String typeName = this.getTypeNameWithoutParameters();
            IContainer folder = (IContainer)pack.getResource();
            if (folder != null && (res = folder.findMember(String.valueOf(typeName) + ".aj")) != null) {
                status.setError(NewWizardMessages.NewTypeWizardPage_error_TypeNameExists);
                return status;
            }
        }
        return status;
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createInstantiationControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public boolean isCreateMain() {
        return this.fStubsButtons.isSelected(0);
    }

    public boolean isCreateInheritedPointcuts() {
        return this.fStubsButtons.isSelected(1);
    }

    public boolean isCreateInheritedMethods() {
        return this.fStubsButtons.isSelected(2);
    }

    public void setMethodStubSelection(boolean createMain, boolean createInheritedPointcuts, boolean createInheritedMethods, boolean canBeModified) {
        this.fStubsButtons.setSelection(0, createMain);
        this.fStubsButtons.setSelection(1, createInheritedPointcuts);
        this.fStubsButtons.setSelection(2, createInheritedMethods);
        this.fStubsButtons.setEnabled(canBeModified);
    }

    private String getTypeNameWithoutParameters() {
        String typeNameWithParameters = this.getTypeName();
        int angleBracketOffset = typeNameWithParameters.indexOf(60);
        if (angleBracketOffset == -1) {
            return typeNameWithParameters;
        }
        return typeNameWithParameters.substring(0, angleBracketOffset);
    }

    private void createInstantiationControls(Composite composite, int nColumns) {
        this.fPerClauseSelection.doFillIntoGrid(composite, 1);
        Composite buttonGroup = this.fPerClauseButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        buttonGroup.setLayoutData((Object)gd);
        DialogField.createEmptySpace((Composite)composite);
    }

    private void createStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.fStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createInheritedPointcuts(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) {
        JavaModelException javaModelException2222222;
        block13: {
            IType stype;
            block14: {
                block12: {
                    String supertype = this.getSuperClass();
                    if (supertype.length() == 0) {
                        return;
                    }
                    stype = type.getJavaProject().findType(supertype, AJCompilationUnitManager.defaultAJWorkingCopyOwner());
                    if (stype != null) break block12;
                    String packageName = type.getPackageFragment().getElementName();
                    supertype = String.valueOf(packageName) + "." + supertype;
                    stype = type.getJavaProject().findType(supertype, AJCompilationUnitManager.defaultAJWorkingCopyOwner());
                    if (stype != null) break block12;
                    return;
                }
                try {}
                catch (JavaModelException javaModelException2222222) {
                    // empty catch block
                    break block13;
                }
                break block14;
                catch (JavaModelException javaModelException3) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    JavaModelException javaModelException4 = javaModelException3;
                }
                break block13;
            }
            String simpleName = stype.getElementName();
            ICompilationUnit cu = stype.getCompilationUnit();
            cu = AJCompilationUnitManager.mapToAJCompilationUnit((ICompilationUnit)cu);
            if (!(cu instanceof AJCompilationUnit)) return;
            AJCompilationUnit ajcu = (AJCompilationUnit)cu;
            IType[] stypes = ajcu.getTypes();
            int i = 0;
            while (i < stypes.length) {
                if (stypes[i].getElementName().equals(simpleName) && stypes[i] instanceof AspectElement) {
                    AspectElement aspect = (AspectElement)stypes[i];
                    PointcutElement[] pointcuts = aspect.getPointcuts();
                    int j = 0;
                    while (j < pointcuts.length) {
                        if (Flags.isAbstract((int)pointcuts[j].getFlags())) {
                            String str = "pointcut " + pointcuts[j].getElementName() + "();";
                            if (Flags.isPublic((int)pointcuts[j].getFlags())) {
                                str = "public " + str;
                            } else if (Flags.isProtected((int)pointcuts[j].getFlags())) {
                                str = "protected " + str;
                            }
                            type.createMethod(str, null, false, null);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return;
        }
        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException2222222, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
    }

    @Override
    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        IDialogSettings section;
        boolean doMain;
        boolean doInheritedMethods;
        boolean doInheritedPointcuts = this.isCreateInheritedPointcuts();
        if (doInheritedPointcuts) {
            this.createInheritedPointcuts(type, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (doInheritedMethods = this.isCreateInheritedMethods()) {
            super.createInheritedMethods(type, false, doInheritedMethods, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if (doMain = this.isCreateMain()) {
            StringBuffer buf = new StringBuffer();
            String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"main", (String[])new String[]{"args"}, (String[])new String[0], (String)org.eclipse.jdt.core.Signature.createTypeSignature((String)"void", (boolean)true), null, (String)"\n");
            if (comment != null) {
                buf.append(comment);
                buf.append("\n");
            }
            buf.append("public static void main(");
            buf.append(imports.addImport("java.lang.String"));
            buf.append("[] args) {");
            buf.append("\n");
            String content = CodeGeneration.getMethodBodyContent((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String)"main", (boolean)false, (String)"", (String)"\n");
            if (content != null && content.length() != 0) {
                buf.append(content);
            }
            buf.append("\n");
            buf.append("}");
            type.createMethod(buf.toString(), null, false, null);
        }
        if ((section = this.getDialogSettings().getSection(PAGE_NAME)) == null) {
            section = this.getDialogSettings().addNewSection(PAGE_NAME);
        }
        section.put(SETTINGS_CREATEMAIN, doMain);
        section.put(SETTINGS_CREATEUNIMPLEMENTED_PC, doInheritedPointcuts);
        section.put(SETTINGS_CREATEUNIMPLEMENTED_METH, doInheritedMethods);
        if (monitor != null) {
            monitor.done();
        }
    }

    protected void writePerClause(StringBuffer buf) {
        String s = "";
        if (this.fPerClauseSelection.isSelected()) {
            if (this.fPerClauseButtons.isSelected(0)) {
                s = " issingleton()";
            } else if (this.fPerClauseButtons.isSelected(1)) {
                s = " perthis(pointcut_name())";
            } else if (this.fPerClauseButtons.isSelected(2)) {
                s = " pertarget(pointcut_name())";
            } else if (this.fPerClauseButtons.isSelected(3)) {
                s = " percflow(pointcut_name())";
            } else if (this.fPerClauseButtons.isSelected(4)) {
                s = " percflowbelow(pointcut_name())";
            } else if (this.fPerClauseButtons.isSelected(5)) {
                s = " pertypewithin(type_pattern)";
            }
        }
        buf.append(s);
    }

    static {
        NewAspectWizardPage.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("NewAspectWizardPage.java", NewAspectWizardPage.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewAspectWizardPage", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 366);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createInheritedPointcuts", "org.eclipse.ajdt.internal.ui.wizards.NewAspectWizardPage", "org.eclipse.jdt.core.IType:org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage$ImportsManager:org.eclipse.core.runtime.IProgressMonitor", "type:imports:monitor", "", "void"), 318);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewAspectWizardPage", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 366);
    }
}

