/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.config;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.SourceException;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IRegistryService;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.InvalidTemplateParameterException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.handlers.impl.config.Parameters;

public class ConfigurationService
extends AbstractService
implements IConfigurationService {
    private int version = 2;
    private String language = "acceleo";
    private boolean runV1 = false;
    private String output;
    private Parameters parameters;
    private String importedDiagrams;
    private Pattern patternParam = Pattern.compile("\\$\\{[a-zA-Z0-9_]+\\}");

    public ConfigurationService() {
        this.parameters = new Parameters();
    }

    public void clear() {
        this.parameters.clear();
    }

    public String replaceParameters(String path) throws InvalidTemplateParameterException {
        if (path == null) {
            return null;
        }
        Matcher m = this.patternParam.matcher(path);
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (m.find()) {
            buffer.append(path.substring(index, m.start()));
            String paramName = path.substring(m.start() + 2, m.end() - 1);
            String value = this.getParameter(paramName);
            if (value == null) {
                throw new InvalidTemplateParameterException(paramName, "No value found for parameter.");
            }
            buffer.append(value);
            index = m.end();
        }
        buffer.append(path.substring(index, path.length()));
        return buffer.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = Integer.valueOf(version);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean isRunV1() {
        return this.runV1;
    }

    public void setRunV1(String runV1) {
        this.runV1 = Boolean.valueOf(runV1);
    }

    public String getOutput() throws GenDocException {
        if (this.output == null) {
            this.initOutputFile();
        }
        return this.output;
    }

    public void setOutput(String outputPath) throws GenDocException {
        if (outputPath == null || outputPath.length() == 0) {
            this.initOutputFile();
        } else {
            StringBuffer newOutput = new StringBuffer(outputPath);
            String dirPath = this.getDirectory(outputPath);
            File dir = new File(dirPath);
            if (!dir.isDirectory()) {
                dir.mkdir();
            }
            if ("".equals(this.getFile(outputPath))) {
                Document template = ((IDocumentService)GendocServices.getDefault().getService(IDocumentService.class)).getDocument();
                String filePath = template.getPath().substring(template.getPath().lastIndexOf(47) + 1, template.getPath().length());
                filePath = this.addGeneratedPart(filePath);
                if (newOutput.toString().endsWith("/")) {
                    newOutput.append(filePath);
                } else {
                    newOutput.append("/" + filePath);
                }
            }
            this.output = newOutput.toString();
        }
    }

    private String getFile(String path) {
        String fileName = path.substring(path.lastIndexOf(47), path.length());
        if (!"".equals(fileName)) {
            fileName = !fileName.contains(".") ? "" : fileName.substring(1);
        }
        return fileName;
    }

    private String getDirectory(String path) {
        if ("".equals(this.getFile(path))) {
            return path;
        }
        return path.substring(0, path.lastIndexOf(47));
    }

    private void initOutputFile() throws GenDocException {
        Document template = ((IDocumentService)GendocServices.getDefault().getService(IDocumentService.class)).getDocument();
        if (!"file".equals(template.getDocumentURL().getProtocol())) {
            throw new SourceException(String.format("Your input document %s uses the protocol %s please specify an output path in config tag", template.getDocumentURL().getPath(), template.getDocumentURL().getProtocol()));
        }
        String fileName = template.getPath();
        this.output = this.addGeneratedPart(fileName);
    }

    public String getParameter(String name) {
        if (name != null) {
            return this.parameters.get(name.toLowerCase());
        }
        return "";
    }

    public void addParameter(String name, String value) {
        if (name != null) {
            this.parameters.put(name.toLowerCase(), value);
            this.addParameterToRegistry(name, value);
        }
    }

    public String getImportedDiagrams() {
        return this.importedDiagrams;
    }

    public void setImportedDiagrams(String importedDiagrams) {
        this.importedDiagrams = importedDiagrams;
    }

    private String addGeneratedPart(String filePath) {
        StringBuffer buffer = new StringBuffer(filePath);
        buffer.insert(buffer.lastIndexOf("."), "_generated");
        return buffer.toString();
    }

    protected void addParameterToRegistry(String key, String value) {
        IRegistryService registry = (IRegistryService)GendocServices.getDefault().getService(IRegistryService.class);
        if (registry != null && key != null) {
            registry.put((Object)key, (Object)value);
        }
    }
}

