/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.InvalidTemplateParameterException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.handlers.IPropertiesService;

public class PropertiesServices
extends AbstractService
implements IPropertiesService {
    @Override
    public void setPropertiesFile(File file) {
        if (file.getPath() != null && file.getPath().endsWith("properties")) {
            this.managePropertiesFile(file);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void managePropertiesFile(File file) {
        IConfigurationService config = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        BufferedInputStream inStream = null;
        try {
            Properties p = new Properties();
            inStream = new BufferedInputStream(new FileInputStream(file));
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)file.getAbsolutePath());
            IFile ifile = workspace.getRoot().getFileForLocation(location);
            Charset charset = null;
            if (ifile != null && ifile.exists()) {
                try {
                    charset = Charset.forName(ifile.getCharset());
                    InputStreamReader reader = new InputStreamReader((InputStream)inStream, charset);
                    p.load(reader);
                }
                catch (CoreException coreException) {
                    p.load(inStream);
                }
            } else {
                p.load(inStream);
            }
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                if (!(e.getKey() instanceof String) || !(e.getValue() instanceof String)) continue;
                config.addParameter((String)e.getKey(), config.replaceParameters((String)e.getValue()));
            }
        }
        catch (FileNotFoundException e) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log(e.getMessage(), 4);
            if (inStream == null) return;
            try {
                inStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log(e.getMessage(), 4);
            if (inStream == null) return;
            try {
                inStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (InvalidTemplateParameterException e1) {
            e1.printStackTrace();
            if (inStream == null) return;
            {
                catch (Throwable throwable) {
                    if (inStream == null) throw throwable;
                    try {
                        inStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                inStream.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (inStream == null) return;
        try {
            inStream.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

